/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.commons;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class CollectionUtil {
    public static Map<String, Object> buildSimpleMap(String key, Object value) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put(key, value);
        return result;
    }

    public static <T> List<T> emptyOrUnmodifiable(List<T> list) {
        return list == null ? Collections.emptyList() : Collections.unmodifiableList(list);
    }

    public static <T> List<List<T>> split(List<T> source, int chunkSize) {
        if (chunkSize <= 0) {
            throw new IllegalArgumentException("can't split a list with a chunkSize = " + chunkSize);
        }
        int size = source.size();
        if (size <= 0) {
            return Collections.emptyList();
        }
        return IntStream.range(0, size / chunkSize + (size % chunkSize == 0 ? 0 : 1)).mapToObj(n -> source.subList(n * chunkSize, Math.min(size, (n + 1) * chunkSize))).collect(Collectors.toList());
    }
}

