/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.log.technical;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLogger;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated(forRemoval=true, since="7.15.0")
public class TechnicalLoggerSLF4JImpl
implements TechnicalLoggerService {
    private String hostname = null;
    private final long tenantId;

    public TechnicalLoggerSLF4JImpl() {
        this(-1L);
    }

    public TechnicalLoggerSLF4JImpl(long tenantId) {
        try {
            this.hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        this.tenantId = tenantId;
    }

    @Override
    public void log(Class<?> callerClass, TechnicalLogSeverity severity, Throwable t) {
        this.log(callerClass, severity, t.getMessage(), t);
    }

    @Override
    public TechnicalLogger asLogger(Class<?> clazz) {
        return new TechnicalLogger(clazz, this);
    }

    @Override
    public void log(Class<?> callerClass, TechnicalLogSeverity severity, String message) {
        if (!this.isLoggable(callerClass, severity)) {
            return;
        }
        Logger logger = this.getLogger(callerClass);
        String loggedMessage = this.getContextMessage() + message;
        switch (severity) {
            case TRACE: {
                logger.trace(loggedMessage);
                break;
            }
            case DEBUG: {
                logger.debug(loggedMessage);
                break;
            }
            case INFO: {
                logger.info(loggedMessage);
                break;
            }
            case WARNING: {
                logger.warn(loggedMessage);
                break;
            }
            case ERROR: {
                logger.error(loggedMessage);
                break;
            }
            default: {
                logger.error("Trying to log using an unknown severity, using ERROR instead: {}", (Object)severity);
                logger.error(loggedMessage);
            }
        }
    }

    @Override
    public void log(Class<?> callerClass, TechnicalLogSeverity severity, String message, Object ... arguments) {
        if (!this.isLoggable(callerClass, severity)) {
            return;
        }
        Logger logger = this.getLogger(callerClass);
        String loggedMessage = this.getContextMessage() + message;
        switch (severity) {
            case TRACE: {
                logger.trace(loggedMessage, arguments);
                break;
            }
            case DEBUG: {
                logger.debug(loggedMessage, arguments);
                break;
            }
            case INFO: {
                logger.info(loggedMessage, arguments);
                break;
            }
            case WARNING: {
                logger.warn(loggedMessage, arguments);
                break;
            }
            case ERROR: {
                logger.error(loggedMessage, arguments);
                break;
            }
            default: {
                logger.error("Trying to log using an unknown severity, using ERROR instead: {}", (Object)severity);
                logger.error(loggedMessage, arguments);
            }
        }
    }

    @Override
    public void log(Class<?> callerClass, TechnicalLogSeverity severity, String message, Throwable t) {
        if (!this.isLoggable(callerClass, severity)) {
            return;
        }
        Logger logger = this.getLogger(callerClass);
        String loggedMessage = this.getContextMessage() + message;
        switch (severity) {
            case TRACE: {
                logger.trace(loggedMessage, t);
                break;
            }
            case DEBUG: {
                logger.debug(loggedMessage, t);
                break;
            }
            case INFO: {
                logger.info(loggedMessage, t);
                break;
            }
            case WARNING: {
                logger.warn(loggedMessage, t);
                break;
            }
            case ERROR: {
                logger.error(loggedMessage, t);
                break;
            }
            default: {
                logger.error("Trying to log using an unknown severity, using ERROR instead: {}", (Object)severity);
                logger.error(loggedMessage);
            }
        }
    }

    @Override
    public boolean isLoggable(Class<?> callerClass, TechnicalLogSeverity severity) {
        Logger logger = this.getLogger(callerClass);
        switch (severity) {
            case TRACE: {
                return logger.isTraceEnabled();
            }
            case DEBUG: {
                return logger.isDebugEnabled();
            }
            case INFO: {
                return logger.isInfoEnabled();
            }
            case WARNING: {
                return logger.isWarnEnabled();
            }
            case ERROR: {
                return logger.isErrorEnabled();
            }
        }
        logger.error("Trying to log using an unknown severity, using ERROR instead: {}", (Object)severity);
        return logger.isErrorEnabled();
    }

    private Logger getLogger(Class<?> clazz) {
        return LoggerFactory.getLogger(clazz);
    }

    private String getContextMessage() {
        return this.getThreadIdMessage() + this.getHostNameMessage() + this.getTenantIdMessage();
    }

    private String getThreadIdMessage() {
        long threadId = Thread.currentThread().getId();
        return "THREAD_ID=" + threadId + " | ";
    }

    private String getHostNameMessage() {
        return this.hostname != null && !this.hostname.isEmpty() ? "HOSTNAME=" + this.hostname + " | " : "";
    }

    private String getTenantIdMessage() {
        return this.tenantId != -1L ? "TENANT_ID=" + this.tenantId + " | " : "";
    }
}

