/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.commons;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class ExceptionUtils {
    public static String printLightWeightStacktrace(Throwable exception) {
        return ExceptionUtils.printLightWeightStacktrace(exception, 5);
    }

    public static String printLightWeightStacktrace(Throwable exception, int numberOfFrames) {
        List throwableList = org.apache.commons.lang3.exception.ExceptionUtils.getThrowableList((Throwable)exception);
        if (throwableList.isEmpty()) {
            return null;
        }
        Collections.reverse(throwableList);
        Throwable rootCause = (Throwable)throwableList.get(0);
        return throwableList.stream().map(ExceptionUtils::print).collect(Collectors.joining("\n\twrapped by ")) + "\n exception was generated here:" + ExceptionUtils.getStacktrace(rootCause, numberOfFrames);
    }

    private static String getStacktrace(Throwable t, int numberOfFrames) {
        String[] stackFrames = org.apache.commons.lang3.exception.ExceptionUtils.getStackFrames((Throwable)t);
        return Arrays.stream(stackFrames).skip(1L).limit(numberOfFrames).collect(Collectors.joining("\n"));
    }

    protected static String print(Throwable e) {
        return e.getClass().getName() + ": " + StringUtils.defaultString((String)e.getMessage());
    }

    public static String printRootCauseOnly(Throwable exception) {
        return ExceptionUtils.print(org.apache.commons.lang3.exception.ExceptionUtils.getRootCause((Throwable)exception));
    }
}

