/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.service;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.bonitasoft.engine.commons.PlatformLifecycleService;
import org.bonitasoft.engine.service.RunnableWithException;

public class BonitaTaskExecutor
implements PlatformLifecycleService {
    private ExecutorService bonitaTaskExecutor;

    private void checkStarted() {
        if (this.bonitaTaskExecutor == null) {
            throw new IllegalStateException(this.getClass().getName() + " is not running");
        }
    }

    public Future<?> execute(RunnableWithException runnable) {
        return this.execute(() -> {
            runnable.run();
            return null;
        });
    }

    public <T> Future<T> execute(Callable<T> callable) {
        this.checkStarted();
        return this.bonitaTaskExecutor.submit(callable);
    }

    @Override
    public void start() {
        if (this.bonitaTaskExecutor == null) {
            this.bonitaTaskExecutor = Executors.newCachedThreadPool(r -> new Thread(r, "BonitaTaskExecutor"));
        }
    }

    @Override
    public void stop() {
        if (this.bonitaTaskExecutor != null) {
            this.bonitaTaskExecutor.shutdown();
            this.bonitaTaskExecutor = null;
        }
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }
}

