/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.commons;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class Pair<L, R>
implements Serializable,
Map.Entry<L, R> {
    private static final long serialVersionUID = 1L;
    private L left;
    private R right;

    public Pair(L left, R right) {
        this.left = left;
        this.right = right;
    }

    public static <L, R> Pair<L, R> of(L left, R right) {
        return new Pair<L, R>(left, right);
    }

    public static <L, R> Pair<L, R> pair(L left, R right) {
        return Pair.of(left, right);
    }

    public static <L, R> Map<L, R> mapOf(Pair<L, R> ... entries) {
        HashMap<L, R> map = new HashMap<L, R>();
        for (Pair<L, R> entry : entries) {
            map.put(entry.getKey(), entry.getValue());
        }
        return map;
    }

    public L getLeft() {
        return this.left;
    }

    public R getRight() {
        return this.right;
    }

    @Override
    public final L getKey() {
        return this.getLeft();
    }

    @Override
    public R getValue() {
        return this.getRight();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.left == null ? 0 : this.left.hashCode());
        result = 31 * result + (this.right == null ? 0 : this.right.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Pair other = (Pair)obj;
        if (this.left == null ? other.left != null : !this.left.equals(other.left)) {
            return false;
        }
        return !(this.right == null ? other.right != null : !this.right.equals(other.right));
    }

    public String toString() {
        return "(" + this.getLeft() + "," + this.getRight() + ")";
    }

    @Override
    public R setValue(R right) {
        R oldRight = this.right;
        this.right = right;
        return oldRight;
    }

    public L setKey(L left) {
        L oldLeft = this.left;
        this.left = left;
        return oldLeft;
    }
}

