/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.commons;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.AbstractConverter;
import org.apache.commons.beanutils.converters.DateConverter;

public class TypeConverterUtil {
    private ConvertUtilsBean convertUtilsBean = new ConvertUtilsBean();

    public TypeConverterUtil(String[] datePatterns) {
        DateConverter dateConverter = new DateConverter();
        dateConverter.setPatterns(datePatterns);
        dateConverter.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.convertUtilsBean.register((Converter)dateConverter, Date.class);
        this.convertUtilsBean.register((Converter)new LocalDateTimeConverter(), LocalDateTime.class);
        this.convertUtilsBean.register((Converter)new LocalDateConverter(), LocalDate.class);
        this.convertUtilsBean.register((Converter)new OffsetDateTimeConverter(), OffsetDateTime.class);
    }

    public Object convertToType(Class<? extends Serializable> clazz, Serializable parameterValue) {
        try {
            return this.convertUtilsBean.convert((Object)parameterValue, clazz);
        }
        catch (ConversionException e) {
            throw new IllegalArgumentException("unable to parse '" + parameterValue + "' to type " + clazz.getName());
        }
    }

    private class OffsetDateTimeConverter
    extends AbstractConverter {
        private OffsetDateTimeConverter() {
        }

        protected <T> T convertToType(Class<T> type, Object value) throws Throwable {
            if (!(value instanceof String)) {
                throw this.conversionException(type, value);
            }
            return type.cast(OffsetDateTime.parse((CharSequence)value));
        }

        protected Class<?> getDefaultType() {
            return OffsetDateTime.class;
        }
    }

    private class LocalDateTimeConverter
    extends AbstractConverter {
        private LocalDateTimeConverter() {
        }

        protected <T> T convertToType(Class<T> type, Object value) throws Throwable {
            if (!(value instanceof String)) {
                throw this.conversionException(type, value);
            }
            String paramValueString = (String)value;
            try {
                return type.cast(LocalDateTime.parse(paramValueString));
            }
            catch (DateTimeParseException e) {
                return type.cast(ZonedDateTime.parse(paramValueString).toLocalDateTime());
            }
        }

        protected Class<?> getDefaultType() {
            return LocalDateTime.class;
        }
    }

    private class LocalDateConverter
    extends AbstractConverter {
        static final int MAX_LOCAL_DATE_LENGTH = 10;

        private LocalDateConverter() {
        }

        protected <T> T convertToType(Class<T> type, Object value) throws Throwable {
            if (!(value instanceof String)) {
                throw this.conversionException(type, value);
            }
            String valueAsString = (String)value;
            if (valueAsString.length() > 10) {
                valueAsString = valueAsString.substring(0, 10);
            }
            return type.cast(LocalDate.parse(valueAsString));
        }

        protected Class<?> getDefaultType() {
            return LocalDate.class;
        }
    }
}

