/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.monitoring;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.binder.jvm.ExecutorServiceMetrics;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import org.bonitasoft.engine.monitoring.ExecutorServiceMetricsProvider;

public class DefaultExecutorServiceMetricsProvider
implements ExecutorServiceMetricsProvider {
    @Override
    public ExecutorService bind(MeterRegistry meterRegistry, ThreadPoolExecutor executorService, String executorServiceName, long tenantId) {
        return ExecutorServiceMetrics.monitor((MeterRegistry)meterRegistry, (ExecutorService)executorService, (String)executorServiceName, (Iterable)Tags.of((String)"tenant", (String)String.valueOf(tenantId)));
    }

    @Override
    public void bindMetricsOnly(MeterRegistry meterRegistry, ThreadPoolExecutor executorService, String executorServiceName, long tenantId) {
        new ExecutorServiceMetrics((ExecutorService)executorService, executorServiceName, (Iterable)Tags.of((String)"tenant", (String)String.valueOf(tenantId))).bindTo(meterRegistry);
    }

    @Override
    public void unbind(MeterRegistry meterRegistry, String executorServiceName, long tenantId) {
        Tags tags = Tags.of((String[])new String[]{"name", executorServiceName, "tenant", String.valueOf(tenantId)});
        Optional.ofNullable(meterRegistry.find("executor").tags((Iterable)tags).timer()).ifPresent(arg_0 -> ((MeterRegistry)meterRegistry).remove(arg_0));
        Optional.ofNullable(meterRegistry.find("executor.active").tags((Iterable)tags).gauge()).ifPresent(arg_0 -> ((MeterRegistry)meterRegistry).remove(arg_0));
        Optional.ofNullable(meterRegistry.find("executor.pool.size").tags((Iterable)tags).gauge()).ifPresent(arg_0 -> ((MeterRegistry)meterRegistry).remove(arg_0));
        Optional.ofNullable(meterRegistry.find("executor.pool.max").tags((Iterable)tags).gauge()).ifPresent(arg_0 -> ((MeterRegistry)meterRegistry).remove(arg_0));
        Optional.ofNullable(meterRegistry.find("executor.pool.core").tags((Iterable)tags).gauge()).ifPresent(arg_0 -> ((MeterRegistry)meterRegistry).remove(arg_0));
        Optional.ofNullable(meterRegistry.find("executor.queue.remaining").tags((Iterable)tags).gauge()).ifPresent(arg_0 -> ((MeterRegistry)meterRegistry).remove(arg_0));
        Optional.ofNullable(meterRegistry.find("executor.queued").tags((Iterable)tags).gauge()).ifPresent(arg_0 -> ((MeterRegistry)meterRegistry).remove(arg_0));
        Optional.ofNullable(meterRegistry.find("executor.completed").tags((Iterable)tags).functionCounter()).ifPresent(arg_0 -> ((MeterRegistry)meterRegistry).remove(arg_0));
        Optional.ofNullable(meterRegistry.find("executor.idle").tags((Iterable)tags).timer()).ifPresent(arg_0 -> ((MeterRegistry)meterRegistry).remove(arg_0));
    }
}

