/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.spring.autoconfigure;

import org.bonitasoft.engine.BonitaEngine;
import org.springframework.beans.BeansException;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
public class BonitaEngineEventListener
implements ApplicationContextAware {
    private ApplicationContext context;
    private BonitaEngine bonitaEngine;

    @EventListener
    public void handleApplicationReadyEvent(ApplicationReadyEvent applicationReadyEvent) throws Exception {
        this.bonitaEngine = (BonitaEngine)applicationReadyEvent.getApplicationContext().getBean(BonitaEngine.class);
        this.bonitaEngine.start();
    }

    @EventListener
    public void handleContextStoppedEvent(ContextClosedEvent contextClosedEvent) throws Exception {
        if (this.bonitaEngine != null && this.context == contextClosedEvent.getApplicationContext()) {
            this.bonitaEngine.stop();
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }
}

