/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.spring.autoconfigure;

import org.bonitasoft.engine.BonitaEngine;
import org.bonitasoft.engine.api.APIClient;
import org.bonitasoft.engine.spring.autoconfigure.BonitaEngineCommonAutoConfiguration;
import org.bonitasoft.engine.spring.autoconfigure.properties.BonitaEngineProperties;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureBefore(value={BonitaEngineCommonAutoConfiguration.class})
public class BonitaEngineServerAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    BonitaEngine bonitaEngine(BonitaEngineProperties properties) {
        BonitaEngine instance = new BonitaEngine();
        instance.setBonitaDatabaseConfiguration(properties.getDatabase().getBonita());
        instance.setBusinessDataDatabaseConfiguration(properties.getDatabase().getBusinessData());
        return instance;
    }

    @Bean
    @ConditionalOnMissingBean
    APIClient bonitaClient() {
        return new APIClient();
    }
}

