/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.identity.impl;

import java.util.Date;
import java.util.Objects;
import java.util.StringJoiner;
import org.bonitasoft.engine.identity.Group;

public class GroupImpl
implements Group {
    private static final long serialVersionUID = 3063794706652296174L;
    private final long id;
    private final String name;
    private String displayName;
    private String description;
    private long createdBy;
    private String parentPath;
    private Date creationDate;
    private Date lastUpdate;
    private Long iconId;

    public GroupImpl(long id, String name) {
        this.id = id;
        this.name = name;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setCreatedBy(long createdBy) {
        this.createdBy = createdBy;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public void setLastUpdate(Date lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public void setParentPath(String parentPath) {
        this.parentPath = parentPath;
    }

    @Override
    public long getCreatedBy() {
        return this.createdBy;
    }

    @Override
    public Date getCreationDate() {
        return this.creationDate;
    }

    @Override
    public Date getLastUpdate() {
        return this.lastUpdate;
    }

    @Override
    public String getParentPath() {
        return this.parentPath;
    }

    @Override
    public String getPath() {
        if (this.parentPath == null) {
            return "/" + this.getName();
        }
        return this.parentPath + "/" + this.getName();
    }

    @Override
    public Long getIconId() {
        return this.iconId;
    }

    public void setIconId(Long iconId) {
        this.iconId = iconId;
    }

    public String toString() {
        return new StringJoiner(", ", GroupImpl.class.getSimpleName() + "[", "]").add("id=" + this.id).add("name='" + this.name + "'").add("displayName='" + this.displayName + "'").add("description='" + this.description + "'").add("createdBy=" + this.createdBy).add("parentPath='" + this.parentPath + "'").add("creationDate=" + String.valueOf(this.creationDate)).add("lastUpdate=" + String.valueOf(this.lastUpdate)).add("iconId=" + this.iconId).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GroupImpl group = (GroupImpl)o;
        return this.id == group.id && this.createdBy == group.createdBy && Objects.equals(this.name, group.name) && Objects.equals(this.displayName, group.displayName) && Objects.equals(this.description, group.description) && Objects.equals(this.parentPath, group.parentPath) && Objects.equals(this.creationDate, group.creationDate) && Objects.equals(this.lastUpdate, group.lastUpdate) && Objects.equals(this.iconId, group.iconId);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.displayName, this.description, this.createdBy, this.parentPath, this.creationDate, this.lastUpdate, this.iconId);
    }
}

