/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.operation;

import org.bonitasoft.engine.expression.Expression;
import org.bonitasoft.engine.operation.LeftOperand;
import org.bonitasoft.engine.operation.LeftOperandBuilder;
import org.bonitasoft.engine.operation.Operation;
import org.bonitasoft.engine.operation.OperatorType;
import org.bonitasoft.engine.operation.impl.OperationImpl;

public class OperationBuilder {
    private OperationImpl operation;

    public OperationBuilder createNewInstance() {
        this.operation = new OperationImpl();
        return this;
    }

    public OperationBuilder setLeftOperand(LeftOperand leftOperand) {
        this.operation.setLeftOperand(leftOperand);
        return this;
    }

    public OperationBuilder setLeftOperand(String name, String type) {
        this.operation.setLeftOperand(new LeftOperandBuilder().createNewInstance(name).setType(type).done());
        return this;
    }

    public OperationBuilder setType(OperatorType operatorType) {
        this.operation.setType(operatorType);
        return this;
    }

    public OperationBuilder setOperator(String operator) {
        this.operation.setOperator(operator);
        return this;
    }

    public OperationBuilder setOperatorInputType(String operatorInputType) {
        this.operation.setOperatorInputType(operatorInputType);
        return this;
    }

    public OperationBuilder setRightOperand(Expression rightOperand) {
        this.operation.setRightOperand(rightOperand);
        return this;
    }

    public Operation createSetDataOperation(String dataName, Expression expression) {
        return this.createNewInstance().setLeftOperand(dataName, "DATA").setRightOperand(expression).setType(OperatorType.ASSIGNMENT).done();
    }

    public Operation createBusinessDataSetAttributeOperation(String businessDataName, String methodName, String methodParamType, Expression expression) {
        return this.createNewInstance().setLeftOperand(new LeftOperandBuilder().createBusinessDataLeftOperand(businessDataName)).setRightOperand(expression).setType(OperatorType.JAVA_METHOD).setOperator(methodName).setOperatorInputType(methodParamType).done();
    }

    public Operation attachBusinessDataSetAttributeOperation(String businessDataName, Expression expressionReturningBusinessData) {
        return this.createNewInstance().setLeftOperand(new LeftOperandBuilder().createBusinessDataLeftOperand(businessDataName)).setRightOperand(expressionReturningBusinessData).setType(OperatorType.ASSIGNMENT).done();
    }

    public Operation deleteBusinessDataOperation(String businessDataName) {
        return this.createNewInstance().setLeftOperand(new LeftOperandBuilder().createBusinessDataLeftOperand(businessDataName)).setType(OperatorType.DELETION).done();
    }

    public Operation createSetDocument(String docName, Expression expression) {
        return this.createNewInstance().setLeftOperand(docName, "DOCUMENT").setType(OperatorType.ASSIGNMENT).setRightOperand(expression).done();
    }

    public Operation createSetDocumentList(String docName, Expression expression) {
        return this.createNewInstance().setLeftOperand(docName, "DOCUMENT_LIST").setType(OperatorType.ASSIGNMENT).setRightOperand(expression).done();
    }

    public Operation createXPathOperation(String xmlName, String xPath, Expression setValue) {
        return this.createNewInstance().setLeftOperand(xmlName, "DATA").setType(OperatorType.XPATH_UPDATE_QUERY).setOperator(xPath).setRightOperand(setValue).done();
    }

    public Operation createJavaMethodOperation(String objectName, String methodName, String methodParamType, Expression methodParams) {
        return this.createNewInstance().setLeftOperand(objectName, "DATA").setType(OperatorType.JAVA_METHOD).setOperator(methodName).setOperatorInputType(methodParamType).setRightOperand(methodParams).done();
    }

    public Operation createSetStringIndexOperation(int index, Expression setValue) {
        return this.createNewInstance().setLeftOperand(new LeftOperandBuilder().createSearchIndexLeftOperand(index)).setType(OperatorType.ASSIGNMENT).setRightOperand(setValue).done();
    }

    public Operation done() {
        if (this.operation.getType() == null) {
            throw new IllegalStateException("The type of the expression is not set");
        }
        return this.operation;
    }

    public static Operation getNonNullCopy(Operation operation) {
        return operation != null ? operation.copy() : null;
    }
}

