/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bpm.process.impl.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlIDREF;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import org.bonitasoft.engine.bpm.actor.ActorDefinition;
import org.bonitasoft.engine.bpm.actor.impl.ActorDefinitionImpl;
import org.bonitasoft.engine.bpm.context.ContextEntry;
import org.bonitasoft.engine.bpm.context.ContextEntryImpl;
import org.bonitasoft.engine.bpm.contract.ContractDefinition;
import org.bonitasoft.engine.bpm.contract.impl.ContractDefinitionImpl;
import org.bonitasoft.engine.bpm.flownode.FlowElementContainerDefinition;
import org.bonitasoft.engine.bpm.flownode.impl.internal.FlowElementContainerDefinitionImpl;
import org.bonitasoft.engine.bpm.parameter.ParameterDefinition;
import org.bonitasoft.engine.bpm.parameter.impl.ParameterDefinitionImpl;
import org.bonitasoft.engine.bpm.process.DesignProcessDefinition;
import org.bonitasoft.engine.bpm.process.ModelFinderVisitor;
import org.bonitasoft.engine.bpm.process.Visitable;
import org.bonitasoft.engine.bpm.process.impl.internal.IndexLabel;
import org.bonitasoft.engine.bpm.process.impl.internal.ProcessDefinitionImpl;
import org.bonitasoft.engine.bpm.process.impl.internal.SubProcessDefinitionImpl;
import org.bonitasoft.engine.expression.Expression;
import org.bonitasoft.engine.expression.ExpressionBuilder;

@XmlRootElement(name="processDefinition")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlSeeAlso(value={SubProcessDefinitionImpl.class})
public class DesignProcessDefinitionImpl
extends ProcessDefinitionImpl
implements DesignProcessDefinition,
Visitable {
    private static final long serialVersionUID = -4719128363958199300L;
    @XmlAttribute
    private String displayName;
    @XmlElement
    private String displayDescription;
    @XmlElementWrapper(name="parameters")
    @XmlElement(type=ParameterDefinitionImpl.class, name="parameter")
    private final Set<ParameterDefinition> parameters;
    @XmlElementWrapper(name="actors")
    @XmlElement(type=ActorDefinitionImpl.class, name="actor")
    private final List<ActorDefinition> actors;
    @XmlIDREF
    @XmlElement(type=ActorDefinitionImpl.class)
    private ActorDefinition actorInitiator;
    @XmlElement(type=FlowElementContainerDefinitionImpl.class, name="flowElements", nillable=true)
    private FlowElementContainerDefinition flowElementContainer;
    @XmlElementWrapper(name="stringIndexes", required=false, nillable=true)
    @XmlElement(name="stringIndex")
    private IndexLabel[] listIndex = new IndexLabel[5];
    @XmlElement(type=ContractDefinitionImpl.class)
    private ContractDefinition contract;
    @XmlElementWrapper(name="context")
    @XmlElement(name="contextEntry", type=ContextEntryImpl.class, nillable=true)
    private List<ContextEntry> context = new ArrayList<ContextEntry>();

    public DesignProcessDefinitionImpl(String name, String version) {
        super(name, version);
        this.parameters = new HashSet<ParameterDefinition>();
        this.actors = new ArrayList<ActorDefinition>();
        this.initStringIndexes();
    }

    void initStringIndexes() {
        for (int i = 0; i < 5; ++i) {
            this.listIndex[i] = new IndexLabel(Integer.toString(i + 1), null, null);
        }
    }

    public DesignProcessDefinitionImpl() {
        this.parameters = new HashSet<ParameterDefinition>();
        this.actors = new ArrayList<ActorDefinition>();
        this.initStringIndexes();
    }

    @Override
    public List<ActorDefinition> getActorsList() {
        return this.actors;
    }

    public void addParameter(ParameterDefinition parameter) {
        this.parameters.add(parameter);
    }

    public void addActor(ActorDefinition actor) {
        this.actors.add(actor);
    }

    @Override
    public FlowElementContainerDefinition getProcessContainer() {
        return this.getFlowElementContainer();
    }

    public void setProcessContainer(FlowElementContainerDefinition processContainer) {
        this.flowElementContainer = processContainer;
    }

    @Override
    public FlowElementContainerDefinition getFlowElementContainer() {
        return this.flowElementContainer;
    }

    @Override
    public String getStringIndexLabel(int index) {
        switch (index) {
            case 1: {
                return this.listIndex[0].getLabel();
            }
            case 2: {
                return this.listIndex[1].getLabel();
            }
            case 3: {
                return this.listIndex[2].getLabel();
            }
            case 4: {
                return this.listIndex[3].getLabel();
            }
            case 5: {
                return this.listIndex[4].getLabel();
            }
        }
        throw new IndexOutOfBoundsException("string index label must be between 1 and 5 (included)");
    }

    @Override
    public Expression getStringIndexValue(int index) {
        switch (index) {
            case 1: {
                return this.listIndex[0].getValue();
            }
            case 2: {
                return this.listIndex[1].getValue();
            }
            case 3: {
                return this.listIndex[2].getValue();
            }
            case 4: {
                return this.listIndex[3].getValue();
            }
            case 5: {
                return this.listIndex[4].getValue();
            }
        }
        throw new IndexOutOfBoundsException("string index value must be between 1 and 5 (included)");
    }

    public ActorDefinition getActor(String actorName) {
        Iterator<ActorDefinition> iterator = this.actors.iterator();
        ActorDefinition actorDefinition = null;
        boolean found = false;
        while (!found && iterator.hasNext()) {
            ActorDefinition next = iterator.next();
            if (!next.getName().equals(actorName)) continue;
            found = true;
            actorDefinition = next;
        }
        return actorDefinition;
    }

    public void setStringIndex(int index, String label, Expression initialValue) {
        switch (index) {
            case 1: {
                this.listIndex[0] = new IndexLabel("1", label, ExpressionBuilder.getNonNullCopy(initialValue));
                break;
            }
            case 2: {
                this.listIndex[1] = new IndexLabel("2", label, ExpressionBuilder.getNonNullCopy(initialValue));
                break;
            }
            case 3: {
                this.listIndex[2] = new IndexLabel("3", label, ExpressionBuilder.getNonNullCopy(initialValue));
                break;
            }
            case 4: {
                this.listIndex[3] = new IndexLabel("4", label, ExpressionBuilder.getNonNullCopy(initialValue));
                break;
            }
            case 5: {
                this.listIndex[4] = new IndexLabel("5", label, ExpressionBuilder.getNonNullCopy(initialValue));
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("string index label must be between 1 and 5 (included)");
            }
        }
    }

    @Override
    public List<ContextEntry> getContext() {
        if (this.context == null) {
            return Collections.emptyList();
        }
        return this.context;
    }

    public void addContextEntry(ContextEntry contextEntry) {
        if (this.context == null) {
            this.context = new ArrayList<ContextEntry>();
        }
        this.context.add(contextEntry);
    }

    @Override
    public void accept(ModelFinderVisitor visitor, long modelId) {
        visitor.find(this, modelId);
    }

    @Override
    public List<String> getStringIndexLabels() {
        return Arrays.asList(this.getStringIndexLabel(1), this.getStringIndexLabel(2), this.getStringIndexLabel(3), this.getStringIndexLabel(4), this.getStringIndexLabel(5));
    }

    @Override
    public List<Expression> getStringIndexValues() {
        return Arrays.asList(this.getStringIndexValue(1), this.getStringIndexValue(2), this.getStringIndexValue(3), this.getStringIndexValue(4), this.getStringIndexValue(5));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DesignProcessDefinitionImpl that = (DesignProcessDefinitionImpl)o;
        boolean arrayCompare = true;
        for (int i = 0; i < 5; ++i) {
            arrayCompare = arrayCompare && this.listIndex[i].equals(that.listIndex[i]);
        }
        return Objects.equals(this.displayName, that.displayName) && Objects.equals(this.displayDescription, that.displayDescription) && Objects.equals(this.parameters, that.parameters) && Objects.equals(this.actors, that.actors) && Objects.equals(this.actorInitiator, that.actorInitiator) && Objects.equals(this.flowElementContainer, that.flowElementContainer) && arrayCompare && Objects.equals(this.contract, that.contract) && Objects.equals(this.context, that.context);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.displayName, this.displayDescription, this.parameters, this.actors, this.actorInitiator, this.flowElementContainer, this.listIndex, this.contract, this.context);
    }

    @Override
    public String toString() {
        return "DesignProcessDefinitionImpl(displayName=" + this.getDisplayName() + ", displayDescription=" + this.getDisplayDescription() + ", parameters=" + this.getParameters() + ", actors=" + this.actors + ", actorInitiator=" + this.getActorInitiator() + ", flowElementContainer=" + this.getFlowElementContainer() + ", listIndex=" + Arrays.deepToString(this.listIndex) + ", contract=" + this.getContract() + ", context=" + this.getContext() + ")";
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Override
    public String getDisplayDescription() {
        return this.displayDescription;
    }

    public void setDisplayDescription(String displayDescription) {
        this.displayDescription = displayDescription;
    }

    @Override
    public Set<ParameterDefinition> getParameters() {
        return this.parameters;
    }

    @Override
    public ActorDefinition getActorInitiator() {
        return this.actorInitiator;
    }

    public void setActorInitiator(ActorDefinition actorInitiator) {
        this.actorInitiator = actorInitiator;
    }

    @Override
    public ContractDefinition getContract() {
        return this.contract;
    }

    public void setContract(ContractDefinition contract) {
        this.contract = contract;
    }
}

