/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bpm.flownode.impl.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import org.bonitasoft.engine.bpm.flownode.CorrelationDefinition;
import org.bonitasoft.engine.bpm.flownode.MessageEventTriggerDefinition;
import org.bonitasoft.engine.bpm.flownode.impl.internal.CorrelationDefinitionImpl;
import org.bonitasoft.engine.bpm.process.ModelFinderVisitor;
import org.bonitasoft.engine.expression.Expression;

@XmlTransient
@XmlAccessorType(value=XmlAccessType.FIELD)
public abstract class MessageEventTriggerDefinitionImpl
implements MessageEventTriggerDefinition {
    private static final long serialVersionUID = -190616505159460399L;
    @XmlAttribute(name="name")
    private final String messageName;
    @XmlElement(type=CorrelationDefinitionImpl.class, name="correlation")
    private final List<CorrelationDefinition> correlations;

    public MessageEventTriggerDefinitionImpl(String name) {
        this.messageName = name;
        this.correlations = new ArrayList<CorrelationDefinition>(1);
    }

    public MessageEventTriggerDefinitionImpl(String name, List<CorrelationDefinition> correlations) {
        this.messageName = name;
        this.correlations = correlations;
    }

    public MessageEventTriggerDefinitionImpl(MessageEventTriggerDefinition trigger) {
        this.messageName = trigger.getMessageName();
        this.correlations = trigger.getCorrelations();
    }

    public MessageEventTriggerDefinitionImpl() {
        this.messageName = null;
        this.correlations = new ArrayList<CorrelationDefinition>(1);
    }

    @Override
    public String getMessageName() {
        return this.messageName;
    }

    @Override
    public List<CorrelationDefinition> getCorrelations() {
        return Collections.unmodifiableList(this.correlations);
    }

    public void addCorrelation(Expression key, Expression value) {
        this.correlations.add(new CorrelationDefinitionImpl(key, value));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessageEventTriggerDefinitionImpl that = (MessageEventTriggerDefinitionImpl)o;
        return Objects.equals(this.messageName, that.messageName) && Objects.equals(this.correlations, that.correlations);
    }

    public int hashCode() {
        return Objects.hash(this.messageName, this.correlations);
    }

    @Override
    public void accept(ModelFinderVisitor visitor, long modelId) {
        visitor.find(this, modelId);
    }
}

