/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bpm.process.impl;

import org.bonitasoft.engine.bpm.flownode.impl.internal.FlowElementContainerDefinitionImpl;
import org.bonitasoft.engine.bpm.flownode.impl.internal.FlowNodeDefinitionImpl;
import org.bonitasoft.engine.bpm.flownode.impl.internal.TransitionDefinitionImpl;
import org.bonitasoft.engine.bpm.process.impl.FlowElementContainerBuilder;
import org.bonitasoft.engine.bpm.process.impl.ProcessDefinitionBuilder;
import org.bonitasoft.engine.expression.Expression;

public class TransitionDefinitionBuilder
extends FlowElementContainerBuilder {
    private TransitionDefinitionImpl transition;

    TransitionDefinitionBuilder(ProcessDefinitionBuilder processDefinitionBuilder, FlowElementContainerDefinitionImpl container, String source, String target, Boolean isDefaultTransition) {
        super(container, processDefinitionBuilder);
        this.addTransition(source, target, null, isDefaultTransition);
    }

    TransitionDefinitionBuilder(ProcessDefinitionBuilder processDefinitionBuilder, FlowElementContainerDefinitionImpl container, String source, String target, Expression expression, Boolean isDefaultTransition) {
        super(container, processDefinitionBuilder);
        this.addTransition(source, target, expression, isDefaultTransition);
    }

    private void addTransition(String source, String target, Expression condition, Boolean isDefaultTransition) {
        FlowNodeDefinitionImpl from = (FlowNodeDefinitionImpl)this.getContainer().getFlowNode(source);
        FlowNodeDefinitionImpl to = (FlowNodeDefinitionImpl)this.getContainer().getFlowNode(target);
        if (from == null) {
            this.getProcessBuilder().addError("from : Unable to find a flow element named: " + source);
        }
        if (to == null) {
            this.getProcessBuilder().addError("to : Unable to find a flow element named: " + target);
        }
        if (to == null || from == null) {
            return;
        }
        StringBuilder nameBuilder = new StringBuilder();
        nameBuilder.append(from.getId()).append("_->_").append(to.getId());
        this.transition = new TransitionDefinitionImpl(nameBuilder.toString(), from, to);
        this.transition.setCondition(condition);
        if (isDefaultTransition.booleanValue()) {
            from.setDefaultTransition(this.transition);
        } else {
            from.addOutgoingTransition(this.transition);
        }
        to.addIncomingTransition(this.transition);
        this.getContainer().addTransition(this.transition);
    }
}

