/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bpm.flownode.impl.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlIDREF;
import javax.xml.bind.annotation.XmlTransient;
import lombok.Generated;
import org.bonitasoft.engine.bpm.connector.ConnectorDefinition;
import org.bonitasoft.engine.bpm.connector.impl.ConnectorDefinitionImpl;
import org.bonitasoft.engine.bpm.flownode.FlowNodeDefinition;
import org.bonitasoft.engine.bpm.flownode.TransitionDefinition;
import org.bonitasoft.engine.bpm.flownode.impl.internal.TransitionDefinitionImpl;
import org.bonitasoft.engine.bpm.internal.NamedDefinitionElementImpl;
import org.bonitasoft.engine.bpm.process.ModelFinderVisitor;
import org.bonitasoft.engine.expression.Expression;
import org.bonitasoft.engine.expression.ExpressionBuilder;
import org.bonitasoft.engine.expression.impl.ExpressionImpl;

@XmlTransient
@XmlAccessorType(value=XmlAccessType.FIELD)
public abstract class FlowNodeDefinitionImpl
extends NamedDefinitionElementImpl
implements FlowNodeDefinition {
    private static final long serialVersionUID = 429640943678358154L;
    @XmlIDREF
    @XmlElement(type=TransitionDefinitionImpl.class, name="incomingTransition")
    private final List<TransitionDefinition> incomings = new ArrayList<TransitionDefinition>();
    @XmlIDREF
    @XmlElement(type=TransitionDefinitionImpl.class, name="outgoingTransition")
    private final List<TransitionDefinition> outgoings = new ArrayList<TransitionDefinition>();
    @XmlElement(type=ConnectorDefinitionImpl.class, name="connector")
    private final List<ConnectorDefinition> connectors = new ArrayList<ConnectorDefinition>();
    @XmlElement
    private String description;
    @XmlElement(type=ExpressionImpl.class)
    private Expression displayDescription;
    @XmlElement(type=ExpressionImpl.class)
    private Expression displayName;
    @XmlElement(type=ExpressionImpl.class)
    private Expression displayDescriptionAfterCompletion;
    @XmlIDREF
    @XmlElement(type=TransitionDefinitionImpl.class)
    private TransitionDefinition defaultTransition;

    public FlowNodeDefinitionImpl(long id, String name) {
        super(name);
        this.setId(id);
    }

    public FlowNodeDefinitionImpl(String name) {
        super(name);
    }

    @Override
    public List<TransitionDefinition> getOutgoingTransitions() {
        return Collections.unmodifiableList(this.outgoings);
    }

    @Override
    public List<TransitionDefinition> getIncomingTransitions() {
        return Collections.unmodifiableList(this.incomings);
    }

    @Override
    public List<ConnectorDefinition> getConnectors() {
        return Collections.unmodifiableList(this.connectors);
    }

    public void addIncomingTransition(TransitionDefinition transition) {
        if (!this.incomings.contains(transition)) {
            this.incomings.add(transition);
        }
    }

    public void addIncomingTransition(int index, TransitionDefinition transition) {
        if (!this.incomings.contains(transition)) {
            this.incomings.add(index, transition);
        }
    }

    public void removeIncomingTransition(TransitionDefinition transition) {
        this.incomings.remove(transition);
    }

    public void addOutgoingTransition(TransitionDefinition transition) {
        if (!this.outgoings.contains(transition)) {
            this.outgoings.add(transition);
        }
    }

    public void addOutgoingTransition(int index, TransitionDefinition transition) {
        if (!this.outgoings.contains(transition)) {
            this.outgoings.add(index, transition);
        }
    }

    public void removeOutgoingTransition(TransitionDefinition transition) {
        this.outgoings.remove(transition);
    }

    @Override
    public void addConnector(ConnectorDefinition connectorDefinition) {
        this.connectors.add(connectorDefinition);
    }

    public void setDisplayDescription(Expression displayDescription) {
        this.displayDescription = ExpressionBuilder.getNonNullCopy(displayDescription);
    }

    public void setDisplayName(Expression displayName) {
        this.displayName = ExpressionBuilder.getNonNullCopy(displayName);
    }

    public void setDisplayDescriptionAfterCompletion(Expression displayDescriptionAfterCompletion) {
        this.displayDescriptionAfterCompletion = ExpressionBuilder.getNonNullCopy(displayDescriptionAfterCompletion);
    }

    @Override
    public void accept(ModelFinderVisitor visitor, long modelId) {
        visitor.find(this, modelId);
    }

    @Generated
    public FlowNodeDefinitionImpl() {
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FlowNodeDefinitionImpl)) {
            return false;
        }
        FlowNodeDefinitionImpl other = (FlowNodeDefinitionImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<TransitionDefinition> this$incomings = this.incomings;
        List<TransitionDefinition> other$incomings = other.incomings;
        if (this$incomings == null ? other$incomings != null : !((Object)this$incomings).equals(other$incomings)) {
            return false;
        }
        List<TransitionDefinition> this$outgoings = this.outgoings;
        List<TransitionDefinition> other$outgoings = other.outgoings;
        if (this$outgoings == null ? other$outgoings != null : !((Object)this$outgoings).equals(other$outgoings)) {
            return false;
        }
        List<ConnectorDefinition> this$connectors = this.getConnectors();
        List<ConnectorDefinition> other$connectors = other.getConnectors();
        if (this$connectors == null ? other$connectors != null : !((Object)this$connectors).equals(other$connectors)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Expression this$displayDescription = this.getDisplayDescription();
        Expression other$displayDescription = other.getDisplayDescription();
        if (this$displayDescription == null ? other$displayDescription != null : !this$displayDescription.equals(other$displayDescription)) {
            return false;
        }
        Expression this$displayName = this.getDisplayName();
        Expression other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        Expression this$displayDescriptionAfterCompletion = this.getDisplayDescriptionAfterCompletion();
        Expression other$displayDescriptionAfterCompletion = other.getDisplayDescriptionAfterCompletion();
        if (this$displayDescriptionAfterCompletion == null ? other$displayDescriptionAfterCompletion != null : !this$displayDescriptionAfterCompletion.equals(other$displayDescriptionAfterCompletion)) {
            return false;
        }
        TransitionDefinition this$defaultTransition = this.getDefaultTransition();
        TransitionDefinition other$defaultTransition = other.getDefaultTransition();
        return !(this$defaultTransition == null ? other$defaultTransition != null : !this$defaultTransition.equals(other$defaultTransition));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FlowNodeDefinitionImpl;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<TransitionDefinition> $incomings = this.incomings;
        result = result * 59 + ($incomings == null ? 43 : ((Object)$incomings).hashCode());
        List<TransitionDefinition> $outgoings = this.outgoings;
        result = result * 59 + ($outgoings == null ? 43 : ((Object)$outgoings).hashCode());
        List<ConnectorDefinition> $connectors = this.getConnectors();
        result = result * 59 + ($connectors == null ? 43 : ((Object)$connectors).hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Expression $displayDescription = this.getDisplayDescription();
        result = result * 59 + ($displayDescription == null ? 43 : $displayDescription.hashCode());
        Expression $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        Expression $displayDescriptionAfterCompletion = this.getDisplayDescriptionAfterCompletion();
        result = result * 59 + ($displayDescriptionAfterCompletion == null ? 43 : $displayDescriptionAfterCompletion.hashCode());
        TransitionDefinition $defaultTransition = this.getDefaultTransition();
        result = result * 59 + ($defaultTransition == null ? 43 : $defaultTransition.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "FlowNodeDefinitionImpl(incomings=" + String.valueOf(this.incomings) + ", outgoings=" + String.valueOf(this.outgoings) + ", connectors=" + String.valueOf(this.getConnectors()) + ", description=" + this.getDescription() + ", displayDescription=" + String.valueOf(this.getDisplayDescription()) + ", displayName=" + String.valueOf(this.getDisplayName()) + ", displayDescriptionAfterCompletion=" + String.valueOf(this.getDisplayDescriptionAfterCompletion()) + ", defaultTransition=" + String.valueOf(this.getDefaultTransition()) + ")";
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    @Generated
    public Expression getDisplayDescription() {
        return this.displayDescription;
    }

    @Override
    @Generated
    public Expression getDisplayName() {
        return this.displayName;
    }

    @Override
    @Generated
    public Expression getDisplayDescriptionAfterCompletion() {
        return this.displayDescriptionAfterCompletion;
    }

    @Override
    @Generated
    public TransitionDefinition getDefaultTransition() {
        return this.defaultTransition;
    }

    @Generated
    public void setDefaultTransition(TransitionDefinition defaultTransition) {
        this.defaultTransition = defaultTransition;
    }
}

