/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl.transaction.actor;

import java.util.List;
import org.bonitasoft.engine.actor.mapping.ActorMappingService;
import org.bonitasoft.engine.actor.mapping.model.SActor;
import org.bonitasoft.engine.bpm.actor.ActorCriterion;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.commons.transaction.TransactionContentWithResult;
import org.bonitasoft.engine.persistence.OrderByType;

public class GetActorsByPagination
implements TransactionContentWithResult<List<SActor>> {
    private final ActorMappingService actorMappingService;
    private final long processDefinitionId;
    private final int startIndex;
    private final int maxResults;
    private final ActorCriterion sort;
    private List<SActor> actors;

    public GetActorsByPagination(ActorMappingService actorMappingService, long processDefinitionId, int startIndex, int maxResults, ActorCriterion sort) {
        this.actorMappingService = actorMappingService;
        this.processDefinitionId = processDefinitionId;
        this.startIndex = startIndex;
        this.maxResults = maxResults;
        this.sort = sort;
    }

    @Override
    public void execute() throws SBonitaException {
        OrderByType order;
        String field = "name";
        if (this.sort == null) {
            order = OrderByType.ASC;
        } else {
            switch (this.sort) {
                case NAME_ASC: {
                    order = OrderByType.ASC;
                    break;
                }
                default: {
                    order = OrderByType.DESC;
                }
            }
        }
        this.actors = this.actorMappingService.getActors(this.processDefinitionId, this.startIndex, this.maxResults, "name", order);
    }

    @Override
    public List<SActor> getResult() {
        return this.actors;
    }
}

