/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl.transaction.dependency;

import org.bonitasoft.engine.commons.transaction.TransactionContent;
import org.bonitasoft.engine.dependency.DependencyService;
import org.bonitasoft.engine.dependency.SDependencyException;
import org.bonitasoft.engine.dependency.model.SDependency;
import org.bonitasoft.engine.dependency.model.SDependencyMapping;
import org.bonitasoft.engine.dependency.model.builder.DependencyBuilder;
import org.bonitasoft.engine.dependency.model.builder.DependencyBuilderAccessor;
import org.bonitasoft.engine.dependency.model.builder.DependencyMappingBuilder;

public class AddSDependency
implements TransactionContent {
    private final DependencyService dependencyService;
    private final DependencyBuilderAccessor dependencyBuilderAccessor;
    private final String name;
    private final byte[] jar;
    private final long artifactId;
    private final String artifactType;

    public AddSDependency(DependencyService dependencyService, DependencyBuilderAccessor dependencyBuilderAccessor, String name, byte[] jar, long artifactId, String artifactType) {
        this.dependencyService = dependencyService;
        this.dependencyBuilderAccessor = dependencyBuilderAccessor;
        this.name = name;
        this.jar = jar;
        this.artifactId = artifactId;
        this.artifactType = artifactType;
    }

    @Override
    public void execute() throws SDependencyException {
        DependencyBuilder dependencyBuilder = this.dependencyBuilderAccessor.getDependencyBuilder();
        SDependency sDependency = dependencyBuilder.createNewInstance(this.name, "1.0", this.name + ".jar", this.jar).done();
        this.dependencyService.createDependency(sDependency);
        DependencyMappingBuilder dependencyMappingBuilder = this.dependencyBuilderAccessor.getDependencyMappingBuilder();
        SDependencyMapping sDependencyMapping = dependencyMappingBuilder.createNewInstance(sDependency.getId(), this.artifactId, this.artifactType).done();
        this.dependencyService.createDependencyMapping(sDependencyMapping);
    }
}

