/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl.transaction.identity;

import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.commons.transaction.TransactionContentWithResult;
import org.bonitasoft.engine.identity.IdentityService;
import org.bonitasoft.engine.identity.model.SContactInfo;
import org.bonitasoft.engine.identity.model.SUser;
import org.bonitasoft.engine.identity.model.builder.SContactInfoBuilder;

public class CreateUser
implements TransactionContentWithResult<SUser> {
    private final SUser sUser;
    private final IdentityService identityService;
    private final SContactInfo sPersonalData;
    private final SContactInfo sProfessionalData;
    private final SContactInfoBuilder sContactInfoBuilder;
    private SUser user;

    public CreateUser(SUser sUser, SContactInfo sPersonalData, SContactInfo sProfessionalData, IdentityService identityService, SContactInfoBuilder sContactInfoBuilder) {
        this.sUser = sUser;
        this.sPersonalData = sPersonalData;
        this.sProfessionalData = sProfessionalData;
        this.identityService = identityService;
        this.sContactInfoBuilder = sContactInfoBuilder;
    }

    @Override
    public void execute() throws SBonitaException {
        this.user = this.identityService.createUser(this.sUser);
        if (this.sPersonalData != null) {
            this.identityService.createUserContactInfo(this.sContactInfoBuilder.createNewInstance(this.sPersonalData).setUserId(this.user.getId()).done());
        }
        if (this.sProfessionalData != null) {
            this.identityService.createUserContactInfo(this.sContactInfoBuilder.createNewInstance(this.sProfessionalData).setUserId(this.user.getId()).done());
        }
    }

    @Override
    public SUser getResult() {
        return this.user;
    }
}

