/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl.transaction.identity;

import java.util.List;
import org.bonitasoft.engine.actor.mapping.ActorMappingService;
import org.bonitasoft.engine.actor.mapping.SActorMemberDeletionException;
import org.bonitasoft.engine.actor.mapping.SActorMemberNotFoundException;
import org.bonitasoft.engine.actor.mapping.model.SActorMember;
import org.bonitasoft.engine.api.impl.transaction.identity.DeleteWithActorMembers;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.commons.transaction.TransactionContent;
import org.bonitasoft.engine.identity.IdentityService;
import org.bonitasoft.engine.identity.SIdentityException;
import org.bonitasoft.engine.identity.model.SGroup;
import org.bonitasoft.engine.identity.model.SUserMembership;
import org.bonitasoft.engine.persistence.OrderByType;
import org.bonitasoft.engine.persistence.SBonitaReadException;
import org.bonitasoft.engine.profile.ProfileService;
import org.bonitasoft.engine.profile.builder.SProfileBuilderAccessor;
import org.bonitasoft.engine.profile.model.SProfileMember;

public class DeleteGroup
extends DeleteWithActorMembers
implements TransactionContent {
    private static final int BATCH_SIZE = 100;
    private final IdentityService identityService;
    private final ActorMappingService actorMappingService;
    private final ProfileService profileService;
    private final SProfileBuilderAccessor sProfileBuilderAccessor;
    private final long groupId;

    public DeleteGroup(IdentityService identityService, ActorMappingService actorMappingService, ProfileService profileService, long groupId, SProfileBuilderAccessor sProfileBuilderAccessor) {
        this.identityService = identityService;
        this.actorMappingService = actorMappingService;
        this.groupId = groupId;
        this.profileService = profileService;
        this.sProfileBuilderAccessor = sProfileBuilderAccessor;
    }

    @Override
    public void execute() throws SBonitaException {
        this.deleteMembershipsByGroup(this.groupId);
        this.deleActorMembers(this.groupId);
        this.deleteProfileMembers(this.groupId);
        this.identityService.deleteChildrenGroup(this.groupId);
        this.identityService.deleteGroup(this.groupId);
    }

    private void deleActorMembers(long groupId) throws SActorMemberNotFoundException, SActorMemberDeletionException, SBonitaReadException, SIdentityException {
        List<SGroup> childrenGroup;
        List<SActorMember> actorMembers = this.actorMappingService.getActorMembersOfGroup(groupId);
        for (SActorMember sActorMember : actorMembers) {
            this.setActorIdsOfRemovedElements(this.actorMappingService.removeActorMember(sActorMember.getId()));
        }
        int i = 0;
        do {
            childrenGroup = this.identityService.getGroupChildren(groupId, i, 100);
            i += 100;
            for (SGroup sGroup : childrenGroup) {
                this.deleActorMembers(sGroup.getId());
            }
        } while (childrenGroup.size() == 100);
    }

    private void deleteProfileMembers(long groupId) throws SBonitaException {
        List<SGroup> childrenGroup;
        List<SProfileMember> profileMembers;
        int numberOfElements = 1000;
        String field = this.sProfileBuilderAccessor.getSProfileMemberBuilder().getIdKey();
        do {
            profileMembers = this.profileService.getProfileMembersOfGroup(groupId, 0, 1000, field, OrderByType.ASC);
            for (SProfileMember sProfileMember : profileMembers) {
                this.profileService.deleteProfileMember(sProfileMember);
            }
        } while (profileMembers.size() == 20);
        int i = 0;
        do {
            childrenGroup = this.identityService.getGroupChildren(groupId, i, 100);
            i += 100;
            for (SGroup sGroup : childrenGroup) {
                this.deleteProfileMembers(sGroup.getId());
            }
        } while (childrenGroup.size() == 100);
    }

    private void deleteMembershipsByGroup(long groupId) throws SBonitaException {
        List<SUserMembership> memberships;
        int i = 0;
        do {
            memberships = this.identityService.getUserMembershipsOfGroup(groupId, i, i + 20);
            i += 20;
            for (SUserMembership sUserMembership : memberships) {
                this.identityService.deleteUserMembership(sUserMembership.getId());
            }
        } while (memberships.size() == 20);
    }
}

