/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl.transaction.platform;

import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.commons.transaction.TransactionContent;
import org.bonitasoft.engine.platform.PlatformService;
import org.bonitasoft.engine.scheduler.SchedulerService;
import org.bonitasoft.engine.session.SessionService;
import org.bonitasoft.engine.work.WorkService;

public final class DeactivateTenant
implements TransactionContent {
    private final long tenantId;
    private final PlatformService platformService;
    private final SchedulerService schedulerService;
    private final WorkService workService;
    private final SessionService sessionService;

    public DeactivateTenant(long tenantId, PlatformService platformService, SchedulerService schedulerService, WorkService workService, SessionService sessionService) {
        this.tenantId = tenantId;
        this.platformService = platformService;
        this.schedulerService = schedulerService;
        this.workService = workService;
        this.sessionService = sessionService;
    }

    @Override
    public void execute() throws SBonitaException {
        this.workService.stop(this.tenantId);
        this.platformService.deactiveTenant(this.tenantId);
        if (this.schedulerService.isStarted()) {
            this.schedulerService.delete("BPMEventHandling");
            this.schedulerService.delete("CleanInvalidSessions");
        }
    }
}

