/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.core.category.model.builder.impl;

import org.bonitasoft.engine.core.category.model.SCategory;
import org.bonitasoft.engine.core.category.model.builder.SCategoryBuilder;
import org.bonitasoft.engine.core.category.model.impl.SCategoryImpl;

public class SCategoryBuilderImpl
implements SCategoryBuilder {
    private SCategoryImpl category;
    static final String ID = "id";
    static final String NAME = "name";
    static final String DESCRIPTION = "description";
    static final String CREATOR = "creator";
    static final String CREATION_DATE = "creationDate";
    static final String LAST_UPDATE_DATE = "lastUpdateDate";

    @Override
    public SCategoryBuilder createNewInstance(String name, long creator) {
        this.category = new SCategoryImpl(name);
        this.category.setCreator(creator);
        long now = System.currentTimeMillis();
        this.category.setCreationDate(now);
        this.category.setLastUpdateDate(now);
        return this;
    }

    @Override
    public SCategoryBuilder createNewInstance(SCategory category) {
        this.category = new SCategoryImpl(category);
        long now = System.currentTimeMillis();
        this.category.setCreationDate(now);
        this.category.setLastUpdateDate(now);
        return this;
    }

    @Override
    public SCategoryBuilder setDescription(String description) {
        this.category.setDescription(description);
        return this;
    }

    @Override
    public SCategory done() {
        return this.category;
    }

    @Override
    public SCategoryBuilder setLastUpdateDate(long lastUpdateDate) {
        this.category.setLastUpdateDate(lastUpdateDate);
        return this;
    }

    @Override
    public String getIdKey() {
        return ID;
    }

    @Override
    public String getNameKey() {
        return NAME;
    }

    @Override
    public String getDescriptionKey() {
        return DESCRIPTION;
    }

    @Override
    public String getCreatorKey() {
        return CREATOR;
    }

    @Override
    public String getCreationDateKey() {
        return CREATION_DATE;
    }

    @Override
    public String getLastUpdateDateKey() {
        return LAST_UPDATE_DATE;
    }
}

