/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.core.operation.impl;

import org.bonitasoft.engine.core.operation.OperationExecutorStrategy;
import org.bonitasoft.engine.core.operation.exception.SOperationExecutionException;
import org.bonitasoft.engine.core.operation.model.SLeftOperand;
import org.bonitasoft.engine.data.instance.api.DataInstanceService;
import org.bonitasoft.engine.data.instance.exception.SDataInstanceException;
import org.bonitasoft.engine.data.instance.model.SDataInstance;
import org.bonitasoft.engine.data.instance.model.builder.SDataInstanceBuilder;
import org.bonitasoft.engine.data.instance.model.builder.SDataInstanceBuilders;
import org.bonitasoft.engine.recorder.model.EntityUpdateDescriptor;

public abstract class UpdateOperationExecutorStrategy
implements OperationExecutorStrategy {
    private final DataInstanceService dataInstanceService;
    private final SDataInstanceBuilders sDataInstanceBuilders;

    public UpdateOperationExecutorStrategy(DataInstanceService dataInstanceService, SDataInstanceBuilders sDataInstanceBuilders) {
        this.dataInstanceService = dataInstanceService;
        this.sDataInstanceBuilders = sDataInstanceBuilders;
    }

    protected void update(SDataInstance sDataInstance, Object content) throws SDataInstanceException {
        EntityUpdateDescriptor updateDescriptor = new EntityUpdateDescriptor();
        SDataInstanceBuilder sDataInstanceBuilder = this.sDataInstanceBuilders.getDataInstanceBuilder();
        updateDescriptor.addField(sDataInstanceBuilder.getValueKey(), content);
        this.dataInstanceService.updateDataInstance(sDataInstance, updateDescriptor);
    }

    protected SDataInstance getDataInstance(String dataInstanceName, long containerId, String containerType) throws SDataInstanceException {
        return this.dataInstanceService.getDataInstance(dataInstanceName, containerId, containerType);
    }

    @Override
    public void update(SLeftOperand leftOperand, Object newValue, long containerId, String containerType) throws SOperationExecutionException {
        if (!leftOperand.isExternal()) {
            this.updateDataInstance(leftOperand, containerId, containerType, newValue);
        }
    }

    @Override
    public boolean doUpdateData() {
        return true;
    }

    private void updateDataInstance(SLeftOperand leftOperand, long containerId, String containerType, Object expressionResult) throws SOperationExecutionException {
        String dataInstanceName = leftOperand.getName();
        try {
            SDataInstance sDataInstance = this.getDataInstance(dataInstanceName, containerId, containerType);
            this.update(sDataInstance, expressionResult);
        }
        catch (SDataInstanceException e) {
            throw new SOperationExecutionException(e);
        }
    }
}

