/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.core.process.definition.model.event.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.bpm.flownode.CatchEventDefinition;
import org.bonitasoft.engine.bpm.flownode.CatchMessageEventTriggerDefinition;
import org.bonitasoft.engine.bpm.flownode.ErrorEventTriggerDefinition;
import org.bonitasoft.engine.bpm.flownode.EventDefinition;
import org.bonitasoft.engine.bpm.flownode.SignalEventTriggerDefinition;
import org.bonitasoft.engine.bpm.flownode.TimerEventTriggerDefinition;
import org.bonitasoft.engine.core.operation.model.builder.SOperationBuilders;
import org.bonitasoft.engine.core.process.definition.model.STransitionDefinition;
import org.bonitasoft.engine.core.process.definition.model.event.SCatchEventDefinition;
import org.bonitasoft.engine.core.process.definition.model.event.impl.SEventDefinitionImpl;
import org.bonitasoft.engine.core.process.definition.model.event.trigger.SCatchErrorEventTriggerDefinition;
import org.bonitasoft.engine.core.process.definition.model.event.trigger.SCatchMessageEventTriggerDefinition;
import org.bonitasoft.engine.core.process.definition.model.event.trigger.SCatchSignalEventTriggerDefinition;
import org.bonitasoft.engine.core.process.definition.model.event.trigger.STimerEventTriggerDefinition;
import org.bonitasoft.engine.core.process.definition.model.event.trigger.impl.SCatchErrorEventTriggerDefinitionImpl;
import org.bonitasoft.engine.core.process.definition.model.event.trigger.impl.SCatchMessageEventTriggerDefinitionImpl;
import org.bonitasoft.engine.core.process.definition.model.event.trigger.impl.SCatchSignalEventTriggerDefinitionImpl;
import org.bonitasoft.engine.core.process.definition.model.event.trigger.impl.STimerEventTriggerDefinitionImpl;
import org.bonitasoft.engine.data.definition.model.builder.SDataDefinitionBuilders;
import org.bonitasoft.engine.expression.model.builder.SExpressionBuilders;

public abstract class SCatchEventDefinitionImpl
extends SEventDefinitionImpl
implements SCatchEventDefinition {
    private static final long serialVersionUID = -2803848099720886033L;
    private final List<STimerEventTriggerDefinition> timerEventTriggers;
    private final List<SCatchMessageEventTriggerDefinition> messageEventTriggers;
    private final List<SCatchSignalEventTriggerDefinition> signalEventTriggers;
    private final List<SCatchErrorEventTriggerDefinition> errorEventTriggers;
    private boolean isInterrupting = true;

    public SCatchEventDefinitionImpl(CatchEventDefinition eventDefinition, SExpressionBuilders sExpressionBuilders, Map<String, STransitionDefinition> transitionsMap, SDataDefinitionBuilders sDataDefinitionBuilders, SOperationBuilders sOperationBuilders) {
        super((EventDefinition)eventDefinition, sExpressionBuilders, transitionsMap, sOperationBuilders);
        this.isInterrupting = eventDefinition.isInterrupting();
        this.timerEventTriggers = new ArrayList<STimerEventTriggerDefinition>(eventDefinition.getTimerEventTriggerDefinitions().size());
        for (TimerEventTriggerDefinition timerTrigger : eventDefinition.getTimerEventTriggerDefinitions()) {
            this.addTimerEventTrigger(new STimerEventTriggerDefinitionImpl(timerTrigger, sExpressionBuilders));
        }
        this.messageEventTriggers = new ArrayList<SCatchMessageEventTriggerDefinition>(eventDefinition.getMessageEventTriggerDefinitions().size());
        for (CatchMessageEventTriggerDefinition catchMessageTrigger : eventDefinition.getMessageEventTriggerDefinitions()) {
            this.addMessageEventTrigger(new SCatchMessageEventTriggerDefinitionImpl(catchMessageTrigger, sDataDefinitionBuilders, sExpressionBuilders, sOperationBuilders));
        }
        this.signalEventTriggers = new ArrayList<SCatchSignalEventTriggerDefinition>(eventDefinition.getSignalEventTriggerDefinitions().size());
        for (SignalEventTriggerDefinition signalTrigger : eventDefinition.getSignalEventTriggerDefinitions()) {
            this.addSignalEventTrigger(new SCatchSignalEventTriggerDefinitionImpl(signalTrigger.getSignalName()));
        }
        this.errorEventTriggers = new ArrayList<SCatchErrorEventTriggerDefinition>(eventDefinition.getErrorEventTriggerDefinitions().size());
        for (ErrorEventTriggerDefinition errorTrigger : eventDefinition.getErrorEventTriggerDefinitions()) {
            this.addErrorEventTrigger(new SCatchErrorEventTriggerDefinitionImpl(errorTrigger.getErrorCode()));
        }
    }

    public SCatchEventDefinitionImpl(long id, String name) {
        super(id, name);
        this.timerEventTriggers = new ArrayList<STimerEventTriggerDefinition>(1);
        this.messageEventTriggers = new ArrayList<SCatchMessageEventTriggerDefinition>(5);
        this.signalEventTriggers = new ArrayList<SCatchSignalEventTriggerDefinition>(1);
        this.errorEventTriggers = new ArrayList<SCatchErrorEventTriggerDefinition>(1);
    }

    @Override
    public List<STimerEventTriggerDefinition> getTimerEventTriggerDefinitions() {
        return Collections.unmodifiableList(this.timerEventTriggers);
    }

    public void addTimerEventTrigger(STimerEventTriggerDefinition timerEventTrigger) {
        this.timerEventTriggers.add(timerEventTrigger);
        this.addEventTriggerDefinition(timerEventTrigger);
    }

    @Override
    public List<SCatchMessageEventTriggerDefinition> getMessageEventTriggerDefinitions() {
        return Collections.unmodifiableList(this.messageEventTriggers);
    }

    public void addMessageEventTrigger(SCatchMessageEventTriggerDefinition messageEventTrigger) {
        this.messageEventTriggers.add(messageEventTrigger);
        this.addEventTriggerDefinition(messageEventTrigger);
    }

    @Override
    public SCatchMessageEventTriggerDefinition getMessageEventTriggerDefinition(String messageName) {
        Iterator<SCatchMessageEventTriggerDefinition> iterator = this.messageEventTriggers.iterator();
        boolean found = false;
        SCatchMessageEventTriggerDefinition messageTrigger = null;
        while (iterator.hasNext() && !found) {
            SCatchMessageEventTriggerDefinition sCatchMessageEventTriggerDefinition = iterator.next();
            if (!sCatchMessageEventTriggerDefinition.getMessageName().equals(messageName)) continue;
            found = true;
            messageTrigger = sCatchMessageEventTriggerDefinition;
        }
        return messageTrigger;
    }

    @Override
    public List<SCatchSignalEventTriggerDefinition> getSignalEventTriggerDefinitions() {
        return Collections.unmodifiableList(this.signalEventTriggers);
    }

    public void addSignalEventTrigger(SCatchSignalEventTriggerDefinition signalEventTrigger) {
        this.signalEventTriggers.add(signalEventTrigger);
        this.addEventTriggerDefinition(signalEventTrigger);
    }

    public void setInterrupting(boolean isInterrupting) {
        this.isInterrupting = isInterrupting;
    }

    @Override
    public boolean isInterrupting() {
        return this.isInterrupting;
    }

    @Override
    public List<SCatchErrorEventTriggerDefinition> getErrorEventTriggerDefinitions() {
        return Collections.unmodifiableList(this.errorEventTriggers);
    }

    @Override
    public SCatchErrorEventTriggerDefinition getErrorEventTriggerDefinition(String errorCode) {
        Iterator<SCatchErrorEventTriggerDefinition> iterator = this.errorEventTriggers.iterator();
        boolean found = false;
        SCatchErrorEventTriggerDefinition trigger = null;
        while (iterator.hasNext() && !found) {
            SCatchErrorEventTriggerDefinition currentTrigger = iterator.next();
            if ((currentTrigger.getErrorCode() != null || errorCode != null) && (currentTrigger.getErrorCode() == null || !currentTrigger.getErrorCode().equals(errorCode))) continue;
            found = true;
            trigger = currentTrigger;
        }
        return trigger;
    }

    public void addErrorEventTrigger(SCatchErrorEventTriggerDefinition errorEventTrigger) {
        this.errorEventTriggers.add(errorEventTrigger);
        this.addEventTriggerDefinition(errorEventTrigger);
    }
}

