/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.core.process.instance.model.builder.impl;

import org.bonitasoft.engine.commons.NullCheckingUtil;
import org.bonitasoft.engine.core.process.definition.model.SFlowNodeType;
import org.bonitasoft.engine.core.process.definition.model.SProcessDefinition;
import org.bonitasoft.engine.core.process.instance.model.SProcessInstance;
import org.bonitasoft.engine.core.process.instance.model.SStateCategory;
import org.bonitasoft.engine.core.process.instance.model.builder.SProcessInstanceBuilder;
import org.bonitasoft.engine.core.process.instance.model.impl.SProcessInstanceImpl;

public class SProcessInstanceBuilderImpl
implements SProcessInstanceBuilder {
    private static final String ID_KEY = "id";
    private static final String NAME_KEY = "name";
    private static final String PROCESSDEF_ID_KEY = "processDefinitionId";
    private static final String STATE_ID_KEY = "stateId";
    private static final String STATE_CATEGORY_KEY = "stateCategory";
    private static final String CONTAINER_ID_KEY = "containerId";
    private static final String MIGRATION_PLAN_ID = "migrationPlanId";
    private static final String END_DATE_KEY = "endDate";
    private static final String STARTED_BY_KEY = "startedBy";
    private static final String STARTED_BY_DELEGATE_KEY = "startedByDelegate";
    private static final String START_DATE_KEY = "startDate";
    private static final String CALLER_ID = "callerId";
    static final String LAST_UPDATE_KEY = "lastUpdate";
    static final String INTERRUPTING_EVENT_ID_KEY = "interruptingEventId";
    protected SProcessInstanceImpl entity;

    @Override
    public SProcessInstanceBuilder createNewInstance(String name, long processDefinitionId) {
        NullCheckingUtil.checkArgsNotNull(name, processDefinitionId);
        this.entity = new SProcessInstanceImpl(name, processDefinitionId);
        this.entity.setStateCategory(SStateCategory.NORMAL);
        return this;
    }

    @Override
    public SProcessInstanceBuilder createNewInstance(String name, long processDefinitionId, String description) {
        NullCheckingUtil.checkArgsNotNull(name, processDefinitionId);
        this.entity = new SProcessInstanceImpl(name, processDefinitionId);
        this.entity.setStateCategory(SStateCategory.NORMAL);
        this.entity.setDescription(description);
        return this;
    }

    @Override
    public SProcessInstanceBuilder createNewInstance(SProcessDefinition definition) {
        return this.createNewInstance(definition.getName(), definition.getId(), definition.getDescription());
    }

    @Override
    public SProcessInstance done() {
        return this.entity;
    }

    @Override
    public SProcessInstanceBuilder setName(String name) {
        this.entity.setName(name);
        return this;
    }

    @Override
    public SProcessInstanceBuilder setStartedBy(long startedBy) {
        this.entity.setStartedBy(startedBy);
        return this;
    }

    @Override
    public SProcessInstanceBuilder setStartedByDelegate(long startedByDelegate) {
        this.entity.setStartedByDelegate(startedByDelegate);
        return this;
    }

    @Override
    @Deprecated
    public SProcessInstanceBuilder setContainerId(long id) {
        this.entity.setContainerId(id);
        return this;
    }

    @Override
    public SProcessInstanceBuilder setCallerId(long callerId, SFlowNodeType callerType) {
        this.entity.setCallerId(callerId);
        this.entity.setCallerType(callerType);
        return this;
    }

    @Override
    public SProcessInstanceBuilder setMigrationPlanId(long migrationPlanId) {
        this.entity.setMigrationPlanId(migrationPlanId);
        return this;
    }

    @Override
    public SProcessInstanceBuilder setRootProcessInstanceId(long rootProcessInstanceId) {
        this.entity.setRootProcessInstanceId(rootProcessInstanceId);
        return this;
    }

    @Override
    public String getIdKey() {
        return ID_KEY;
    }

    @Override
    public String getNameKey() {
        return NAME_KEY;
    }

    @Override
    public String getProcessDefinitionIdKey() {
        return PROCESSDEF_ID_KEY;
    }

    @Override
    public String getStateIdKey() {
        return STATE_ID_KEY;
    }

    @Override
    public String getStateCategoryKey() {
        return STATE_CATEGORY_KEY;
    }

    @Override
    public String getStartDateKey() {
        return START_DATE_KEY;
    }

    @Override
    public String getStartedByKey() {
        return STARTED_BY_KEY;
    }

    @Override
    public String getStartedByDelegateKey() {
        return STARTED_BY_DELEGATE_KEY;
    }

    @Override
    public String getEndDateKey() {
        return END_DATE_KEY;
    }

    @Override
    public String getLastUpdateKey() {
        return LAST_UPDATE_KEY;
    }

    @Override
    public String getContainerIdKey() {
        return CONTAINER_ID_KEY;
    }

    @Override
    public String getInterruptingEventIdKey() {
        return INTERRUPTING_EVENT_ID_KEY;
    }

    @Override
    public String getMigrationPlanIdKey() {
        return MIGRATION_PLAN_ID;
    }

    @Override
    public String getCallerIdKey() {
        return CALLER_ID;
    }
}

