/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.core.process.instance.model.impl;

import org.bonitasoft.engine.core.process.instance.model.SFlowElementInstance;
import org.bonitasoft.engine.core.process.instance.model.SFlowElementsContainerType;
import org.bonitasoft.engine.core.process.instance.model.SStateCategory;
import org.bonitasoft.engine.core.process.instance.model.impl.SNamedElementImpl;

public abstract class SFlowElementInstanceImpl
extends SNamedElementImpl
implements SFlowElementInstance {
    private static final long serialVersionUID = 4771702652977437892L;
    private long rootContainerId;
    private long parentContainerId;
    private SStateCategory stateCategory = SStateCategory.NORMAL;
    private long logicalGroup1;
    private long logicalGroup2;
    private long logicalGroup3;
    private long logicalGroup4;
    private String description;
    private boolean terminal;
    private boolean stable;
    private Long tokenRefId;

    public SFlowElementInstanceImpl() {
    }

    public SFlowElementInstanceImpl(String name) {
        super(name);
    }

    public SFlowElementInstanceImpl(String name, long rootContainerId, long parentContainerId, long logicalGroup1, long logicalGroup2) {
        super(name);
        this.rootContainerId = rootContainerId;
        this.parentContainerId = parentContainerId;
        this.logicalGroup1 = logicalGroup1;
        this.logicalGroup2 = logicalGroup2;
    }

    @Override
    public long getParentContainerId() {
        return this.parentContainerId;
    }

    @Override
    public long getRootContainerId() {
        return this.rootContainerId;
    }

    @Override
    public long getProcessDefinitionId() {
        return this.logicalGroup1;
    }

    @Override
    public long getRootProcessInstanceId() {
        return this.logicalGroup2;
    }

    @Override
    public long getParentActivityInstanceId() {
        return this.logicalGroup3;
    }

    @Override
    public long getParentProcessInstanceId() {
        return this.logicalGroup4;
    }

    @Override
    public SFlowElementsContainerType getParentContainerType() {
        return this.getParentActivityInstanceId() <= 0L ? SFlowElementsContainerType.PROCESS : SFlowElementsContainerType.FLOWNODE;
    }

    @Override
    public long getLogicalGroup(int index) {
        switch (index) {
            case 0: {
                return this.logicalGroup1;
            }
            case 1: {
                return this.logicalGroup2;
            }
            case 2: {
                return this.logicalGroup3;
            }
            case 3: {
                return this.logicalGroup4;
            }
        }
        throw new IllegalArgumentException("Invalid index: the index must be 0, 1, 2 or 3");
    }

    public void setParentContainerId(long parentContainerId) {
        this.parentContainerId = parentContainerId;
    }

    public void setRootContainerId(long rootContainerId) {
        this.rootContainerId = rootContainerId;
    }

    @Override
    public boolean isAborting() {
        return SStateCategory.ABORTING.equals((Object)this.stateCategory);
    }

    @Override
    public boolean isCanceling() {
        return SStateCategory.CANCELLING.equals((Object)this.stateCategory);
    }

    @Override
    public SStateCategory getStateCategory() {
        return this.stateCategory;
    }

    public void setStateCategory(SStateCategory stateCategory) {
        this.stateCategory = stateCategory;
    }

    public void setLogicalGroup(int index, long value) {
        switch (index) {
            case 0: {
                this.logicalGroup1 = value;
                break;
            }
            case 1: {
                this.logicalGroup2 = value;
                break;
            }
            case 2: {
                this.logicalGroup3 = value;
                break;
            }
            case 3: {
                this.logicalGroup4 = value;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid index: the index must be 0, 1, 2 or 3");
            }
        }
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public boolean isStable() {
        return this.stable;
    }

    public void setStable(boolean stable) {
        this.stable = stable;
    }

    @Override
    public boolean isTerminal() {
        return this.terminal;
    }

    public void setTerminal(boolean terminal) {
        this.terminal = terminal;
    }

    @Override
    public Long getTokenRefId() {
        return this.tokenRefId;
    }

    public void setTokenRefId(Long tokenRefId) {
        this.tokenRefId = tokenRefId;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (int)(this.logicalGroup1 ^ this.logicalGroup1 >>> 32);
        result = 31 * result + (int)(this.logicalGroup2 ^ this.logicalGroup2 >>> 32);
        result = 31 * result + (int)(this.logicalGroup3 ^ this.logicalGroup3 >>> 32);
        result = 31 * result + (int)(this.logicalGroup4 ^ this.logicalGroup4 >>> 32);
        result = 31 * result + (int)(this.parentContainerId ^ this.parentContainerId >>> 32);
        result = 31 * result + (int)(this.rootContainerId ^ this.rootContainerId >>> 32);
        result = 31 * result + (this.stable ? 1231 : 1237);
        result = 31 * result + (this.stateCategory == null ? 0 : this.stateCategory.hashCode());
        result = 31 * result + (this.terminal ? 1231 : 1237);
        result = 31 * result + (int)(this.tokenRefId ^ this.tokenRefId >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SFlowElementInstanceImpl other = (SFlowElementInstanceImpl)obj;
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.logicalGroup1 != other.logicalGroup1) {
            return false;
        }
        if (this.logicalGroup2 != other.logicalGroup2) {
            return false;
        }
        if (this.logicalGroup3 != other.logicalGroup3) {
            return false;
        }
        if (this.logicalGroup4 != other.logicalGroup4) {
            return false;
        }
        if (this.parentContainerId != other.parentContainerId) {
            return false;
        }
        if (this.rootContainerId != other.rootContainerId) {
            return false;
        }
        if (this.stable != other.stable) {
            return false;
        }
        if (this.stateCategory != other.stateCategory) {
            return false;
        }
        if (this.terminal != other.terminal) {
            return false;
        }
        return this.tokenRefId == other.tokenRefId;
    }

    public String toString() {
        return "SFlowElementInstanceImpl [rootContainerId=" + this.rootContainerId + ", parentContainerId=" + this.parentContainerId + ", stateCategory=" + (Object)((Object)this.stateCategory) + ", logicalGroup1=" + this.logicalGroup1 + ", logicalGroup2=" + this.logicalGroup2 + ", logicalGroup3=" + this.logicalGroup3 + ", logicalGroup4=" + this.logicalGroup4 + ", description=" + this.description + ", terminal=" + this.terminal + ", stable=" + this.stable + ", tokenRefId=" + this.tokenRefId + "]";
    }
}

