/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.data.instance.api.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.bonitasoft.engine.archive.ArchiveInsertRecord;
import org.bonitasoft.engine.archive.ArchiveService;
import org.bonitasoft.engine.archive.SDefinitiveArchiveNotFound;
import org.bonitasoft.engine.commons.LogUtil;
import org.bonitasoft.engine.commons.NullCheckingUtil;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.data.DataService;
import org.bonitasoft.engine.data.instance.DataInstanceDataSource;
import org.bonitasoft.engine.data.instance.api.DataInstanceContainer;
import org.bonitasoft.engine.data.instance.api.DataInstanceService;
import org.bonitasoft.engine.data.instance.exception.SDataInstanceException;
import org.bonitasoft.engine.data.instance.exception.SDataInstanceNotFoundException;
import org.bonitasoft.engine.data.instance.exception.SDeleteDataInstanceException;
import org.bonitasoft.engine.data.instance.model.SDataInstance;
import org.bonitasoft.engine.data.instance.model.SDataInstanceVisibilityMapping;
import org.bonitasoft.engine.data.instance.model.archive.SADataInstance;
import org.bonitasoft.engine.data.instance.model.archive.SADataInstanceVisibilityMapping;
import org.bonitasoft.engine.data.instance.model.builder.SDataInstanceBuilders;
import org.bonitasoft.engine.data.model.SDataSource;
import org.bonitasoft.engine.events.model.SDeleteEvent;
import org.bonitasoft.engine.events.model.SEvent;
import org.bonitasoft.engine.events.model.SInsertEvent;
import org.bonitasoft.engine.events.model.builders.SEventBuilders;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.persistence.OrderByOption;
import org.bonitasoft.engine.persistence.OrderByType;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.persistence.ReadPersistenceService;
import org.bonitasoft.engine.persistence.SBonitaReadException;
import org.bonitasoft.engine.persistence.SelectListDescriptor;
import org.bonitasoft.engine.persistence.SelectOneDescriptor;
import org.bonitasoft.engine.recorder.Recorder;
import org.bonitasoft.engine.recorder.SRecorderException;
import org.bonitasoft.engine.recorder.model.DeleteRecord;
import org.bonitasoft.engine.recorder.model.EntityUpdateDescriptor;
import org.bonitasoft.engine.recorder.model.InsertRecord;

public class DataInstanceServiceImpl
implements DataInstanceService {
    public static final String DEFAULT_DATA_SOURCE = "bonita_data_source";
    public static final String DATA_SOURCE_VERSION = "6.0";
    public static final String TRANSIENT_DATA_SOURCE = "bonita_transient_data_source";
    public static final String TRANSIENT_DATA_SOURCE_VERSION = "6.0";
    private final DataService dataSourceService;
    private final SDataInstanceBuilders dataInstanceBuilders;
    private final Recorder recorder;
    private final SEventBuilders eventBuilders;
    private final ReadPersistenceService persistenceService;
    private final ArchiveService archiveService;
    private final TechnicalLoggerService logger;

    public DataInstanceServiceImpl(DataService dataSourceService, SDataInstanceBuilders dataInstanceBuilders, Recorder recorder, SEventBuilders eventBuilders, ReadPersistenceService persistenceService, ArchiveService archiveService, TechnicalLoggerService logger) {
        this.dataSourceService = dataSourceService;
        this.dataInstanceBuilders = dataInstanceBuilders;
        this.recorder = recorder;
        this.eventBuilders = eventBuilders;
        this.persistenceService = persistenceService;
        this.archiveService = archiveService;
        this.logger = logger;
    }

    @Override
    public void createDataInstance(SDataInstance dataInstance) throws SDataInstanceException {
        this.logBeforeMethod(TechnicalLogSeverity.TRACE, "createDataInstance");
        DataInstanceDataSource dataInstanceDataSource = this.getDataInstanceDataSource(dataInstance.isTransientData());
        dataInstanceDataSource.createDataInstance(dataInstance);
        this.archiveDataInstance(dataInstance);
        this.logAfterMethod(TechnicalLogSeverity.TRACE, "createDataInstance");
    }

    private DataInstanceDataSource getDataInstanceDataSource(String dataSourceName, String dataSourceVersion) throws SDataInstanceException {
        this.logBeforeMethod(TechnicalLogSeverity.TRACE, "getDataInstanceDataSource");
        try {
            SDataSource dataSource = this.dataSourceService.getDataSource(dataSourceName, dataSourceVersion);
            DataInstanceDataSource dataInstanceDataSource = this.dataSourceService.getDataSourceImplementation(DataInstanceDataSource.class, dataSource.getId());
            this.logAfterMethod(TechnicalLogSeverity.TRACE, "getDataInstanceDataSource");
            return dataInstanceDataSource;
        }
        catch (SBonitaException e) {
            this.logOnExceptionMethod(TechnicalLogSeverity.TRACE, "getDataInstanceDataSource", e);
            throw new SDataInstanceException("Unable to get data instance data source", e);
        }
    }

    private DataInstanceDataSource getDataInstanceDataSource(boolean isTransient) throws SDataInstanceException {
        this.logBeforeMethod(TechnicalLogSeverity.TRACE, "getDataInstanceDataSource");
        DataInstanceDataSource dataInstanceDataSource = isTransient ? this.getDataInstanceDataSource(TRANSIENT_DATA_SOURCE, "6.0") : this.getDataInstanceDataSource(DEFAULT_DATA_SOURCE, "6.0");
        this.logAfterMethod(TechnicalLogSeverity.TRACE, "getDataInstanceDataSource");
        return dataInstanceDataSource;
    }

    @Override
    public void updateDataInstance(SDataInstance dataInstance, EntityUpdateDescriptor descriptor) throws SDataInstanceException {
        this.logBeforeMethod(TechnicalLogSeverity.TRACE, "updateDataInstance");
        NullCheckingUtil.checkArgsNotNull(dataInstance, descriptor);
        DataInstanceDataSource dataInstanceDataSource = this.getDataInstanceDataSource(dataInstance.isTransientData());
        dataInstanceDataSource.updateDataInstance(dataInstance, descriptor);
        this.logAfterMethod(TechnicalLogSeverity.TRACE, "updateDataInstance");
        this.archiveDataInstance(dataInstance);
    }

    private void archiveDataInstance(SDataInstance sDataInstance) throws SDataInstanceException {
        this.archiveDataInstance(sDataInstance, System.currentTimeMillis());
    }

    private void archiveDataInstance(SDataInstance sDataInstance, long archiveDate) throws SDataInstanceException {
        if (!sDataInstance.isTransientData().booleanValue()) {
            try {
                SADataInstance saDataInstance = this.dataInstanceBuilders.getSADataInstanceBuilder().createNewInstance(sDataInstance).done();
                ArchiveInsertRecord archiveInsertRecord = new ArchiveInsertRecord(saDataInstance);
                this.archiveService.recordInsert(archiveDate, archiveInsertRecord);
            }
            catch (SDefinitiveArchiveNotFound e) {
                this.logOnExceptionMethod(TechnicalLogSeverity.TRACE, "updateDataInstance", e);
                throw new SDataInstanceException("Unable to create SADataInstance", e);
            }
            catch (SRecorderException e) {
                this.logOnExceptionMethod(TechnicalLogSeverity.TRACE, "updateDataInstance", e);
                throw new SDataInstanceException("Unable to create SADataInstance", e);
            }
        }
    }

    @Override
    public void archiveLocalDataInstancesFromProcessInstance(long processInstanceId, long archiveDate) throws SDataInstanceException {
        int archiveBatchSize = 50;
        int currentIndex = 0;
        List<SDataInstance> sDataInstances = this.getLocalDataInstances(processInstanceId, DataInstanceContainer.PROCESS_INSTANCE.toString(), currentIndex, 50);
        while (sDataInstances != null && sDataInstances.size() > 0) {
            for (SDataInstance sDataInstance : sDataInstances) {
                this.archiveDataInstance(sDataInstance, archiveDate);
            }
            sDataInstances = this.getLocalDataInstances(processInstanceId, DataInstanceContainer.PROCESS_INSTANCE.toString(), currentIndex += 50, 50);
        }
    }

    @Override
    public void deleteDataInstance(SDataInstance dataInstance) throws SDataInstanceException {
        this.logBeforeMethod(TechnicalLogSeverity.TRACE, "deleteDataInstance");
        NullCheckingUtil.checkArgsNotNull(dataInstance);
        DataInstanceDataSource dataInstanceDataSource = this.getDataInstanceDataSource(dataInstance.isTransientData());
        dataInstanceDataSource.deleteDataInstance(dataInstance);
        this.logAfterMethod(TechnicalLogSeverity.TRACE, "deleteDataInstance");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SDataInstance getDataInstance(long dataInstanceId) throws SDataInstanceException {
        this.logBeforeMethod(TechnicalLogSeverity.TRACE, "getDataInstance");
        try {
            SDataInstance sDataInstance = this.getDataInstanceById(dataInstanceId);
            return sDataInstance;
        }
        finally {
            this.logAfterMethod(TechnicalLogSeverity.TRACE, "getDataInstance");
        }
    }

    @Override
    public SDataInstance getDataInstance(String dataName, long containerId, String containerType) throws SDataInstanceException {
        this.logBeforeMethod(TechnicalLogSeverity.TRACE, "getDataInstance");
        NullCheckingUtil.checkArgsNotNull(dataName, containerType);
        try {
            long dataInstanceId = this.getDataInstanceDataVisibilityMapping(dataName, containerId, containerType);
            SDataInstance sDataInstance = this.getDataInstanceById(dataInstanceId);
            return sDataInstance;
        }
        catch (SBonitaReadException e) {
            this.logOnExceptionMethod(TechnicalLogSeverity.TRACE, "getDataInstance", e);
            throw new SDataInstanceException("No data found with name " + dataName + "  neither on container " + containerId + " with type " + containerType + " nor in its parents", e);
        }
        finally {
            this.logAfterMethod(TechnicalLogSeverity.TRACE, "getDataInstance");
        }
    }

    private SDataInstance getDataInstanceById(long dataInstanceId) throws SDataInstanceException {
        DataInstanceDataSource transientDataInstanceDataSource = this.getDataInstanceDataSource(TRANSIENT_DATA_SOURCE, "6.0");
        try {
            return transientDataInstanceDataSource.getDataInstance(dataInstanceId);
        }
        catch (SDataInstanceException e) {
            this.logOnExceptionMethod(TechnicalLogSeverity.TRACE, "getDataInstance", e);
            DataInstanceDataSource defaultDataInstanceDataSource = this.getDataInstanceDataSource(DEFAULT_DATA_SOURCE, "6.0");
            return defaultDataInstanceDataSource.getDataInstance(dataInstanceId);
        }
    }

    private long getDataInstanceDataVisibilityMapping(String dataName, long containerId, String containerType) throws SBonitaReadException {
        HashMap<String, Object> parameters = new HashMap<String, Object>(3);
        parameters.put("dataName", dataName);
        parameters.put("containerId", containerId);
        parameters.put("containerType", containerType);
        SelectOneDescriptor selectOneDescriptor = new SelectOneDescriptor("getDataInstanceIdFromMapping", parameters, SDataInstanceVisibilityMapping.class);
        Long dataInstanceId = (Long)this.persistenceService.selectOne(selectOneDescriptor);
        if (dataInstanceId == null) {
            StringBuilder stb = new StringBuilder("DataInstance with name not found from mapping: [name: ");
            stb.append(dataName).append(", container type: ").append(containerType);
            stb.append(", container id: ").append(containerId).append(']');
            throw new SBonitaReadException(stb.toString(), null, selectOneDescriptor);
        }
        return dataInstanceId;
    }

    private List<Long> getDataInstanceDataVisibilityMapping(List<String> dataNames, long containerId, String containerType) throws SBonitaReadException {
        HashMap<String, Object> parameters = new HashMap<String, Object>(3);
        parameters.put("dataNames", dataNames);
        parameters.put("containerId", containerId);
        parameters.put("containerType", containerType);
        SelectListDescriptor selectListDescriptor = new SelectListDescriptor("getDataInstanceIdsFromMapping", parameters, SDataInstanceVisibilityMapping.class, new QueryOptions(0, dataNames.size()));
        return this.persistenceService.selectList(selectListDescriptor);
    }

    private long getSADataInstanceDataVisibilityMapping(String dataName, long containerId, String containerType) throws SBonitaReadException {
        HashMap<String, Object> parameters = new HashMap<String, Object>(3);
        parameters.put("dataName", dataName);
        parameters.put("containerId", containerId);
        parameters.put("containerType", containerType);
        SelectOneDescriptor selectOneDescriptor = new SelectOneDescriptor("getSADataInstanceIdFromMapping", parameters, SADataInstanceVisibilityMapping.class);
        Long dataInstanceId = (Long)this.persistenceService.selectOne(selectOneDescriptor);
        if (dataInstanceId == null) {
            StringBuilder stb = new StringBuilder("DataInstance with name not found from mapping: [name: ");
            stb.append(dataName).append(", container type: ").append(containerType);
            stb.append(", container id: ").append(containerId).append(']');
            throw new SBonitaReadException(stb.toString(), null, selectOneDescriptor);
        }
        return dataInstanceId;
    }

    private List<Long> getSADataInstanceDataVisibilityMapping(List<String> dataNames, long containerId, String containerType) throws SBonitaReadException {
        HashMap<String, Object> parameters = new HashMap<String, Object>(3);
        parameters.put("dataNames", dataNames);
        parameters.put("containerId", containerId);
        parameters.put("containerType", containerType);
        SelectListDescriptor selectListDescriptor = new SelectListDescriptor("getSADataInstanceIdsFromMapping", parameters, SADataInstanceVisibilityMapping.class, new QueryOptions(0, dataNames.size()));
        return this.persistenceService.selectList(selectListDescriptor);
    }

    @Override
    public List<SDataInstance> getDataInstances(long containerId, String containerType, int fromIndex, int numberOfResults) throws SDataInstanceException {
        this.logBeforeMethod(TechnicalLogSeverity.TRACE, "getDataInstances");
        NullCheckingUtil.checkArgsNotNull(containerType);
        try {
            List<SDataInstanceVisibilityMapping> mappings = this.getDataInstanceVisibilityMappings(containerId, containerType, fromIndex, numberOfResults);
            ArrayList<SDataInstance> dataInstances = new ArrayList<SDataInstance>(mappings.size());
            for (SDataInstanceVisibilityMapping mapping : mappings) {
                dataInstances.add(this.getDataInstance(mapping.getDataInstanceId()));
            }
            this.logAfterMethod(TechnicalLogSeverity.TRACE, "getDataInstances");
            return dataInstances;
        }
        catch (SBonitaReadException e) {
            this.logOnExceptionMethod(TechnicalLogSeverity.TRACE, "getDataInstances", e);
            throw new SDataInstanceException("Unable to read data mappings of the container with type " + containerType + " and id " + containerId, e);
        }
    }

    private List<SDataInstanceVisibilityMapping> getDataInstanceVisibilityMappings(long containerId, String containerType, int fromIndex, int numberOfResults) throws SBonitaReadException {
        HashMap<String, Object> parameters = new HashMap<String, Object>(2);
        parameters.put("containerId", containerId);
        parameters.put("containerType", containerType);
        SelectListDescriptor selectDescriptor = new SelectListDescriptor("getDataInstanceVisibilityMappings", parameters, SDataInstanceVisibilityMapping.class, new QueryOptions(fromIndex, numberOfResults));
        return this.persistenceService.selectList(selectDescriptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SDataInstance getLocalDataInstance(String dataName, long containerId, String containerType) throws SDataInstanceException {
        this.logBeforeMethod(TechnicalLogSeverity.TRACE, "getLocalDataInstance");
        NullCheckingUtil.checkArgsNotNull(dataName);
        NullCheckingUtil.checkArgsNotNull(containerType);
        DataInstanceDataSource transientDataInstanceDataSource = this.getDataInstanceDataSource(TRANSIENT_DATA_SOURCE, "6.0");
        try {
            SDataInstance sDataInstance = transientDataInstanceDataSource.getDataInstance(dataName, containerId, containerType);
            return sDataInstance;
        }
        catch (SDataInstanceException e) {
            this.logOnExceptionMethod(TechnicalLogSeverity.TRACE, "getLocalDataInstance", e);
            DataInstanceDataSource defaultDataInstanceDataSource = this.getDataInstanceDataSource(DEFAULT_DATA_SOURCE, "6.0");
            SDataInstance sDataInstance = defaultDataInstanceDataSource.getDataInstance(dataName, containerId, containerType);
            return sDataInstance;
        }
        finally {
            this.logAfterMethod(TechnicalLogSeverity.TRACE, "getLocalDataInstance");
        }
    }

    @Override
    public List<SDataInstance> getLocalDataInstances(long containerId, String containerType, int fromIndex, int numberOfResults) throws SDataInstanceException {
        this.logBeforeMethod(TechnicalLogSeverity.TRACE, "getLocalDataInstances");
        NullCheckingUtil.checkArgsNotNull(containerType);
        DataInstanceDataSource transientDataInstanceDataSource = this.getDataInstanceDataSource(TRANSIENT_DATA_SOURCE, "6.0");
        DataInstanceDataSource defaultDataInstanceDataSource = this.getDataInstanceDataSource(DEFAULT_DATA_SOURCE, "6.0");
        try {
            List<SDataInstance> transientDataInstances = transientDataInstanceDataSource.getDataInstances(containerId, containerType, fromIndex, numberOfResults);
            List<SDataInstance> dataInstances = defaultDataInstanceDataSource.getDataInstances(containerId, containerType, fromIndex, numberOfResults);
            dataInstances.addAll(transientDataInstances);
            List<SDataInstance> list = dataInstances;
            return list;
        }
        catch (SDataInstanceException e) {
            this.logOnExceptionMethod(TechnicalLogSeverity.TRACE, "getLocalDataInstances", e);
            throw e;
        }
        finally {
            this.logAfterMethod(TechnicalLogSeverity.TRACE, "getLocalDataInstances");
        }
    }

    @Override
    public void addChildContainer(long parentContainerId, String parentContainerType, long containerId, String containerType) throws SDataInstanceException {
        this.logBeforeMethod(TechnicalLogSeverity.TRACE, "addChildContainer");
        try {
            List<SDataInstanceVisibilityMapping> mappings = this.insertMappingForLocalElement(containerId, containerType);
            ArrayList<String> localData = new ArrayList<String>(mappings.size());
            for (SDataInstanceVisibilityMapping sDataInstanceVisibilityMapping : mappings) {
                localData.add(sDataInstanceVisibilityMapping.getDataName());
            }
            long archivedDate = System.currentTimeMillis();
            int batchSize = 80;
            int currentIndex = 0;
            List<SDataInstance> parentVisibleDataInstances = this.getDataInstances(parentContainerId, parentContainerType, currentIndex, 80);
            while (parentVisibleDataInstances.size() > 0) {
                for (SDataInstance parentData : parentVisibleDataInstances) {
                    if (localData.contains(parentData.getName())) continue;
                    this.insertDataInstanceVisibilityMapping(containerId, containerType, parentData.getName(), parentData.getId(), archivedDate);
                }
                parentVisibleDataInstances = this.getDataInstances(parentContainerId, parentContainerType, currentIndex += 80, 80);
            }
            this.logAfterMethod(TechnicalLogSeverity.TRACE, "addChildContainer");
        }
        catch (SRecorderException e) {
            this.logOnExceptionMethod(TechnicalLogSeverity.TRACE, "addChildContainer", e);
            throw new SDataInstanceException(e);
        }
        catch (SDefinitiveArchiveNotFound e) {
            this.logOnExceptionMethod(TechnicalLogSeverity.TRACE, "addChildContainer", e);
            throw new SDataInstanceException(e);
        }
    }

    @Override
    public void removeContainer(long containerId, String containerType) throws SDataInstanceException {
        this.logBeforeMethod(TechnicalLogSeverity.TRACE, "removeContainer");
        try {
            List<SDataInstanceVisibilityMapping> visibilityMappings;
            do {
                visibilityMappings = this.getDataInstanceVisibilityMappings(containerId, containerType, 0, 20);
                for (SDataInstanceVisibilityMapping sDataInstanceVisibilityMapping : visibilityMappings) {
                    this.deleteDataInstanceVisibilityMapping(sDataInstanceVisibilityMapping);
                }
            } while (visibilityMappings.size() > 0);
            this.logAfterMethod(TechnicalLogSeverity.TRACE, "removeContainer");
        }
        catch (SBonitaReadException e) {
            this.logOnExceptionMethod(TechnicalLogSeverity.TRACE, "removeContainer", e);
            throw new SDataInstanceException(e);
        }
    }

    private void deleteDataInstanceVisibilityMapping(SDataInstanceVisibilityMapping sDataInstanceVisibilityMapping) throws SDataInstanceException {
        DeleteRecord record = new DeleteRecord(sDataInstanceVisibilityMapping);
        SDeleteEvent deleteEvent = (SDeleteEvent)this.eventBuilders.getEventBuilder().createDeleteEvent("DATA_VISIBILITY_MAPPING").done();
        try {
            this.recorder.recordDelete(record, deleteEvent);
        }
        catch (SRecorderException e) {
            this.logOnExceptionMethod(TechnicalLogSeverity.TRACE, "removeContainer", e);
            throw new SDataInstanceException(e);
        }
    }

    @Override
    public List<SDataInstanceVisibilityMapping> createDataContainer(long containerId, String containerType) throws SDataInstanceException {
        this.logBeforeMethod(TechnicalLogSeverity.TRACE, "createDataContainer");
        try {
            List<SDataInstanceVisibilityMapping> listSDataInstanceVisibilityMapping = this.insertMappingForLocalElement(containerId, containerType);
            this.logAfterMethod(TechnicalLogSeverity.TRACE, "createDataContainer");
            return listSDataInstanceVisibilityMapping;
        }
        catch (SRecorderException e) {
            this.logOnExceptionMethod(TechnicalLogSeverity.TRACE, "createDataContainer", e);
            throw new SDataInstanceException(e);
        }
        catch (SDefinitiveArchiveNotFound e) {
            this.logOnExceptionMethod(TechnicalLogSeverity.TRACE, "createDataContainer", e);
            throw new SDataInstanceException(e);
        }
    }

    protected List<SDataInstanceVisibilityMapping> insertMappingForLocalElement(long containerId, String containerType) throws SRecorderException, SDataInstanceException, SDefinitiveArchiveNotFound {
        int batchSize = 50;
        int currentIndex = 0;
        long archiveDate = System.currentTimeMillis();
        List<SDataInstance> localDataInstances = this.getLocalDataInstances(containerId, containerType, 0, 50);
        ArrayList<SDataInstanceVisibilityMapping> mappings = new ArrayList<SDataInstanceVisibilityMapping>(localDataInstances.size());
        while (localDataInstances != null && localDataInstances.size() > 0) {
            for (SDataInstance sDataInstance : localDataInstances) {
                mappings.add(this.insertDataInstanceVisibilityMapping(containerId, containerType, sDataInstance.getName(), sDataInstance.getId(), archiveDate));
            }
            localDataInstances = this.getLocalDataInstances(containerId, containerType, currentIndex += 50, 50);
        }
        return mappings;
    }

    protected SDataInstanceVisibilityMapping insertDataInstanceVisibilityMapping(long containerId, String containerType, String dataName, long dataInstanceId, long archiveDate) throws SRecorderException, SDefinitiveArchiveNotFound {
        SDataInstanceVisibilityMapping mapping = this.dataInstanceBuilders.getDataInstanceVisibilityMappingBuilder().createNewInstance(containerId, containerType, dataName, dataInstanceId).done();
        InsertRecord record = new InsertRecord(mapping);
        SInsertEvent insertEvent = (SInsertEvent)this.eventBuilders.getEventBuilder().createInsertEvent("DATA_VISIBILITY_MAPPING").done();
        this.recorder.recordInsert(record, insertEvent);
        SADataInstanceVisibilityMapping archivedMapping = this.dataInstanceBuilders.getArchivedDataInstanceVisibilityMappingBuilder().createNewInstance(containerId, containerType, dataName, dataInstanceId, mapping.getId()).done();
        this.archiveService.recordInsert(archiveDate, new ArchiveInsertRecord(archivedMapping));
        return mapping;
    }

    @Override
    public SADataInstance getSADataInstance(long containerId, String containerType, String dataName, long time) throws SDataInstanceException {
        this.logBeforeMethod(TechnicalLogSeverity.TRACE, "getSADataInstance");
        try {
            long dataInstanceId = this.getSADataInstanceDataVisibilityMapping(dataName, containerId, containerType);
            ReadPersistenceService readPersistenceService = this.archiveService.getDefinitiveArchiveReadPersistenceService();
            HashMap<String, Object> parameters = new HashMap<String, Object>(2);
            parameters.put("dataInstanceId", dataInstanceId);
            parameters.put("time", time);
            SADataInstance saDataInstance = (SADataInstance)readPersistenceService.selectOne(new SelectOneDescriptor("getSADataInstanceByDataInstanceIdAndArchiveDate", parameters, SADataInstance.class));
            this.logAfterMethod(TechnicalLogSeverity.TRACE, "getSADataInstance");
            return saDataInstance;
        }
        catch (SBonitaReadException e) {
            this.logOnExceptionMethod(TechnicalLogSeverity.TRACE, "getSADataInstance", e);
            throw new SDataInstanceException("Unable to read SADataInstance", e);
        }
    }

    @Override
    public SADataInstance getSADataInstance(long sourceObjectId, long time) throws SDataInstanceException {
        this.logBeforeMethod(TechnicalLogSeverity.TRACE, "getSADataInstance");
        try {
            ReadPersistenceService readPersistenceService = this.archiveService.getDefinitiveArchiveReadPersistenceService();
            HashMap<String, Object> parameters = new HashMap<String, Object>(2);
            parameters.put("dataInstanceId", sourceObjectId);
            parameters.put("time", time);
            SADataInstance saDataInstance = (SADataInstance)readPersistenceService.selectOne(new SelectOneDescriptor("getSADataInstanceByDataInstanceIdAndArchiveDate", parameters, SADataInstance.class));
            this.logAfterMethod(TechnicalLogSeverity.TRACE, "getSADataInstance");
            return saDataInstance;
        }
        catch (SBonitaReadException e) {
            this.logOnExceptionMethod(TechnicalLogSeverity.TRACE, "getSADataInstance", e);
            throw new SDataInstanceException("Unable to read SADataInstance", e);
        }
    }

    @Override
    public List<SADataInstance> getSADataInstances(long dataInstanceId) throws SDataInstanceException {
        this.logBeforeMethod(TechnicalLogSeverity.TRACE, "getSADataInstances");
        try {
            ReadPersistenceService readPersistenceService = this.archiveService.getDefinitiveArchiveReadPersistenceService();
            HashMap<String, Object> parameters = new HashMap<String, Object>(1);
            parameters.put("dataInstanceId", dataInstanceId);
            List<SADataInstance> listSADataInstance = readPersistenceService.selectList(new SelectListDescriptor("getSADataInstanceByDataInstanceId", parameters, SADataInstance.class, new QueryOptions(Collections.singletonList(new OrderByOption(SADataInstance.class, this.dataInstanceBuilders.getDataInstanceBuilder().getArchiveDateKey(), OrderByType.DESC)))));
            this.logAfterMethod(TechnicalLogSeverity.TRACE, "getSADataInstances");
            return listSADataInstance;
        }
        catch (SBonitaReadException e) {
            this.logOnExceptionMethod(TechnicalLogSeverity.TRACE, "getSADataInstances", e);
            throw new SDataInstanceException("Unable to read SADataInstance", e);
        }
    }

    @Override
    public SADataInstance getLastSADataInstance(long dataInstanceId) throws SDataInstanceException {
        this.logBeforeMethod(TechnicalLogSeverity.TRACE, "getLastSADataInstance");
        try {
            ReadPersistenceService readPersistenceService = this.archiveService.getDefinitiveArchiveReadPersistenceService();
            HashMap<String, Object> parameters = new HashMap<String, Object>(1);
            parameters.put("dataInstanceId", dataInstanceId);
            SADataInstance saDataInstance = (SADataInstance)readPersistenceService.selectOne(new SelectOneDescriptor("getLastSADataInstanceByDataInstanceId", parameters, SADataInstance.class));
            this.logAfterMethod(TechnicalLogSeverity.TRACE, "getLastSADataInstance");
            return saDataInstance;
        }
        catch (SBonitaReadException e) {
            this.logOnExceptionMethod(TechnicalLogSeverity.TRACE, "getLastSADataInstance", e);
            throw new SDataInstanceException("Unable to read SADataInstance", e);
        }
    }

    @Override
    public SADataInstance getLastSADataInstance(String dataName, long containerId, String containerType) throws SDataInstanceException {
        this.logBeforeMethod(TechnicalLogSeverity.TRACE, "getLastSADataInstance");
        ReadPersistenceService readPersistenceService = this.archiveService.getDefinitiveArchiveReadPersistenceService();
        HashMap<String, Object> parameters = new HashMap<String, Object>(1);
        parameters.put("dataName", dataName);
        parameters.put("containerId", containerId);
        parameters.put("containerType", containerType);
        try {
            SADataInstance saDataInstance = (SADataInstance)readPersistenceService.selectOne(new SelectOneDescriptor("getLastSADataInstanceByContainer", parameters, SADataInstance.class));
            if (saDataInstance == null) {
                SDataInstanceNotFoundException exception = new SDataInstanceNotFoundException("No archived data instance found for data:" + dataName + " in container: " + containerType + " " + containerId);
                this.logOnExceptionMethod(TechnicalLogSeverity.TRACE, "getLastSADataInstance", exception);
                throw exception;
            }
            this.logAfterMethod(TechnicalLogSeverity.TRACE, "getLastSADataInstance");
            return saDataInstance;
        }
        catch (SBonitaReadException e) {
            this.logOnExceptionMethod(TechnicalLogSeverity.TRACE, "getLastSADataInstance", e);
            throw new SDataInstanceException("Unable to read SADataInstance", e);
        }
    }

    @Override
    public List<SADataInstance> getLastLocalSADataInstances(long containerId, String containerType, int startIndex, int maxResults) throws SDataInstanceException {
        this.logBeforeMethod(TechnicalLogSeverity.TRACE, "getLastLocalSADataInstances");
        try {
            ReadPersistenceService readPersistenceService = this.archiveService.getDefinitiveArchiveReadPersistenceService();
            HashMap<String, Object> parameters = new HashMap<String, Object>(2);
            parameters.put("containerId", containerId);
            parameters.put("containerType", containerType);
            List<SADataInstance> saDataInstances = readPersistenceService.selectList(new SelectListDescriptor("getLastLocalSADataInstances", parameters, SADataInstance.class, new QueryOptions(startIndex, maxResults)));
            this.logAfterMethod(TechnicalLogSeverity.TRACE, "getLastLocalSADataInstances");
            return saDataInstances;
        }
        catch (SBonitaReadException e) {
            this.logOnExceptionMethod(TechnicalLogSeverity.TRACE, "getLastLocalSADataInstances", e);
            throw new SDataInstanceException("Unable to read SADataInstance", e);
        }
    }

    @Override
    public long getNumberOfDataInstances(long containerId, DataInstanceContainer containerType) throws SDataInstanceException {
        Long dataInstanceId;
        this.logBeforeMethod(TechnicalLogSeverity.TRACE, "getNumberOfDataInstances");
        HashMap<String, Object> parameters = new HashMap<String, Object>(2);
        parameters.put("containerId", containerId);
        parameters.put("containerType", containerType.toString());
        SelectOneDescriptor selectOneDescriptor = new SelectOneDescriptor("getNumberOfDataInstancesForContainer", parameters, SDataInstanceVisibilityMapping.class);
        try {
            dataInstanceId = (Long)this.persistenceService.selectOne(selectOneDescriptor);
        }
        catch (SBonitaReadException e) {
            this.logOnExceptionMethod(TechnicalLogSeverity.TRACE, "getNumberOfDataInstances", e);
            throw new SDataInstanceException(e);
        }
        this.logAfterMethod(TechnicalLogSeverity.TRACE, "getNumberOfDataInstances");
        return dataInstanceId;
    }

    @Override
    public List<SDataInstance> getDataInstances(List<String> dataNames, long containerId, String containerType) throws SDataInstanceException {
        this.logBeforeMethod(TechnicalLogSeverity.TRACE, "getDataInstances");
        NullCheckingUtil.checkArgsNotNull(dataNames, containerType);
        if (dataNames.isEmpty()) {
            return Collections.emptyList();
        }
        try {
            List<Long> dataInstanceIds = this.getDataInstanceDataVisibilityMapping(dataNames, containerId, containerType);
            DataInstanceDataSource transientDataInstanceDataSource = this.getDataInstanceDataSource(TRANSIENT_DATA_SOURCE, "6.0");
            List<SDataInstance> result = null;
            try {
                result = transientDataInstanceDataSource.getDataInstances(dataInstanceIds);
            }
            catch (SDataInstanceException e) {
                this.logOnExceptionMethod(TechnicalLogSeverity.TRACE, "getDataInstances", e);
            }
            if (result == null || result.size() < dataNames.size()) {
                DataInstanceDataSource defaultDataInstanceDataSource = this.getDataInstanceDataSource(DEFAULT_DATA_SOURCE, "6.0");
                ArrayList<SDataInstance> finalResult = new ArrayList<SDataInstance>(dataNames.size());
                if (result != null) {
                    finalResult.addAll(result);
                }
                finalResult.addAll(defaultDataInstanceDataSource.getDataInstances(dataInstanceIds));
                result = finalResult;
            }
            this.logAfterMethod(TechnicalLogSeverity.TRACE, "getDataInstances");
            return result;
        }
        catch (SBonitaReadException e) {
            this.logOnExceptionMethod(TechnicalLogSeverity.TRACE, "getDataInstances", e);
            throw new SDataInstanceException("Unable to find the data in the data mapping with name = " + dataNames + ", containerId = " + containerId + ", containerType = " + containerType, e);
        }
    }

    @Override
    public List<SADataInstance> getSADataInstances(long containerId, String containerType, List<String> dataNames, long time) throws SDataInstanceException {
        this.logBeforeMethod(TechnicalLogSeverity.TRACE, "getSADataInstances");
        if (dataNames.isEmpty()) {
            return Collections.emptyList();
        }
        try {
            List<Long> dataInstanceIds = this.getSADataInstanceDataVisibilityMapping(dataNames, containerId, containerType);
            ReadPersistenceService readPersistenceService = this.archiveService.getDefinitiveArchiveReadPersistenceService();
            HashMap<String, Object> parameters = new HashMap<String, Object>(2);
            parameters.put("dataInstanceIds", dataInstanceIds);
            parameters.put("time", time);
            List<SADataInstance> listSADataInstance = readPersistenceService.selectList(new SelectListDescriptor("getSADataInstancesByDataInstanceIdAndArchiveDate", parameters, SADataInstance.class, new QueryOptions(0, dataInstanceIds.size())));
            this.logAfterMethod(TechnicalLogSeverity.TRACE, "getSADataInstances");
            return listSADataInstance;
        }
        catch (SBonitaReadException e) {
            this.logOnExceptionMethod(TechnicalLogSeverity.TRACE, "getSADataInstances", e);
            throw new SDataInstanceException("Unable to read SADataInstance", e);
        }
    }

    @Override
    public List<SADataInstance> getLocalSADataInstances(long containerId, String containerType, int fromIndex, int numberOfResults) throws SDataInstanceException {
        this.logBeforeMethod(TechnicalLogSeverity.TRACE, "getLocalSADataInstances");
        try {
            ReadPersistenceService readPersistenceService = this.archiveService.getDefinitiveArchiveReadPersistenceService();
            HashMap<String, Object> parameters = new HashMap<String, Object>(2);
            parameters.put("containerId", containerId);
            parameters.put("containerType", containerType);
            List<SADataInstance> saDataInstances = readPersistenceService.selectList(new SelectListDescriptor("getLocalSADataInstances", parameters, SADataInstance.class, new QueryOptions(fromIndex, numberOfResults)));
            this.logAfterMethod(TechnicalLogSeverity.TRACE, "getLocalSADataInstances");
            return saDataInstances;
        }
        catch (SBonitaReadException e) {
            this.logOnExceptionMethod(TechnicalLogSeverity.TRACE, "getLocalSADataInstances", e);
            throw new SDataInstanceException("Unable to read SADataInstance", e);
        }
    }

    @Override
    public void deleteSADataInstance(SADataInstance dataInstance) throws SDeleteDataInstanceException {
        NullCheckingUtil.checkArgsNotNull(dataInstance);
        DeleteRecord deleteRecord = new DeleteRecord(dataInstance);
        SEvent event = this.eventBuilders.getEventBuilder().createDeleteEvent("DATA_INSTANCE").setObject(dataInstance).done();
        SDeleteEvent deleteEvent = (SDeleteEvent)event;
        try {
            this.recorder.recordDelete(deleteRecord, deleteEvent);
        }
        catch (SRecorderException e) {
            throw new SDeleteDataInstanceException("Impossible to delete data instance", e);
        }
    }

    @Override
    public void deleteLocalArchivedDataInstances(long containerId, String dataInstanceContainerType) throws SDataInstanceException {
        List<SADataInstance> sDataInstances;
        do {
            sDataInstances = this.getLocalSADataInstances(containerId, dataInstanceContainerType, 0, 100);
            for (SADataInstance sDataInstance : sDataInstances) {
                this.deleteSADataInstance(sDataInstance);
            }
        } while (!sDataInstances.isEmpty());
    }

    @Override
    public void deleteLocalDataInstances(long containerId, String dataInstanceContainerType, boolean dataPresent) throws SDataInstanceException {
        if (dataPresent) {
            int deleteBatchSize = 80;
            List<SDataInstance> sDataInstances = this.getLocalDataInstances(containerId, dataInstanceContainerType, 0, 80);
            while (sDataInstances.size() > 0) {
                for (SDataInstance sDataInstance : sDataInstances) {
                    this.deleteDataInstance(sDataInstance);
                }
                sDataInstances = this.getLocalDataInstances(containerId, dataInstanceContainerType, 0, 80);
            }
        }
        this.removeContainer(containerId, dataInstanceContainerType);
    }

    private void logBeforeMethod(TechnicalLogSeverity technicalLogSeverity, String methodName) {
        if (this.logger.isLoggable(this.getClass(), technicalLogSeverity)) {
            this.logger.log(this.getClass(), technicalLogSeverity, LogUtil.getLogBeforeMethod(this.getClass(), methodName));
        }
    }

    private void logAfterMethod(TechnicalLogSeverity technicalLogSeverity, String methodName) {
        if (this.logger.isLoggable(this.getClass(), technicalLogSeverity)) {
            this.logger.log(this.getClass(), technicalLogSeverity, LogUtil.getLogAfterMethod(this.getClass(), methodName));
        }
    }

    private void logOnExceptionMethod(TechnicalLogSeverity technicalLogSeverity, String methodName, Exception e) {
        if (this.logger.isLoggable(this.getClass(), technicalLogSeverity)) {
            this.logger.log(this.getClass(), technicalLogSeverity, LogUtil.getLogOnExceptionMethod(this.getClass(), methodName, e));
        }
    }
}

