/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.execution;

import java.util.List;
import org.bonitasoft.engine.archive.ArchiveService;
import org.bonitasoft.engine.bpm.process.ProcessInstanceState;
import org.bonitasoft.engine.classloader.ClassLoaderService;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.core.connector.ConnectorInstanceService;
import org.bonitasoft.engine.core.expression.control.model.SExpressionContext;
import org.bonitasoft.engine.core.operation.OperationService;
import org.bonitasoft.engine.core.operation.model.SOperation;
import org.bonitasoft.engine.core.process.comment.api.SCommentService;
import org.bonitasoft.engine.core.process.comment.api.SystemCommentType;
import org.bonitasoft.engine.core.process.definition.ProcessDefinitionService;
import org.bonitasoft.engine.core.process.definition.model.SProcessDefinition;
import org.bonitasoft.engine.core.process.instance.api.ActivityInstanceService;
import org.bonitasoft.engine.core.process.instance.api.ProcessInstanceService;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SActivityExecutionException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SActivityStateExecutionException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SFlowNodeExecutionException;
import org.bonitasoft.engine.core.process.instance.api.states.FlowNodeState;
import org.bonitasoft.engine.core.process.instance.api.states.StateCode;
import org.bonitasoft.engine.core.process.instance.model.SActivityInstance;
import org.bonitasoft.engine.core.process.instance.model.SFlowElementsContainerType;
import org.bonitasoft.engine.core.process.instance.model.SFlowNodeInstance;
import org.bonitasoft.engine.core.process.instance.model.SProcessInstance;
import org.bonitasoft.engine.core.process.instance.model.builder.BPMInstanceBuilders;
import org.bonitasoft.engine.core.process.instance.model.builder.SFlowNodeInstanceLogBuilder;
import org.bonitasoft.engine.data.instance.api.DataInstanceContainer;
import org.bonitasoft.engine.data.instance.api.DataInstanceService;
import org.bonitasoft.engine.execution.ContainerRegistry;
import org.bonitasoft.engine.execution.FlowNodeExecutor;
import org.bonitasoft.engine.execution.archive.ProcessArchiver;
import org.bonitasoft.engine.execution.state.FlowNodeStateManager;
import org.bonitasoft.engine.execution.work.WorkFactory;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.queriablelogger.model.SQueriableLogSeverity;
import org.bonitasoft.engine.queriablelogger.model.builder.HasCRUDEAction;
import org.bonitasoft.engine.queriablelogger.model.builder.SLogBuilder;
import org.bonitasoft.engine.transaction.TransactionService;
import org.bonitasoft.engine.work.WorkRegisterException;
import org.bonitasoft.engine.work.WorkService;

public class FlowNodeExecutorImpl
implements FlowNodeExecutor {
    private final FlowNodeStateManager flowNodeStateManager;
    private final ActivityInstanceService activityInstanceService;
    private final OperationService operationService;
    private final ArchiveService archiveService;
    private final DataInstanceService dataInstanceService;
    private final BPMInstanceBuilders bpmInstanceBuilders;
    private final ContainerRegistry containerRegistry;
    private final ProcessDefinitionService processDefinitionService;
    private final SCommentService commentService;
    private final ProcessInstanceService processInstanceService;
    private final ConnectorInstanceService connectorInstanceService;
    private final ClassLoaderService classLoaderService;
    private final WorkService workService;

    public FlowNodeExecutorImpl(FlowNodeStateManager flowNodeStateManager, ActivityInstanceService activityInstanceManager, OperationService operationService, ArchiveService archiveService, DataInstanceService dataInstanceService, BPMInstanceBuilders bpmInstanceBuilders, TechnicalLoggerService logger, ContainerRegistry containerRegistry, ProcessDefinitionService processDefinitionService, SCommentService commentService, ProcessInstanceService processInstanceService, ConnectorInstanceService connectorInstanceService, ClassLoaderService classLoaderService, WorkService workService, TransactionService transactionService) {
        this.flowNodeStateManager = flowNodeStateManager;
        this.activityInstanceService = activityInstanceManager;
        this.operationService = operationService;
        this.archiveService = archiveService;
        this.dataInstanceService = dataInstanceService;
        this.bpmInstanceBuilders = bpmInstanceBuilders;
        this.containerRegistry = containerRegistry;
        this.processInstanceService = processInstanceService;
        this.connectorInstanceService = connectorInstanceService;
        this.classLoaderService = classLoaderService;
        this.workService = workService;
        containerRegistry.addContainerExecutor(this);
        this.processDefinitionService = processDefinitionService;
        this.commentService = commentService;
    }

    @Override
    public StateCode executeState(SProcessDefinition processDefinition, SFlowNodeInstance flowNodeInstance, FlowNodeState state) throws SActivityStateExecutionException, SActivityExecutionException {
        StateCode stateCode = StateCode.DONE;
        if (state.getStateCategory().equals((Object)flowNodeInstance.getStateCategory())) {
            stateCode = state.execute(processDefinition, flowNodeInstance);
            try {
                if (this.commentService.isCommentEnabled(SystemCommentType.STATE_CHANGE) && state.mustAddSystemComment(flowNodeInstance)) {
                    this.commentService.addSystemComment(flowNodeInstance.getRootContainerId(), state.getSystemComment(flowNodeInstance));
                }
            }
            catch (SBonitaException e) {
                throw new SActivityExecutionException(e);
            }
        }
        return stateCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FlowNodeState stepForward(long flowNodeInstanceId, SExpressionContext expressionContext, List<SOperation> operations, long processInstanceId, Long executerId, Long executerDelegateId) throws SFlowNodeExecutionException {
        FlowNodeState state;
        block19: {
            state = null;
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                SFlowNodeInstance sFlowNodeInstance = null;
                long processDefinitionId = 0L;
                try {
                    SProcessDefinition processDefinition;
                    StateCode stateCode;
                    sFlowNodeInstance = this.activityInstanceService.getFlowNodeInstance(flowNodeInstanceId);
                    processDefinitionId = sFlowNodeInstance.getLogicalGroup(this.bpmInstanceBuilders.getSUserTaskInstanceBuilder().getProcessDefinitionIndex());
                    ClassLoader localClassLoader = this.classLoaderService.getLocalClassLoader("process", processDefinitionId);
                    Thread.currentThread().setContextClassLoader(localClassLoader);
                    if (!sFlowNodeInstance.isStateExecuting()) {
                        this.archiveFlowNodeInstance(sFlowNodeInstance, false, processDefinitionId);
                        if (executerId != null && executerId > 0L && sFlowNodeInstance.getExecutedBy() != executerId.longValue()) {
                            this.activityInstanceService.setExecutedBy(sFlowNodeInstance, executerId);
                        }
                        if (executerDelegateId != null && executerDelegateId > 0L && sFlowNodeInstance.getExecutedByDelegate() != executerDelegateId.longValue()) {
                            this.activityInstanceService.setExecutedByDelegate(sFlowNodeInstance, executerDelegateId);
                        }
                        if (operations != null) {
                            for (SOperation operation : operations) {
                                this.operationService.execute(operation, sFlowNodeInstance.getId(), DataInstanceContainer.ACTIVITY_INSTANCE.name(), expressionContext);
                            }
                        }
                    }
                    if (StateCode.DONE.equals((Object)(stateCode = this.executeState(processDefinition = this.processDefinitionService.getProcessDefinition(processDefinitionId), sFlowNodeInstance, this.flowNodeStateManager.getState(sFlowNodeInstance.getStateId()))))) {
                        state = this.flowNodeStateManager.getNextNormalState(processDefinition, sFlowNodeInstance, sFlowNodeInstance.getStateId());
                        if (sFlowNodeInstance.getStateId() != state.getId()) {
                            this.activityInstanceService.setState(sFlowNodeInstance, state);
                        }
                    } else if (StateCode.EXECUTING.equals((Object)stateCode)) {
                        this.activityInstanceService.setExecuting(sFlowNodeInstance);
                    }
                }
                catch (SBonitaException e) {
                    throw new SFlowNodeExecutionException(e);
                }
                if (sFlowNodeInstance.isStateExecuting()) break block19;
                if (state.isTerminal()) {
                    try {
                        this.workService.registerWork(WorkFactory.createNotifyChildFinishedWork(processDefinitionId, sFlowNodeInstance.getParentProcessInstanceId(), sFlowNodeInstance.getId(), sFlowNodeInstance.getParentContainerId(), sFlowNodeInstance.getParentContainerType().name(), state.getId()));
                        break block19;
                    }
                    catch (WorkRegisterException e) {
                        throw new SFlowNodeExecutionException(e);
                    }
                }
                if (state.isStable() || state.isInterrupting()) break block19;
                try {
                    this.workService.registerWork(WorkFactory.createExecuteFlowNodeWork(flowNodeInstanceId, null, null, processInstanceId));
                }
                catch (WorkRegisterException e) {
                    throw new SFlowNodeExecutionException(e);
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(contextClassLoader);
            }
        }
        return state;
    }

    protected <T extends SLogBuilder> void initializeLogBuilder(T logBuilder, String message) {
        logBuilder.createNewInstance().actionStatus(0).severity(SQueriableLogSeverity.INTERNAL).rawMessage(message);
    }

    protected <T extends HasCRUDEAction> void updateLog(HasCRUDEAction.ActionType actionType, T logBuilder) {
        logBuilder.setActionType(actionType);
    }

    protected SFlowNodeInstanceLogBuilder getQueriableLog(HasCRUDEAction.ActionType actionType, String message) {
        SFlowNodeInstanceLogBuilder logBuilder = this.bpmInstanceBuilders.getActivityInstanceLogBuilder();
        this.initializeLogBuilder(logBuilder, message);
        this.updateLog(actionType, logBuilder);
        return logBuilder;
    }

    @Override
    public void setStateByStateId(long sProcessDefinitionId, long flowNodeInstanceId, int stateId) throws SActivityStateExecutionException {
        block4: {
            FlowNodeState state = this.flowNodeStateManager.getState(stateId);
            try {
                SFlowNodeInstance sFlowNodeInstance = this.activityInstanceService.getFlowNodeInstance(flowNodeInstanceId);
                this.archiveFlowNodeInstance(sFlowNodeInstance, false, sProcessDefinitionId);
                this.activityInstanceService.setState(sFlowNodeInstance, state);
                if (!state.isTerminal()) break block4;
                try {
                    this.workService.registerWork(WorkFactory.createNotifyChildFinishedWork(sProcessDefinitionId, sFlowNodeInstance.getParentProcessInstanceId(), sFlowNodeInstance.getId(), sFlowNodeInstance.getParentContainerId(), sFlowNodeInstance.getParentContainerType().name(), stateId));
                }
                catch (WorkRegisterException e) {
                    throw new SFlowNodeExecutionException(e);
                }
            }
            catch (SBonitaException e) {
                throw new SActivityStateExecutionException(e);
            }
        }
    }

    @Override
    public void childFinished(long processDefinitionId, long flowNodeInstanceId, int stateId, long parentId) throws SBonitaException {
        SFlowNodeInstance sFlowNodeInstanceChild = this.activityInstanceService.getFlowNodeInstance(flowNodeInstanceId);
        SProcessDefinition sProcessDefinition = this.processDefinitionService.getProcessDefinition(processDefinitionId);
        boolean hit = false;
        SFlowNodeInstance sFlowNodeInstanceParent = this.activityInstanceService.getFlowNodeInstance(parentId);
        this.archiveFlowNodeInstance(sFlowNodeInstanceChild, true, processDefinitionId);
        SActivityInstance activityInstance = (SActivityInstance)sFlowNodeInstanceParent;
        int tokenCount = activityInstance.getTokenCount() - 1;
        this.activityInstanceService.setTokenCount(activityInstance, tokenCount);
        hit = this.flowNodeStateManager.getState(sFlowNodeInstanceParent.getStateId()).hit(sProcessDefinition, sFlowNodeInstanceParent, sFlowNodeInstanceChild);
        if (hit) {
            this.stepForward(parentId, null, null, sFlowNodeInstanceChild.getParentProcessInstanceId(), null, null);
        }
    }

    @Override
    public void childReachedState(SProcessInstance childProcInst, ProcessInstanceState childState, boolean hasActionsToExecute) throws SBonitaException {
        long callerId = childProcInst.getCallerId();
        if (this.isTerminalState(childState) && callerId > 0L) {
            SActivityInstance activityInstance = this.activityInstanceService.getActivityInstance(childProcInst.getCallerId());
            int tokenCount = activityInstance.getTokenCount() - 1;
            this.activityInstanceService.setTokenCount(activityInstance, tokenCount);
            if (!hasActionsToExecute) {
                this.containerRegistry.executeFlowNode(activityInstance.getId(), null, null, SFlowElementsContainerType.FLOWNODE.name(), activityInstance.getLogicalGroup(this.bpmInstanceBuilders.getSAAutomaticTaskInstanceBuilder().getParentProcessInstanceIndex()));
            }
        }
    }

    private boolean isTerminalState(ProcessInstanceState childState) {
        return ProcessInstanceState.COMPLETED.equals((Object)childState) || ProcessInstanceState.CANCELLED.equals((Object)childState) || ProcessInstanceState.ABORTED.equals((Object)childState);
    }

    @Override
    public String getHandledType() {
        return SFlowElementsContainerType.FLOWNODE.name();
    }

    @Override
    public FlowNodeState executeFlowNode(long flowNodeInstanceId, SExpressionContext contextDependency, List<SOperation> operations, long processInstanceId, Long executerId, Long executerDelegateId) throws SFlowNodeExecutionException {
        return this.stepForward(flowNodeInstanceId, contextDependency, operations, processInstanceId, executerId, executerDelegateId);
    }

    @Override
    public void archiveFlowNodeInstance(SFlowNodeInstance flowNodeInstance, boolean deleteAfterArchive, long processDefinitionId) throws SActivityExecutionException {
        ProcessArchiver.archiveFlowNodeInstance(flowNodeInstance, deleteAfterArchive, processDefinitionId, this.processInstanceService, this.processDefinitionService, this.archiveService, this.bpmInstanceBuilders, this.dataInstanceService, this.activityInstanceService, this.connectorInstanceService);
    }
}

