/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.execution;

import java.util.List;
import org.bonitasoft.engine.api.impl.transaction.flownode.SearchFlowNodeInstances;
import org.bonitasoft.engine.api.impl.transaction.flownode.SetFlowNodeStateCategory;
import org.bonitasoft.engine.api.impl.transaction.process.SetProcessStateCategory;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.core.process.instance.api.FlowNodeInstanceService;
import org.bonitasoft.engine.core.process.instance.api.ProcessInstanceService;
import org.bonitasoft.engine.core.process.instance.model.SFlowNodeInstance;
import org.bonitasoft.engine.core.process.instance.model.SStateCategory;
import org.bonitasoft.engine.core.process.instance.model.builder.BPMInstanceBuilders;
import org.bonitasoft.engine.execution.AbstractProcessInstanceInterruptor;
import org.bonitasoft.engine.execution.ProcessExecutor;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;

public class TransactionalProcessInstanceInterruptor
extends AbstractProcessInstanceInterruptor {
    private final ProcessInstanceService processInstanceService;
    private final FlowNodeInstanceService flowNodeInstanceService;
    private final ProcessExecutor processExecutor;
    private long count;

    public TransactionalProcessInstanceInterruptor(BPMInstanceBuilders bpmInstanceBuilders, ProcessInstanceService processInstanceService, FlowNodeInstanceService flowNodeInstanceService, ProcessExecutor processExecutor, TechnicalLoggerService logger) {
        super(bpmInstanceBuilders, logger);
        this.processInstanceService = processInstanceService;
        this.flowNodeInstanceService = flowNodeInstanceService;
        this.processExecutor = processExecutor;
    }

    @Override
    protected void setProcessStateCategory(long processInstanceId, SStateCategory stateCategory) throws SBonitaException {
        SetProcessStateCategory setProcessStateCategoryTransaction = new SetProcessStateCategory(this.processInstanceService, processInstanceId, stateCategory);
        setProcessStateCategoryTransaction.execute();
    }

    @Override
    protected void resumeStableChildExecution(long flowNodeInstanceId, long processInstanceId, long userId) throws SBonitaException {
        this.processExecutor.executeFlowNode(flowNodeInstanceId, null, null, processInstanceId, userId, userId);
    }

    @Override
    protected List<SFlowNodeInstance> getChildren(long processInstanceId) throws SBonitaException {
        SearchFlowNodeInstances searchFlowNodeInstancesTransaction = new SearchFlowNodeInstances(this.flowNodeInstanceService, this.getQueryOptions(processInstanceId), SFlowNodeInstance.class);
        searchFlowNodeInstancesTransaction.execute();
        Object children = searchFlowNodeInstancesTransaction.getResult();
        this.count = searchFlowNodeInstancesTransaction.getCount();
        return children;
    }

    @Override
    protected List<SFlowNodeInstance> getChildrenExcept(long processInstanceId, long childExceptionId) throws SBonitaException {
        SearchFlowNodeInstances searchFlowNodeInstancesTransaction = new SearchFlowNodeInstances(this.flowNodeInstanceService, this.getQueryOptions(processInstanceId, childExceptionId), SFlowNodeInstance.class);
        searchFlowNodeInstancesTransaction.execute();
        Object children = searchFlowNodeInstancesTransaction.getResult();
        this.count = searchFlowNodeInstancesTransaction.getCount();
        return children;
    }

    @Override
    protected long getNumberOfChildren(long processInstanceId) {
        return this.count;
    }

    @Override
    protected long getNumberOfChildrenExcept(long processInstanceId, long childExceptionId) {
        return this.count;
    }

    @Override
    protected void setChildStateCategory(long flowNodeInstanceId, SStateCategory stateCategory) throws SBonitaException {
        SetFlowNodeStateCategory setFlowNodeStateCategoryTransaction = new SetFlowNodeStateCategory(this.flowNodeInstanceService, flowNodeInstanceId, stateCategory);
        setFlowNodeStateCategoryTransaction.execute();
    }
}

