/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.execution.event;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.core.process.definition.model.SProcessDefinition;
import org.bonitasoft.engine.core.process.definition.model.event.SEventDefinition;
import org.bonitasoft.engine.core.process.definition.model.event.trigger.SEventTriggerDefinition;
import org.bonitasoft.engine.core.process.instance.api.event.EventInstanceService;
import org.bonitasoft.engine.core.process.instance.api.exceptions.event.trigger.SWaitingEventModificationException;
import org.bonitasoft.engine.core.process.instance.model.SProcessInstance;
import org.bonitasoft.engine.core.process.instance.model.builder.BPMInstanceBuilders;
import org.bonitasoft.engine.core.process.instance.model.builder.event.handling.SWaitingEventKeyProvider;
import org.bonitasoft.engine.core.process.instance.model.builder.event.handling.SWaitingMessageEventBuilder;
import org.bonitasoft.engine.core.process.instance.model.event.handling.SWaitingEvent;
import org.bonitasoft.engine.execution.event.EventHandlerStrategy;
import org.bonitasoft.engine.persistence.FilterOption;
import org.bonitasoft.engine.persistence.OrderByOption;
import org.bonitasoft.engine.persistence.OrderByType;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.persistence.SBonitaSearchException;

public abstract class CoupleEventHandlerStrategy
extends EventHandlerStrategy {
    private final BPMInstanceBuilders instanceBuilders;
    private final EventInstanceService eventInstanceService;
    private static final int MAX_NUMBER_OF_RESULTS = 100;

    public CoupleEventHandlerStrategy(BPMInstanceBuilders instanceBuilders, EventInstanceService eventInstanceService) {
        this.instanceBuilders = instanceBuilders;
        this.eventInstanceService = eventInstanceService;
    }

    @Override
    public void unregisterCatchEvent(SProcessDefinition processDefinition, SEventDefinition eventDefinition, SEventTriggerDefinition sEventTriggerDefinition, long subProcessId, SProcessInstance parentProcessIsnstance) throws SBonitaException {
        if (!eventDefinition.getEventTriggers().isEmpty()) {
            SWaitingMessageEventBuilder waitingEventKeyProvider = this.instanceBuilders.getSWaitingMessageEventBuilder();
            this.unregisterWaitingEvents(SWaitingEvent.class, waitingEventKeyProvider, subProcessId, parentProcessIsnstance);
        }
    }

    private QueryOptions getWaitingEventsCountOptions(SWaitingEventKeyProvider waitingEventKeyProvider, Class<? extends SWaitingEvent> waitingEventClass, long subProcessId, SProcessInstance parentProcessInstance) {
        List<FilterOption> filters = this.getFilterForWaitingEventsToUnregister(waitingEventKeyProvider, waitingEventClass, subProcessId, parentProcessInstance);
        return new QueryOptions(filters, null);
    }

    private QueryOptions getWaitingEventsQueryOptions(SWaitingEventKeyProvider waitingEventKeyProvider, Class<? extends SWaitingEvent> waitingEventClass, long subProcessId, SProcessInstance parentProcessInstance) {
        OrderByOption orderByOption = new OrderByOption(waitingEventClass, waitingEventKeyProvider.getIdKey(), OrderByType.ASC);
        List<FilterOption> filters = this.getFilterForWaitingEventsToUnregister(waitingEventKeyProvider, waitingEventClass, subProcessId, parentProcessInstance);
        return new QueryOptions(0, 100, Collections.singletonList(orderByOption), filters, null);
    }

    private List<FilterOption> getFilterForWaitingEventsToUnregister(SWaitingEventKeyProvider waitingEventKeyProvider, Class<? extends SWaitingEvent> waitingEventClass, long subProcessId, SProcessInstance parentProcessInstance) {
        ArrayList<FilterOption> filters = new ArrayList<FilterOption>(3);
        filters.add(new FilterOption(waitingEventClass, waitingEventKeyProvider.getSubProcessIdKey(), subProcessId));
        filters.add(new FilterOption(waitingEventClass, waitingEventKeyProvider.getParentProcessInstanceIdKey(), parentProcessInstance.getId()));
        filters.add(new FilterOption(waitingEventClass, waitingEventKeyProvider.getActiveKey(), true));
        return filters;
    }

    private <T extends SWaitingEvent> void unregisterWaitingEvents(Class<T> waitingEventClass, SWaitingEventKeyProvider waitingEventKeyProvider, long subProcessId, SProcessInstance parentProcessInstance) throws SBonitaSearchException, SWaitingEventModificationException {
        List<T> waitingEvents;
        QueryOptions queryOptions = this.getWaitingEventsQueryOptions(waitingEventKeyProvider, waitingEventClass, subProcessId, parentProcessInstance);
        QueryOptions countOptions = this.getWaitingEventsCountOptions(waitingEventKeyProvider, waitingEventClass, subProcessId, parentProcessInstance);
        long count = 0L;
        do {
            waitingEvents = this.eventInstanceService.searchWaitingEvents(waitingEventClass, queryOptions);
            count = this.eventInstanceService.getNumberOfWaitingEvents(waitingEventClass, countOptions);
            this.deleteWaitingEvents(waitingEvents);
        } while (count > (long)waitingEvents.size());
    }

    private void deleteWaitingEvents(List<? extends SWaitingEvent> waitingEvents) throws SWaitingEventModificationException {
        for (SWaitingEvent sWaitingEvent : waitingEvents) {
            this.eventInstanceService.deleteWaitingEvent(sWaitingEvent);
        }
    }

    protected EventInstanceService getEventInstanceService() {
        return this.eventInstanceService;
    }

    protected BPMInstanceBuilders getInstanceBuilders() {
        return this.instanceBuilders;
    }
}

