/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.execution.event;

import java.util.List;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.core.process.definition.model.SProcessDefinition;
import org.bonitasoft.engine.core.process.definition.model.event.SEndEventDefinition;
import org.bonitasoft.engine.core.process.definition.model.event.SEventDefinition;
import org.bonitasoft.engine.core.process.definition.model.event.trigger.SEventTriggerDefinition;
import org.bonitasoft.engine.core.process.definition.model.event.trigger.SSignalEventTriggerDefinition;
import org.bonitasoft.engine.core.process.instance.api.event.EventInstanceService;
import org.bonitasoft.engine.core.process.instance.api.exceptions.event.trigger.SWaitingEventCreationException;
import org.bonitasoft.engine.core.process.instance.model.SFlowNodeInstance;
import org.bonitasoft.engine.core.process.instance.model.SProcessInstance;
import org.bonitasoft.engine.core.process.instance.model.builder.BPMInstanceBuilders;
import org.bonitasoft.engine.core.process.instance.model.builder.event.handling.SWaitingSignalEventBuilder;
import org.bonitasoft.engine.core.process.instance.model.event.SCatchEventInstance;
import org.bonitasoft.engine.core.process.instance.model.event.SThrowEventInstance;
import org.bonitasoft.engine.core.process.instance.model.event.handling.SWaitingEvent;
import org.bonitasoft.engine.core.process.instance.model.event.handling.SWaitingSignalEvent;
import org.bonitasoft.engine.core.process.instance.model.event.trigger.SThrowSignalEventTriggerInstance;
import org.bonitasoft.engine.execution.event.CoupleEventHandlerStrategy;
import org.bonitasoft.engine.execution.event.EventsHandler;
import org.bonitasoft.engine.execution.event.OperationsWithContext;

public class SignalEventHandlerStrategy
extends CoupleEventHandlerStrategy {
    private static final OperationsWithContext EMPTY = new OperationsWithContext(null, null);
    private final EventsHandler eventsHandler;

    public SignalEventHandlerStrategy(EventsHandler eventsHandler, BPMInstanceBuilders instanceBuilders, EventInstanceService eventInstanceService) {
        super(instanceBuilders, eventInstanceService);
        this.eventsHandler = eventsHandler;
    }

    @Override
    public void handleCatchEvent(SProcessDefinition processDefinition, SEventDefinition eventDefinition, SCatchEventInstance eventInstance, SEventTriggerDefinition sEventTriggerDefinition) throws SBonitaException {
        SWaitingSignalEventBuilder builder = this.getInstanceBuilders().getSWaitingSignalEventBuilder();
        SSignalEventTriggerDefinition sSignalEventTriggerDefinition = (SSignalEventTriggerDefinition)sEventTriggerDefinition;
        switch (eventDefinition.getType()) {
            case BOUNDARY_EVENT: {
                builder.createNewWaitingSignalBoundaryEventInstance(processDefinition.getId(), eventInstance.getRootProcessInstanceId(), eventInstance.getParentContainerId(), eventInstance.getId(), sSignalEventTriggerDefinition.getSignalName(), processDefinition.getName(), eventDefinition.getId(), eventInstance.getName());
                break;
            }
            case INTERMEDIATE_CATCH_EVENT: {
                builder.createNewWaitingSignalIntermediateEventInstance(processDefinition.getId(), eventInstance.getRootProcessInstanceId(), eventInstance.getParentContainerId(), eventInstance.getId(), sSignalEventTriggerDefinition.getSignalName(), processDefinition.getName(), eventDefinition.getId(), eventInstance.getName());
                break;
            }
            case START_EVENT: {
                builder.createNewWaitingSignalStartEventInstance(processDefinition.getId(), sSignalEventTriggerDefinition.getSignalName(), processDefinition.getName(), eventDefinition.getId(), eventDefinition.getName());
                break;
            }
            default: {
                throw new SWaitingEventCreationException((Object)((Object)eventDefinition.getType()) + " is not a catch event.");
            }
        }
        SWaitingSignalEvent signalEvent = builder.done();
        this.getEventInstanceService().createWaitingEvent(signalEvent);
    }

    @Override
    public void handleThrowEvent(SProcessDefinition processDefinition, SEventDefinition eventDefinition, SThrowEventInstance eventInstance, SEventTriggerDefinition sEventTriggerDefinition) throws SBonitaException {
        long eventInstanceId = eventInstance.getId();
        this.handleThrowSignal(sEventTriggerDefinition, eventInstanceId);
    }

    private void handleThrowSignal(SEventTriggerDefinition sEventTriggerDefinition, long eventInstanceId) throws SBonitaException {
        SSignalEventTriggerDefinition signalTrigger = (SSignalEventTriggerDefinition)sEventTriggerDefinition;
        SThrowSignalEventTriggerInstance signalEventTriggerInstance = this.getInstanceBuilders().getSThrowSignalEventTriggerInstanceBuilder().createNewInstance(eventInstanceId, signalTrigger.getSignalName()).done();
        this.getEventInstanceService().createEventTriggerInstance(signalEventTriggerInstance);
        List<SWaitingSignalEvent> listeningSignals = this.getEventInstanceService().getWaitingSignalEvents(signalTrigger.getSignalName());
        for (SWaitingSignalEvent listeningSignal : listeningSignals) {
            this.eventsHandler.triggerCatchEvent(listeningSignal, null);
        }
    }

    @Override
    public OperationsWithContext getOperations(SWaitingEvent waitingEvent, Long triggeringElementID) {
        return EMPTY;
    }

    @Override
    public void handleThrowEvent(SEventTriggerDefinition sEventTriggerDefinition) throws SBonitaException {
        this.handleThrowSignal(sEventTriggerDefinition, -1L);
    }

    @Override
    public void handleEventSubProcess(SProcessDefinition processDefinition, SEventDefinition eventDefinition, SEventTriggerDefinition sEventTriggerDefinition, long subProcessId, SProcessInstance parentProcessInstance) throws SBonitaException {
        SWaitingSignalEventBuilder builder = this.getInstanceBuilders().getSWaitingSignalEventBuilder();
        SSignalEventTriggerDefinition sSignalEventTriggerDefinition = (SSignalEventTriggerDefinition)sEventTriggerDefinition;
        builder.createNewWaitingSignalEventSubProcInstance(processDefinition.getId(), parentProcessInstance.getId(), parentProcessInstance.getRootProcessInstanceId(), sSignalEventTriggerDefinition.getSignalName(), processDefinition.getName(), eventDefinition.getId(), eventDefinition.getName(), subProcessId);
        SWaitingSignalEvent signalEvent = builder.done();
        this.getEventInstanceService().createWaitingEvent(signalEvent);
    }

    @Override
    public boolean handlePostThrowEvent(SProcessDefinition processDefinition, SEndEventDefinition sEventDefinition, SThrowEventInstance sThrowEventInstance, SEventTriggerDefinition sEventTriggerDefinition, SFlowNodeInstance sFlowNodeInstance) {
        return false;
    }
}

