/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.execution.state;

import org.bonitasoft.engine.bpm.bar.xml.XMLProcessDefinition;
import org.bonitasoft.engine.core.process.definition.model.SConnectorDefinition;
import org.bonitasoft.engine.core.process.definition.model.SProcessDefinition;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SActivityStateExecutionException;
import org.bonitasoft.engine.core.process.instance.api.states.FlowNodeState;
import org.bonitasoft.engine.core.process.instance.api.states.StateCode;
import org.bonitasoft.engine.core.process.instance.model.SConnectorInstance;
import org.bonitasoft.engine.core.process.instance.model.SFlowNodeInstance;
import org.bonitasoft.engine.execution.StateBehaviors;

public abstract class FlowNodeStateWithConnectors
implements FlowNodeState {
    private final StateBehaviors stateBehaviors;
    private final boolean executeOnEnter;
    private final boolean executeOnFinish;

    public FlowNodeStateWithConnectors(StateBehaviors stateBehaviors, boolean executeOnEnter, boolean executeOnFinish) {
        this.stateBehaviors = stateBehaviors;
        this.executeOnEnter = executeOnEnter;
        this.executeOnFinish = executeOnFinish;
    }

    protected abstract void beforeOnEnter(SProcessDefinition var1, SFlowNodeInstance var2) throws SActivityStateExecutionException;

    protected abstract void onEnterToOnFinish(SProcessDefinition var1, SFlowNodeInstance var2) throws SActivityStateExecutionException;

    protected abstract void afterOnFinish(SProcessDefinition var1, SFlowNodeInstance var2) throws SActivityStateExecutionException;

    @Override
    public StateCode execute(SProcessDefinition processDefinition, SFlowNodeInstance flowNodeInstance) throws SActivityStateExecutionException {
        XMLProcessDefinition.BEntry<Integer, XMLProcessDefinition.BEntry<SConnectorInstance, SConnectorDefinition>> entry = this.stateBehaviors.getConnectorToExecuteAndFlag(processDefinition, flowNodeInstance);
        Integer phase = (Integer)entry.getKey();
        if ((phase & 1) != 0) {
            this.beforeOnEnter(processDefinition, flowNodeInstance);
        }
        if ((phase & 2) != 0 && this.executeOnEnter) {
            this.stateBehaviors.executeConnectorInWork(processDefinition.getId(), flowNodeInstance.getFlowNodeDefinitionId(), flowNodeInstance.getId(), (SConnectorInstance)((XMLProcessDefinition.BEntry)entry.getValue()).getKey(), (SConnectorDefinition)((XMLProcessDefinition.BEntry)entry.getValue()).getValue());
            return StateCode.EXECUTING;
        }
        if ((phase & 4) != 0) {
            this.onEnterToOnFinish(processDefinition, flowNodeInstance);
        }
        if ((phase & 8) != 0 && this.executeOnFinish) {
            this.stateBehaviors.executeConnectorInWork(processDefinition.getId(), flowNodeInstance.getFlowNodeDefinitionId(), flowNodeInstance.getId(), (SConnectorInstance)((XMLProcessDefinition.BEntry)entry.getValue()).getKey(), (SConnectorDefinition)((XMLProcessDefinition.BEntry)entry.getValue()).getValue());
            return StateCode.EXECUTING;
        }
        if ((phase & 0x10) != 0) {
            this.afterOnFinish(processDefinition, flowNodeInstance);
        }
        return StateCode.DONE;
    }
}

