/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.execution.work;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.bonitasoft.engine.core.process.instance.model.SFlowElementsContainerType;
import org.bonitasoft.engine.execution.work.TxBonitaWork;
import org.bonitasoft.engine.execution.work.WrappingBonitaWork;
import org.bonitasoft.engine.lock.BonitaLock;
import org.bonitasoft.engine.lock.LockService;
import org.bonitasoft.engine.lock.SLockException;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.work.BonitaWork;
import org.bonitasoft.engine.work.WorkRegisterException;
import org.bonitasoft.engine.work.WorkService;

public class LockProcessInstanceWork
extends WrappingBonitaWork {
    private static final long serialVersionUID = -4604852239659029393L;
    protected final long processInstanceId;
    private final long timeout = 20L;
    private final TimeUnit timeUnit = TimeUnit.MILLISECONDS;

    public LockProcessInstanceWork(BonitaWork wrappedWork, long processInstanceId) {
        super(wrappedWork);
        this.processInstanceId = processInstanceId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void work(Map<String, Object> context) throws Exception {
        BonitaLock lock;
        LockService lockService;
        TechnicalLoggerService loggerService;
        block6: {
            loggerService = this.getTenantAccessor(context).getTechnicalLoggerService();
            lockService = this.getTenantAccessor(context).getLockService();
            String objectType = SFlowElementsContainerType.PROCESS.name();
            lock = null;
            try {
                if (loggerService.isLoggable(this.getClass(), TechnicalLogSeverity.DEBUG)) {
                    loggerService.log(this.getClass(), TechnicalLogSeverity.DEBUG, Thread.currentThread().getName() + " trying to get lock for instance " + this.processInstanceId + ": " + this.getWorkStack());
                }
                if ((lock = lockService.tryLock(this.processInstanceId, objectType, 20L, this.timeUnit, this.getTenantId())) != null) break block6;
                if (loggerService.isLoggable(this.getClass(), TechnicalLogSeverity.DEBUG)) {
                    loggerService.log(this.getClass(), TechnicalLogSeverity.DEBUG, Thread.currentThread().getName() + " did not get lock for instance " + this.processInstanceId + ": " + this.getWorkStack());
                }
                this.rescheduleWork(this.getTenantAccessor(context).getWorkService(), this.getRootWork());
                if (lock == null) return;
            }
            catch (Throwable throwable) {
                if (lock == null) throw throwable;
                lockService.unlock(lock, this.getTenantId());
                if (!loggerService.isLoggable(this.getClass(), TechnicalLogSeverity.DEBUG)) throw throwable;
                loggerService.log(this.getClass(), TechnicalLogSeverity.DEBUG, Thread.currentThread().getName() + " has unlocked lock for instance " + this.processInstanceId + ": " + this.getWorkStack());
                throw throwable;
            }
            lockService.unlock(lock, this.getTenantId());
            if (!loggerService.isLoggable(this.getClass(), TechnicalLogSeverity.DEBUG)) return;
            loggerService.log(this.getClass(), TechnicalLogSeverity.DEBUG, Thread.currentThread().getName() + " has unlocked lock for instance " + this.processInstanceId + ": " + this.getWorkStack());
            return;
        }
        if (loggerService.isLoggable(this.getClass(), TechnicalLogSeverity.DEBUG)) {
            loggerService.log(this.getClass(), TechnicalLogSeverity.DEBUG, Thread.currentThread().getName() + " obtained lock for instance " + this.processInstanceId + ": " + this.getWorkStack());
        }
        this.getWrappedWork().work(context);
        if (lock == null) return;
        lockService.unlock(lock, this.getTenantId());
        if (!loggerService.isLoggable(this.getClass(), TechnicalLogSeverity.DEBUG)) return;
        loggerService.log(this.getClass(), TechnicalLogSeverity.DEBUG, Thread.currentThread().getName() + " has unlocked lock for instance " + this.processInstanceId + ": " + this.getWorkStack());
    }

    private String getWorkStack() {
        if (this.getWrappedWork() instanceof TxBonitaWork) {
            TxBonitaWork txBonitaWork = (TxBonitaWork)this.getWrappedWork();
            BonitaWork doingWork = txBonitaWork.getWrappedWork();
            return doingWork.getDescription();
        }
        return "nothing";
    }

    private void rescheduleWork(WorkService workService, BonitaWork rootWork) throws SLockException {
        try {
            workService.executeWork(rootWork);
        }
        catch (WorkRegisterException e) {
            throw new SLockException(e);
        }
    }

    BonitaWork getRootWork() {
        BonitaWork root = this;
        while (root.getParent() != null) {
            root = root.getParent();
        }
        return root;
    }
}

