/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.expression.impl;

import groovy.lang.Binding;
import groovy.lang.GroovyRuntimeException;
import groovy.lang.GroovyShell;
import groovy.lang.MissingPropertyException;
import groovy.lang.Script;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.expression.NonEmptyContentExpressionExecutorStrategy;
import org.bonitasoft.engine.expression.exception.SExpressionEvaluationException;
import org.bonitasoft.engine.expression.model.ExpressionKind;
import org.bonitasoft.engine.expression.model.SExpression;

public class GroovyScriptExpressionExecutorStrategy
extends NonEmptyContentExpressionExecutorStrategy {
    @Override
    public Object evaluate(SExpression expression, Map<String, Object> dependencyValues, Map<Integer, Object> resolvedExpressions) throws SExpressionEvaluationException {
        String expressionContent = expression.getContent();
        ClassLoader scriptClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            GroovyShell shell = new GroovyShell(scriptClassLoader);
            Script script = shell.parse(expressionContent);
            Binding binding = new Binding(dependencyValues);
            script.setBinding(binding);
            return script.evaluate(expressionContent);
        }
        catch (MissingPropertyException e) {
            String property = e.getProperty();
            StringBuilder builder = new StringBuilder("Expression ");
            builder.append(expression.getName()).append(" with content: ").append(expressionContent).append(" depends on ").append(property).append(" is neither defined in the script nor in dependencies");
            throw new SExpressionEvaluationException(builder.toString(), e);
        }
        catch (GroovyRuntimeException e) {
            throw new SExpressionEvaluationException(e);
        }
        catch (Throwable e) {
            throw new SExpressionEvaluationException("Script throws an exception" + expression, e);
        }
    }

    @Override
    public ExpressionKind getExpressionKind() {
        return KIND_READ_ONLY_SCRIPT_GROOVY;
    }

    @Override
    public List<Object> evaluate(List<SExpression> expressions, Map<String, Object> dependencyValues, Map<Integer, Object> resolvedExpressions) throws SExpressionEvaluationException {
        ArrayList<Object> list = new ArrayList<Object>(expressions.size());
        for (SExpression expression : expressions) {
            list.add(this.evaluate(expression, dependencyValues, resolvedExpressions));
        }
        return list;
    }

    @Override
    public boolean mustPutEvaluatedExpressionInContext() {
        return false;
    }
}

