/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.external.identitymapping;

import java.util.List;
import org.bonitasoft.engine.command.SCommandExecutionException;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.entitymember.EntityMember;
import org.bonitasoft.engine.external.identity.mapping.model.SExternalIdentityMapping;
import org.bonitasoft.engine.external.identitymapping.ExternalIdentityMappingCommand;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.persistence.SBonitaSearchException;
import org.bonitasoft.engine.search.SearchOptions;
import org.bonitasoft.engine.search.SearchResult;
import org.bonitasoft.engine.search.descriptor.SearchEntityDescriptor;
import org.bonitasoft.engine.search.descriptor.SearchEntityMemberDescriptor;

public abstract class EntityMemberCommand
extends ExternalIdentityMappingCommand {
    protected SearchResult<EntityMember> searchEntityMembersInvolvingUser(String kind, long userId, String externalId, SearchOptions searchOptions) throws SCommandExecutionException {
        EntityMemberSearchEntityForUser transactionContent = new EntityMemberSearchEntityForUser(this.serviceAccessor.getSearchEntitiesDescriptor().getEntityMemberUserDescriptor(), kind, userId, externalId, searchOptions);
        try {
            transactionContent.execute();
        }
        catch (SBonitaException e) {
            throw new SCommandExecutionException(e);
        }
        return transactionContent.getResult();
    }

    protected SearchResult<EntityMember> searchEntityMembers(SearchEntityMemberDescriptor searchDescriptor, String kind, SearchOptions searchOptions, String querySuffix) throws SCommandExecutionException {
        EntityMemberSearchEntity transactionContent = new EntityMemberSearchEntity(searchDescriptor, kind, searchOptions, querySuffix);
        try {
            transactionContent.execute();
        }
        catch (SBonitaException e) {
            throw new SCommandExecutionException(e);
        }
        return transactionContent.getResult();
    }

    class EntityMemberSearchEntity
    extends ExternalIdentityMappingCommand.ExternalIdentityMappingSearchEntity {
        private final String querySuffix;

        public EntityMemberSearchEntity(SearchEntityMemberDescriptor searchDescriptor, String kind, SearchOptions options, String querySuffix) {
            super(searchDescriptor, kind, options);
            this.querySuffix = querySuffix;
        }

        @Override
        public long executeCount(QueryOptions searchOptions) throws SBonitaSearchException {
            return EntityMemberCommand.this.serviceAccessor.getExternalIdentityMappingService().getNumberOfExternalIdentityMappings(this.kind, searchOptions, this.querySuffix);
        }

        @Override
        public List<SExternalIdentityMapping> executeSearch(QueryOptions searchOptions) throws SBonitaSearchException {
            return EntityMemberCommand.this.serviceAccessor.getExternalIdentityMappingService().searchExternalIdentityMappings(this.kind, searchOptions, this.querySuffix);
        }
    }

    class EntityMemberSearchEntityForUser
    extends ExternalIdentityMappingCommand.ExternalIdentityMappingSearchEntity {
        private final long userId;
        private final String externalId;

        public EntityMemberSearchEntityForUser(SearchEntityDescriptor searchDescriptor, String kind, long userId, String externalId, SearchOptions options) {
            super(searchDescriptor, kind, options);
            this.userId = userId;
            this.externalId = externalId;
        }

        @Override
        public long executeCount(QueryOptions searchOptions) throws SBonitaSearchException {
            return EntityMemberCommand.this.serviceAccessor.getExternalIdentityMappingService().getNumberOfExternalIdentityMappingsForUser(this.kind, this.userId, this.externalId, searchOptions, "Involving");
        }

        @Override
        public List<SExternalIdentityMapping> executeSearch(QueryOptions searchOptions) throws SBonitaSearchException {
            return EntityMemberCommand.this.serviceAccessor.getExternalIdentityMappingService().searchExternalIdentityMappingsForUser(this.kind, this.userId, this.externalId, searchOptions, "Involving");
        }
    }
}

