/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.external.identitymapping;

import java.util.ArrayList;
import java.util.List;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.commons.transaction.TransactionContent;
import org.bonitasoft.engine.commons.transaction.TransactionContentWithResult;
import org.bonitasoft.engine.entitymember.EntityMember;
import org.bonitasoft.engine.entitymember.impl.EntityMemberImpl;
import org.bonitasoft.engine.external.identity.mapping.SExternalIdentityMappingCreationException;
import org.bonitasoft.engine.external.identity.mapping.SExternalIdentityMappingDeletionException;
import org.bonitasoft.engine.external.identity.mapping.model.SExternalIdentityMapping;
import org.bonitasoft.engine.external.identity.mapping.model.SExternalIdentityMappingBuilder;
import org.bonitasoft.engine.external.identitymapping.MemberCommand;
import org.bonitasoft.engine.identity.MemberType;
import org.bonitasoft.engine.identity.SGroupNotFoundException;
import org.bonitasoft.engine.identity.SRoleNotFoundException;
import org.bonitasoft.engine.identity.SUserNotFoundException;
import org.bonitasoft.engine.identity.model.SGroup;
import org.bonitasoft.engine.identity.model.SRole;
import org.bonitasoft.engine.identity.model.SUser;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.search.AbstractSearchEntity;
import org.bonitasoft.engine.search.SearchOptions;
import org.bonitasoft.engine.search.descriptor.SearchEntityDescriptor;
import org.bonitasoft.engine.service.TenantServiceAccessor;

public abstract class ExternalIdentityMappingCommand
extends MemberCommand {
    protected static final String ENTITY_MEMBER_ID_KEY = "ENTITY_MEMBER_ID_KEY";
    protected static final String EXTERNAL_ID_KEY = "EXTERNAL_ID_KEY";
    protected static final String DISCRIMINATOR_ID_KEY = "DISCRIMINATOR_ID_KEY";
    protected static final String USER_ID_KEY = "USER_ID_KEY";
    protected static final String ROLE_ID_KEY = "ROLE_ID_KEY";
    protected static final String GROUP_ID_KEY = "GROUP_ID_KEY";
    protected static final String SEARCH_OPTIONS_KEY = "SEARCH_OPTIONS_KEY";
    protected TenantServiceAccessor serviceAccessor;

    public TenantServiceAccessor getServiceAccessor() {
        return this.serviceAccessor;
    }

    protected SExternalIdentityMapping addExternalIdentityMapping(String externalId, long userId, long roleId, long groupId, String kind, MemberType memberType) throws SBonitaException {
        SExternalIdentityMappingBuilder builder = this.serviceAccessor.getExternalIdentityMappingBuilders().getSExternalIdentityMappingBuilder().createNewInstance(externalId).setGroupId(groupId).setKind(kind).setRoleId(roleId).setUserId(userId);
        CreateExternalIdentityMapping transactionContent = new CreateExternalIdentityMapping(builder, memberType, userId, groupId, roleId);
        try {
            transactionContent.execute();
        }
        catch (SBonitaException e) {
            throw new SExternalIdentityMappingCreationException(e);
        }
        return transactionContent.getResult();
    }

    protected void removeExternalIdentityMapping(long sExtIdentityMappingId) throws SExternalIdentityMappingDeletionException {
        RemoveExternalIdentityMapping transactionContent = new RemoveExternalIdentityMapping(sExtIdentityMappingId);
        try {
            transactionContent.execute();
        }
        catch (SBonitaException e) {
            throw new SExternalIdentityMappingDeletionException(e);
        }
    }

    protected void deleteExternalIdentityMappings(String externalId, String kind) throws SExternalIdentityMappingDeletionException {
        DeleteExternalIdentityMappings transactionContent = new DeleteExternalIdentityMappings(kind, externalId);
        try {
            transactionContent.execute();
        }
        catch (SBonitaException e) {
            throw new SExternalIdentityMappingDeletionException(e);
        }
    }

    protected EntityMember toEntityMember(SExternalIdentityMapping eiMapping) {
        return new EntityMemberImpl(eiMapping.getId(), eiMapping.getExternalId(), eiMapping.getUserId(), eiMapping.getGroupId(), eiMapping.getRoleId(), eiMapping.getDisplayNamePart1(), eiMapping.getDisplayNamePart2(), eiMapping.getDisplayNamePart3());
    }

    private List<EntityMember> toEntityMembers(List<SExternalIdentityMapping> serverObjects) {
        ArrayList<EntityMember> list = new ArrayList<EntityMember>(serverObjects.size());
        for (SExternalIdentityMapping sMapping : serverObjects) {
            list.add(this.toEntityMember(sMapping));
        }
        return list;
    }

    private void setDisplayNames(SExternalIdentityMappingBuilder builder, MemberType memberType, long userId, long groupId, long roleId) throws SUserNotFoundException, SGroupNotFoundException, SRoleNotFoundException {
        switch (memberType) {
            case USER: {
                SUser user = this.serviceAccessor.getIdentityService().getUser(userId);
                builder.setUserId(userId);
                builder.setDisplayNamePart1(user.getFirstName());
                builder.setDisplayNamePart2(user.getLastName());
                builder.setDisplayNamePart3(user.getUserName());
                break;
            }
            case GROUP: {
                SGroup group = this.serviceAccessor.getIdentityService().getGroup(groupId);
                builder.setGroupId(groupId);
                builder.setDisplayNamePart1(group.getName());
                builder.setDisplayNamePart2(group.getParentPath());
                break;
            }
            case ROLE: {
                SRole role = this.serviceAccessor.getIdentityService().getRole(roleId);
                builder.setRoleId(roleId);
                builder.setDisplayNamePart1(role.getName());
                break;
            }
            case MEMBERSHIP: {
                SGroup group = this.serviceAccessor.getIdentityService().getGroup(groupId);
                SRole role = this.serviceAccessor.getIdentityService().getRole(roleId);
                builder.setGroupId(groupId);
                builder.setRoleId(roleId);
                builder.setDisplayNamePart1(role.getName());
                builder.setDisplayNamePart2(group.getName());
                builder.setDisplayNamePart3(group.getParentPath());
            }
        }
    }

    protected abstract class ExternalIdentityMappingSearchEntity
    extends AbstractSearchEntity<EntityMember, SExternalIdentityMapping> {
        protected final String kind;

        public ExternalIdentityMappingSearchEntity(SearchEntityDescriptor searchDescriptor, String kind, SearchOptions options) {
            super(searchDescriptor, options);
            this.kind = kind;
        }

        @Override
        public List<EntityMember> convertToClientObjects(List<SExternalIdentityMapping> serverObjects) {
            return ExternalIdentityMappingCommand.this.toEntityMembers(serverObjects);
        }
    }

    class DeleteExternalIdentityMappings
    implements TransactionContent {
        private final String kind;
        private final String externalId;

        DeleteExternalIdentityMappings(String kind, String externalId) {
            this.kind = kind;
            this.externalId = externalId;
        }

        @Override
        public void execute() throws SBonitaException {
            List<SExternalIdentityMapping> searchExternalIdentityMappings = ExternalIdentityMappingCommand.this.serviceAccessor.getExternalIdentityMappingService().searchExternalIdentityMappings(this.kind, this.externalId, new QueryOptions(0, Integer.MAX_VALUE));
            for (SExternalIdentityMapping mapping : searchExternalIdentityMappings) {
                ExternalIdentityMappingCommand.this.serviceAccessor.getExternalIdentityMappingService().deleteExternalIdentityMapping(mapping);
            }
        }
    }

    class RemoveExternalIdentityMapping
    implements TransactionContent {
        private final long mappingId;

        RemoveExternalIdentityMapping(long mappingId) {
            this.mappingId = mappingId;
        }

        @Override
        public void execute() throws SBonitaException {
            ExternalIdentityMappingCommand.this.serviceAccessor.getExternalIdentityMappingService().deleteExternalIdentityMapping(this.mappingId);
        }
    }

    class CreateExternalIdentityMapping
    implements TransactionContentWithResult<SExternalIdentityMapping> {
        private final SExternalIdentityMappingBuilder builder;
        private final MemberType memberType;
        private final long userId;
        private final long groupId;
        private final long roleId;
        SExternalIdentityMapping mapping;

        CreateExternalIdentityMapping(SExternalIdentityMappingBuilder builder, MemberType memberType, long userId, long groupId, long roleId) {
            this.builder = builder;
            this.memberType = memberType;
            this.userId = userId;
            this.groupId = groupId;
            this.roleId = roleId;
        }

        @Override
        public void execute() throws SBonitaException {
            ExternalIdentityMappingCommand.this.setDisplayNames(this.builder, this.memberType, this.userId, this.groupId, this.roleId);
            this.mapping = this.builder.done();
            ExternalIdentityMappingCommand.this.serviceAccessor.getExternalIdentityMappingService().createExternalIdentityMapping(this.mapping);
            String querySuffix = ExternalIdentityMappingCommand.this.getQuerySuffix(this.memberType);
            this.mapping = ExternalIdentityMappingCommand.this.serviceAccessor.getExternalIdentityMappingService().getExternalIdentityMappingById(this.mapping.getId(), querySuffix, querySuffix);
        }

        @Override
        public SExternalIdentityMapping getResult() {
            return this.mapping;
        }
    }
}

