/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.home;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.bonitasoft.engine.exception.BonitaHomeNotSetException;
import org.bonitasoft.engine.home.BonitaHome;
import org.bonitasoft.engine.io.PropertiesManager;

public class BonitaHomeServer
extends BonitaHome {
    private static final String TENANT_CONFIGURATION_FILE = "bonita-server.properties";
    private static final String CONF = "conf";
    private static final String REPORTS = "reports";
    private static final String BONITA_HOME_SERVER = "server";
    private static final String BONITA_HOME_PLATFORM = "platform";
    private static final String BONITA_HOME_TENANTS = "tenants";
    private static final String BONITA_HOME_PROCESSES = "processes";
    private static final String BONITA_HOME_WORK = "work";
    private static final String BONITA_HOME_TENANT_TEMPLATE = "tenant-template";
    private String tenantsPath;
    private String platformPath;
    private String serverPath;
    private Properties platformProperties = null;
    public static final BonitaHomeServer INSTANCE = new BonitaHomeServer();

    private BonitaHomeServer() {
    }

    public static BonitaHomeServer getInstance() {
        return INSTANCE;
    }

    public String getBonitaHomeServerFolder() throws BonitaHomeNotSetException {
        if (this.serverPath == null) {
            StringBuilder path = new StringBuilder(this.getBonitaHomeFolder());
            path.append(File.separatorChar);
            path.append(BONITA_HOME_SERVER);
            this.serverPath = path.toString();
        }
        return this.serverPath;
    }

    public String getPlatformFolder() throws BonitaHomeNotSetException {
        if (this.platformPath == null) {
            StringBuilder path = new StringBuilder(this.getBonitaHomeServerFolder());
            path.append(File.separatorChar);
            path.append(BONITA_HOME_PLATFORM);
            this.platformPath = path.toString();
        }
        return this.platformPath;
    }

    public String getPlatformConfFolder() throws BonitaHomeNotSetException {
        StringBuilder path = new StringBuilder(this.getPlatformFolder());
        path.append(File.separatorChar);
        path.append(CONF);
        return path.toString();
    }

    public File getPlatformFile() throws BonitaHomeNotSetException {
        String platformFolder = this.getPlatformConfFolder();
        StringBuilder builder = new StringBuilder(platformFolder);
        builder.append(File.separatorChar).append("bonita-platform.properties");
        return new File(builder.toString());
    }

    public String getTenantsFolder() throws BonitaHomeNotSetException {
        if (this.tenantsPath == null) {
            StringBuilder path = new StringBuilder(this.getBonitaHomeServerFolder());
            path.append(File.separatorChar);
            path.append(BONITA_HOME_TENANTS);
            this.tenantsPath = path.toString();
        }
        return this.tenantsPath;
    }

    public String getProcessesFolder(long tenantId) throws BonitaHomeNotSetException {
        StringBuilder path = new StringBuilder(this.getTenantFolder(tenantId));
        path.append(File.separatorChar);
        path.append(BONITA_HOME_WORK);
        path.append(File.separatorChar);
        path.append(BONITA_HOME_PROCESSES);
        return path.toString();
    }

    public String getProcessFolder(long tenantId, long processDefinitionId) throws BonitaHomeNotSetException {
        StringBuilder path = new StringBuilder(this.getTenantFolder(tenantId));
        path.append(File.separatorChar);
        path.append(BONITA_HOME_WORK);
        path.append(File.separatorChar);
        path.append(BONITA_HOME_PROCESSES);
        path.append(File.separatorChar);
        path.append(processDefinitionId);
        return path.toString();
    }

    public String getTenantFolder(long tenantId) throws BonitaHomeNotSetException {
        StringBuilder path = new StringBuilder(this.getTenantsFolder());
        path.append(File.separatorChar);
        path.append(tenantId);
        return path.toString();
    }

    public String getTenantConfFolder(long tenantId) throws BonitaHomeNotSetException {
        StringBuilder path = new StringBuilder(this.getTenantsFolder());
        path.append(File.separatorChar);
        path.append(tenantId);
        path.append(File.separatorChar);
        path.append(CONF);
        return path.toString();
    }

    public String getTenantReportFolder(long tenantId) throws BonitaHomeNotSetException {
        StringBuilder path = new StringBuilder(this.getTenantsFolder());
        path.append(File.separatorChar);
        path.append(tenantId);
        path.append(File.separatorChar);
        path.append(REPORTS);
        return path.toString();
    }

    public String getTenantTemplateFolder() throws BonitaHomeNotSetException {
        StringBuilder path = new StringBuilder(this.getPlatformFolder());
        path.append(File.separatorChar);
        path.append(BONITA_HOME_TENANT_TEMPLATE);
        return path.toString();
    }

    protected void refresh() {
        this.platformPath = null;
        this.serverPath = null;
        this.tenantsPath = null;
        this.platformProperties = null;
    }

    public Properties getPlatformProperties() throws BonitaHomeNotSetException, IOException {
        if (this.platformProperties == null) {
            this.platformProperties = PropertiesManager.getProperties((File)this.getPlatformFile());
        }
        return this.platformProperties;
    }

    public Properties getTenantProperties(long tenantId) throws BonitaHomeNotSetException, IOException {
        return PropertiesManager.getProperties((File)new File(this.getTenantConfFolder(tenantId) + File.separatorChar + TENANT_CONFIGURATION_FILE));
    }
}

