/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.persistence;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.sql.DataSource;
import org.bonitasoft.engine.commons.ClassReflector;
import org.bonitasoft.engine.persistence.DBConfiguration;
import org.bonitasoft.engine.persistence.DBConfigurationsProvider;
import org.bonitasoft.engine.persistence.FilterOption;
import org.bonitasoft.engine.persistence.PersistentObject;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.persistence.SBonitaReadException;
import org.bonitasoft.engine.persistence.SQLTransformer;
import org.bonitasoft.engine.persistence.SelectListDescriptor;
import org.bonitasoft.engine.sequence.SequenceManager;
import org.bonitasoft.engine.services.SPersistenceException;
import org.bonitasoft.engine.services.TenantPersistenceService;
import org.bonitasoft.engine.sessionaccessor.TenantIdNotSetException;

public abstract class AbstractDBPersistenceService
implements TenantPersistenceService {
    private final List<String> createTablesFiles = new ArrayList<String>();
    private final List<String> postCreateStructureFiles = new ArrayList<String>();
    private final List<String> preDropStructureFiles = new ArrayList<String>();
    private final List<String> dropTablesFiles = new ArrayList<String>();
    private final List<String> initTablesFiles = new ArrayList<String>();
    private final List<String> cleanTablesFiles = new ArrayList<String>();
    private final List<String> deleteObjectsFiles = new ArrayList<String>();
    private final Map<String, SQLTransformer> sqlTransformers = new HashMap<String, SQLTransformer>();
    private final String statementDelimiter;
    private final String likeEscapeCharacter;
    private final String name;
    private final SequenceManager sequenceManager;
    protected final DataSource datasource;

    public AbstractDBPersistenceService(String name, DBConfigurationsProvider dbConfigurationsProvider, String statementDelimiter, String likeEscapeCharacter, SequenceManager sequenceManager, DataSource datasource) {
        this.name = name;
        this.sequenceManager = sequenceManager;
        this.datasource = datasource;
        this.initTablesFiles(dbConfigurationsProvider, name);
        this.statementDelimiter = statementDelimiter;
        this.likeEscapeCharacter = likeEscapeCharacter;
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected void initTablesFiles(DBConfigurationsProvider dbConfigurationsProvider, String persistenceDBConfigFilter) {
        if (dbConfigurationsProvider != null) {
            for (DBConfiguration dbConfiguration : dbConfigurationsProvider.getMatchingTenantConfigurations(persistenceDBConfigFilter)) {
                if (dbConfiguration.hasCreateTablesFile()) {
                    this.createTablesFiles.add(dbConfiguration.getCreateTablesFile());
                }
                if (dbConfiguration.hasInitTablesFile()) {
                    this.initTablesFiles.add(dbConfiguration.getInitTablesFile());
                }
                if (dbConfiguration.hasCleanTablesFile()) {
                    this.cleanTablesFiles.add(dbConfiguration.getCleanTablesFile());
                }
                if (dbConfiguration.hasDropTablesFile()) {
                    this.dropTablesFiles.add(dbConfiguration.getDropTablesFile());
                }
                if (dbConfiguration.hasDeleteTenantObjectsFile()) {
                    this.deleteObjectsFiles.add(dbConfiguration.getDeleteTenantObjectsFile());
                }
                if (dbConfiguration.hasPostCreateStructureFile()) {
                    this.postCreateStructureFiles.add(dbConfiguration.getPostCreateStructureFile());
                }
                if (dbConfiguration.hasPreDropStructureFile()) {
                    this.preDropStructureFiles.add(dbConfiguration.getPreDropStructureFile());
                }
                if (!dbConfiguration.hasSqlTransformers()) continue;
                this.sqlTransformers.putAll(dbConfiguration.getSqlTransformers());
            }
        }
    }

    @Override
    public void createStructure() throws SPersistenceException, IOException {
        for (String sqlResource : this.createTablesFiles) {
            this.executeSQL(sqlResource, this.statementDelimiter, null, true);
        }
    }

    @Override
    public void postCreateStructure() throws SPersistenceException, IOException {
        for (String sqlResource : this.postCreateStructureFiles) {
            this.executeSQL(sqlResource, this.statementDelimiter, null, true);
        }
    }

    @Override
    public void preDropStructure() throws SPersistenceException, IOException {
        for (String sqlResource : this.preDropStructureFiles) {
            this.executeSQL(sqlResource, this.statementDelimiter, null, true);
        }
    }

    @Override
    public void cleanStructure() throws SPersistenceException, IOException {
        for (String sqlResource : this.cleanTablesFiles) {
            this.executeSQL(sqlResource, this.statementDelimiter, null, true);
        }
    }

    @Override
    public void deleteStructure() throws SPersistenceException, IOException {
        this.sequenceManager.clear();
        for (String sqlResource : this.dropTablesFiles) {
            this.executeSQL(sqlResource, this.statementDelimiter, null, true);
        }
    }

    @Override
    public void initializeStructure() throws SPersistenceException, IOException {
        this.initializeStructure(Collections.<String, String>emptyMap());
    }

    @Override
    public void initializeStructure(Map<String, String> replacements) throws SPersistenceException, IOException {
        for (String sqlResource : this.initTablesFiles) {
            this.executeSQL(sqlResource, this.statementDelimiter, replacements, false);
        }
    }

    @Override
    public void deleteTenant(long tenantId) throws SPersistenceException, IOException {
        this.sequenceManager.clear(tenantId);
        Map<String, String> replacements = Collections.singletonMap("tenantid", String.valueOf(tenantId));
        for (String sqlResource : this.deleteObjectsFiles) {
            this.executeSQL(sqlResource, this.statementDelimiter, replacements, true);
        }
    }

    private void executeSQL(String sqlResource, String statementDelimiter, Map<String, String> replacements, boolean useDataSourceConnection) throws SPersistenceException, IOException {
        if (replacements != null) {
            HashMap<String, String> replacementsWithVarDelimiters = new HashMap<String, String>();
            for (Map.Entry<String, String> entry : replacements.entrySet()) {
                if (entry.getKey().charAt(0) == '$') {
                    replacementsWithVarDelimiters.put(entry.getKey(), entry.getValue());
                    continue;
                }
                replacementsWithVarDelimiters.put("\\$\\{" + entry.getKey() + "\\}", entry.getValue());
            }
            this.doExecuteSQL(sqlResource, statementDelimiter, replacementsWithVarDelimiters, useDataSourceConnection);
        } else {
            this.doExecuteSQL(sqlResource, statementDelimiter, null, useDataSourceConnection);
        }
    }

    protected SQLTransformer getSqlTransformer(String className) {
        return this.sqlTransformers.get(className);
    }

    protected List<SQLTransformer> getSqlTransformers() {
        return new ArrayList<SQLTransformer>(this.sqlTransformers.values());
    }

    protected abstract void doExecuteSQL(String var1, String var2, Map<String, String> var3, boolean var4) throws SPersistenceException, IOException;

    @Override
    public <T extends PersistentObject> long getNumberOfEntities(Class<T> entityClass, QueryOptions options, Map<String, Object> parameters) throws SBonitaReadException {
        return this.getNumberOfEntities(entityClass, null, options, parameters);
    }

    @Override
    public <T extends PersistentObject> long getNumberOfEntities(Class<T> entityClass, String querySuffix, QueryOptions options, Map<String, Object> parameters) throws SBonitaReadException {
        List<Object> filters = options == null ? Collections.emptyList() : options.getFilters();
        String queryName = this.getQueryName("getNumberOf", querySuffix, entityClass, filters);
        SelectListDescriptor<Long> descriptor = new SelectListDescriptor<Long>(queryName, parameters, entityClass, Long.class, options);
        return this.selectList(descriptor).get(0);
    }

    @Override
    public <T extends PersistentObject> List<T> searchEntity(Class<T> entityClass, QueryOptions options, Map<String, Object> parameters) throws SBonitaReadException {
        return this.searchEntity(entityClass, null, options, parameters);
    }

    @Override
    public <T extends PersistentObject> List<T> searchEntity(Class<T> entityClass, String querySuffix, QueryOptions options, Map<String, Object> parameters) throws SBonitaReadException {
        String queryName = this.getQueryName("search", querySuffix, entityClass, options.getFilters());
        SelectListDescriptor descriptor = new SelectListDescriptor(queryName, parameters, entityClass, options);
        return this.selectList(descriptor);
    }

    private <T extends PersistentObject> String getQueryName(String prefix, String suffix, Class<T> entityClass, List<FilterOption> filters) {
        TreeSet<String> query = new TreeSet<String>();
        for (FilterOption filter : filters) {
            if (filter.getPersistentClass() == null) continue;
            String name = filter.getPersistentClass().getSimpleName();
            query.add(name);
        }
        String searchOnClassName = entityClass.getSimpleName();
        query.remove(searchOnClassName);
        StringBuilder builder = new StringBuilder(prefix);
        builder.append(searchOnClassName);
        if (query.size() > 0) {
            builder.append("with");
        }
        for (String entity : query) {
            builder.append(entity);
        }
        if (suffix != null) {
            builder.append(suffix);
        }
        return builder.toString();
    }

    protected abstract long getTenantId() throws TenantIdNotSetException;

    protected SequenceManager getSequenceManager() {
        return this.sequenceManager;
    }

    protected void setId(PersistentObject entity) throws SPersistenceException {
        if (entity == null) {
            return;
        }
        Long id = null;
        try {
            id = entity.getId();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (id == null || id == -1L || id == 0L) {
            try {
                id = this.getSequenceManager().getNextId(entity.getClass().getName(), this.getTenantId());
                ClassReflector.invokeSetter(entity, "setId", Long.TYPE, id);
            }
            catch (Exception e) {
                throw new SPersistenceException("Problem while saving entity: " + entity + " with id: " + id, e);
            }
        }
    }

    protected String getLikeEscapeClause(String term) {
        StringBuilder builder = new StringBuilder();
        builder.append(" LIKE '");
        builder.append(term.replaceAll("'", "''").replaceAll(this.likeEscapeCharacter, this.likeEscapeCharacter + this.likeEscapeCharacter).replaceAll("%", this.likeEscapeCharacter + "%").replaceAll("_", this.likeEscapeCharacter + "_"));
        builder.append("%' ESCAPE '").append(this.likeEscapeCharacter).append('\'');
        return builder.toString();
    }
}

