/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.platform.authentication.impl;

import org.bonitasoft.engine.commons.LogUtil;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.platform.authentication.PlatformAuthenticationService;
import org.bonitasoft.engine.platform.authentication.SInvalidPasswordException;
import org.bonitasoft.engine.platform.authentication.SInvalidUserException;

public class PlatformAuthenticationServiceImpl
implements PlatformAuthenticationService {
    private final String USERNAME = "platformAdmin";
    private final String PASSWORD = "platform";
    private final TechnicalLoggerService logger;

    public PlatformAuthenticationServiceImpl(TechnicalLoggerService logger) {
        this.logger = logger;
    }

    @Override
    public void checkUserCredentials(String username, String password) throws SInvalidUserException, SInvalidPasswordException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "checkUserCredentials"));
        }
        if (!"platformAdmin".equals(username)) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "checkUserCredentials", "Invalid user: " + username));
            }
            throw new SInvalidUserException("Invalid user: " + username);
        }
        if (!"platform".equals(password)) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "checkUserCredentials", "Invalid user: " + username));
            }
            throw new SInvalidPasswordException("Invalid password");
        }
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "checkUserCredentials"));
        }
    }
}

