/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.scheduler.impl;

import java.util.ArrayList;
import java.util.List;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.events.EventActionType;
import org.bonitasoft.engine.events.EventService;
import org.bonitasoft.engine.events.model.SDeleteEvent;
import org.bonitasoft.engine.events.model.SInsertEvent;
import org.bonitasoft.engine.events.model.builders.SEventBuilder;
import org.bonitasoft.engine.persistence.FilterOption;
import org.bonitasoft.engine.persistence.PersistentObject;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.persistence.ReadPersistenceService;
import org.bonitasoft.engine.persistence.SBonitaReadException;
import org.bonitasoft.engine.persistence.SBonitaSearchException;
import org.bonitasoft.engine.recorder.Recorder;
import org.bonitasoft.engine.recorder.SRecorderException;
import org.bonitasoft.engine.recorder.model.DeleteRecord;
import org.bonitasoft.engine.recorder.model.InsertRecord;
import org.bonitasoft.engine.scheduler.JobService;
import org.bonitasoft.engine.scheduler.builder.SJobParameterBuilder;
import org.bonitasoft.engine.scheduler.builder.impl.SJobParameterBuilderImpl;
import org.bonitasoft.engine.scheduler.exception.SSchedulerException;
import org.bonitasoft.engine.scheduler.exception.jobDescriptor.SJobDescriptorCreationException;
import org.bonitasoft.engine.scheduler.exception.jobDescriptor.SJobDescriptorDeletionException;
import org.bonitasoft.engine.scheduler.exception.jobDescriptor.SJobDescriptorNotFoundException;
import org.bonitasoft.engine.scheduler.exception.jobDescriptor.SJobDescriptorReadException;
import org.bonitasoft.engine.scheduler.exception.jobLog.SJobLogCreationException;
import org.bonitasoft.engine.scheduler.exception.jobLog.SJobLogDeletionException;
import org.bonitasoft.engine.scheduler.exception.jobLog.SJobLogNotFoundException;
import org.bonitasoft.engine.scheduler.exception.jobLog.SJobLogReadException;
import org.bonitasoft.engine.scheduler.exception.jobParameter.SJobParameterCreationException;
import org.bonitasoft.engine.scheduler.exception.jobParameter.SJobParameterDeletionException;
import org.bonitasoft.engine.scheduler.exception.jobParameter.SJobParameterNotFoundException;
import org.bonitasoft.engine.scheduler.exception.jobParameter.SJobParameterReadException;
import org.bonitasoft.engine.scheduler.model.SFailedJob;
import org.bonitasoft.engine.scheduler.model.SJobDescriptor;
import org.bonitasoft.engine.scheduler.model.SJobLog;
import org.bonitasoft.engine.scheduler.model.SJobParameter;
import org.bonitasoft.engine.scheduler.model.impl.SJobDescriptorImpl;
import org.bonitasoft.engine.scheduler.model.impl.SJobParameterImpl;
import org.bonitasoft.engine.scheduler.recorder.SelectDescriptorBuilder;

public class JobServiceImpl
implements JobService {
    private final EventService eventService;
    private final Recorder recorder;
    private final ReadPersistenceService readPersistenceService;

    public JobServiceImpl(EventService eventService, Recorder recorder, ReadPersistenceService readPersistenceService) {
        this.readPersistenceService = readPersistenceService;
        this.eventService = eventService;
        this.recorder = recorder;
    }

    @Override
    public SJobDescriptor createJobDescriptor(SJobDescriptor sJobDescriptor, long tenantId) throws SJobDescriptorCreationException {
        if (sJobDescriptor == null) {
            throw new SJobDescriptorCreationException("The job is null");
        }
        if (sJobDescriptor.getJobName() == null) {
            throw new SJobDescriptorCreationException("The job name is null");
        }
        SJobDescriptorImpl sJobDescriptorToRecord = new SJobDescriptorImpl(sJobDescriptor.getJobClassName(), sJobDescriptor.getJobName(), sJobDescriptor.getDescription(), sJobDescriptor.disallowConcurrentExecution());
        sJobDescriptorToRecord.setTenantId(tenantId);
        try {
            this.create(sJobDescriptorToRecord, "JOB_DESCRIPTOR");
        }
        catch (SRecorderException sre) {
            throw new SJobDescriptorCreationException(sre);
        }
        return sJobDescriptorToRecord;
    }

    @Override
    public void deleteJobDescriptor(long id) throws SJobDescriptorNotFoundException, SJobDescriptorReadException, SJobDescriptorDeletionException {
        SJobDescriptor sJobDescriptor = this.getJobDescriptor(id);
        this.deleteJobDescriptor(sJobDescriptor);
    }

    @Override
    public void deleteJobDescriptor(SJobDescriptor sJobDescriptor) throws SJobDescriptorDeletionException {
        try {
            this.delete(sJobDescriptor, "JOB_DESCRIPTOR");
        }
        catch (SBonitaException e) {
            throw new SJobDescriptorDeletionException(e);
        }
    }

    @Override
    public SJobDescriptor getJobDescriptor(long id) throws SJobDescriptorNotFoundException, SJobDescriptorReadException {
        try {
            SJobDescriptor sJobDescriptor = this.readPersistenceService.selectById(SelectDescriptorBuilder.getElementById(SJobDescriptor.class, "SJobDescriptor", id));
            if (sJobDescriptor == null) {
                throw new SJobDescriptorNotFoundException(id);
            }
            return sJobDescriptor;
        }
        catch (SBonitaReadException sbre) {
            throw new SJobDescriptorReadException(sbre);
        }
    }

    @Override
    public long getNumberOfJobDescriptors(QueryOptions queryOptions) throws SBonitaSearchException {
        try {
            return this.readPersistenceService.getNumberOfEntities(SJobDescriptor.class, queryOptions, null);
        }
        catch (SBonitaReadException e) {
            throw new SBonitaSearchException(e);
        }
    }

    @Override
    public List<SJobDescriptor> searchJobDescriptors(QueryOptions queryOptions) throws SBonitaSearchException {
        try {
            return this.readPersistenceService.searchEntity(SJobDescriptor.class, queryOptions, null);
        }
        catch (SBonitaReadException e) {
            throw new SBonitaSearchException(e);
        }
    }

    @Override
    public void createJobParameters(List<SJobParameter> sJobParameters, long tenantId, long jobDescriptorId) throws SJobParameterCreationException {
        if (sJobParameters != null) {
            for (SJobParameter sJobParameter : sJobParameters) {
                this.createJobParameter(sJobParameter, tenantId, jobDescriptorId);
            }
        }
    }

    @Override
    public void setJobParameters(long tenantId, long jobDescriptorId, List<SJobParameter> parameters) throws SJobParameterCreationException {
        try {
            int limit = 100;
            ArrayList<FilterOption> filters = new ArrayList<FilterOption>(2);
            filters.add(new FilterOption(SJobParameter.class, "jobDescriptorId", jobDescriptorId));
            QueryOptions options = new QueryOptions(0, 100, null, filters, null);
            List<SJobParameter> jobParameters = null;
            do {
                jobParameters = this.searchJobParameters(options);
                for (SJobParameter jobParameter : jobParameters) {
                    this.deleteJobParameter(jobParameter);
                }
            } while (jobParameters.size() == 100);
        }
        catch (SBonitaException sbe) {
            throw new SJobParameterCreationException(sbe);
        }
        this.createJobParameters(parameters, tenantId, jobDescriptorId);
    }

    @Override
    public void createJobParameter(SJobParameter sJobParameter, long tenantId, long jobDescriptorId) throws SJobParameterCreationException {
        SJobParameterImpl sJobParameterToRecord = (SJobParameterImpl)this.getJobParameterBuilder().createNewInstance(sJobParameter.getKey(), sJobParameter.getValue()).setJobDescriptorId(jobDescriptorId).done();
        sJobParameterToRecord.setTenantId(tenantId);
        try {
            this.create(sJobParameterToRecord, "JOB_PARAMETER");
        }
        catch (SRecorderException sre) {
            throw new SJobParameterCreationException(sre);
        }
    }

    @Override
    public void deleteJobParameter(long id) throws SJobParameterNotFoundException, SJobParameterReadException, SJobParameterDeletionException {
        SJobParameter sJobParameter = this.getJobParameter(id);
        this.deleteJobParameter(sJobParameter);
    }

    @Override
    public void deleteJobParameter(SJobParameter sJobParameter) throws SJobParameterDeletionException {
        try {
            this.delete(sJobParameter, "JOB_PARAMETER");
        }
        catch (SBonitaException e) {
            throw new SJobParameterDeletionException(e);
        }
    }

    @Override
    public SJobParameter getJobParameter(long id) throws SJobParameterNotFoundException, SJobParameterReadException {
        try {
            SJobParameter sJobParameter = this.readPersistenceService.selectById(SelectDescriptorBuilder.getElementById(SJobParameter.class, "SJobParameter", id));
            if (sJobParameter == null) {
                throw new SJobParameterNotFoundException(id);
            }
            return sJobParameter;
        }
        catch (SBonitaReadException sbre) {
            throw new SJobParameterReadException(sbre);
        }
    }

    @Override
    public List<SJobParameter> searchJobParameters(QueryOptions queryOptions) throws SBonitaSearchException {
        try {
            return this.readPersistenceService.searchEntity(SJobParameter.class, queryOptions, null);
        }
        catch (SBonitaReadException e) {
            throw new SBonitaSearchException(e);
        }
    }

    @Override
    public void createJobLog(SJobLog sJobLog) throws SJobLogCreationException {
        try {
            this.create(sJobLog, "JOB_LOG");
        }
        catch (SRecorderException sre) {
            throw new SJobLogCreationException(sre);
        }
    }

    @Override
    public void deleteJobLog(long id) throws SJobLogNotFoundException, SJobLogReadException, SJobLogDeletionException {
        SJobLog sJobLog = this.getJobLog(id);
        this.deleteJobLog(sJobLog);
    }

    @Override
    public void deleteJobLog(SJobLog sJobLog) throws SJobLogDeletionException {
        try {
            this.delete(sJobLog, "JOB_LOG");
        }
        catch (SBonitaException e) {
            throw new SJobLogDeletionException(e);
        }
    }

    @Override
    public SJobLog getJobLog(long id) throws SJobLogNotFoundException, SJobLogReadException {
        try {
            SJobLog sJobLog = this.readPersistenceService.selectById(SelectDescriptorBuilder.getElementById(SJobLog.class, "SJobLog", id));
            if (sJobLog == null) {
                throw new SJobLogNotFoundException(id);
            }
            return sJobLog;
        }
        catch (SBonitaReadException sbre) {
            throw new SJobLogReadException(sbre);
        }
    }

    @Override
    public long getNumberOfJobLogs(QueryOptions queryOptions) throws SBonitaSearchException {
        try {
            return this.readPersistenceService.getNumberOfEntities(SJobLog.class, queryOptions, null);
        }
        catch (SBonitaReadException e) {
            throw new SBonitaSearchException(e);
        }
    }

    @Override
    public List<SJobLog> searchJobLogs(QueryOptions queryOptions) throws SBonitaSearchException {
        try {
            return this.readPersistenceService.searchEntity(SJobLog.class, queryOptions, null);
        }
        catch (SBonitaReadException e) {
            throw new SBonitaSearchException(e);
        }
    }

    private SJobParameterBuilder getJobParameterBuilder() {
        return new SJobParameterBuilderImpl();
    }

    private void delete(PersistentObject persistentObject, String eventType) throws SRecorderException {
        DeleteRecord deleteRecord = new DeleteRecord(persistentObject);
        SDeleteEvent deleteEvent = null;
        if (this.eventService.hasHandlers(eventType, EventActionType.DELETED)) {
            SEventBuilder eventBuilder = this.eventService.getEventBuilder();
            deleteEvent = (SDeleteEvent)eventBuilder.createDeleteEvent(eventType).setObject(persistentObject).done();
        }
        this.recorder.recordDelete(deleteRecord, deleteEvent);
    }

    private void create(PersistentObject persistentObject, String eventType) throws SRecorderException {
        InsertRecord insertRecord = new InsertRecord(persistentObject);
        SInsertEvent insertEvent = null;
        if (this.eventService.hasHandlers(eventType, EventActionType.CREATED)) {
            SEventBuilder eventBuilder = this.eventService.getEventBuilder();
            insertEvent = (SInsertEvent)eventBuilder.createInsertEvent(eventType).setObject(persistentObject).done();
        }
        this.recorder.recordInsert(insertRecord, insertEvent);
    }

    @Override
    public List<SFailedJob> getFailedJobs(int startIndex, int maxResults) throws SSchedulerException {
        QueryOptions queryOptions = new QueryOptions(startIndex, maxResults);
        try {
            return this.readPersistenceService.selectList(SelectDescriptorBuilder.getFailedJobs(queryOptions));
        }
        catch (SBonitaReadException sbre) {
            throw new SSchedulerException(sbre);
        }
    }
}

