/**
 * Copyright (C) 2012 BonitaSoft S.A.
 * BonitaSoft, 32 rue Gustave Eiffel - 38000 Grenoble
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 **/
package org.bonitasoft.engine.core.process.document.mapping.model.builder;

import org.bonitasoft.engine.recorder.model.EntityUpdateDescriptor;

/**
 * @author Nicolas Chabanoles
 */
public interface SDocumentMappingUpdateBuilder {

    SDocumentMappingUpdateBuilder createNewInstance();

    SDocumentMappingUpdateBuilder setDocumentName(String documentName);

    SDocumentMappingUpdateBuilder setDocumentAuthor(long author);

    SDocumentMappingUpdateBuilder setDocumentCreationDate(long creationDate);

    SDocumentMappingUpdateBuilder setHasContent(boolean hasContent);

    SDocumentMappingUpdateBuilder setDocumentContentFileName(String contentFileName);

    SDocumentMappingUpdateBuilder setDocumentContentMimeType(String contentMimeType);

    SDocumentMappingUpdateBuilder setDocumentStorageId(final String documentId);

    SDocumentMappingUpdateBuilder setDocumentURL(String generateURL);

    EntityUpdateDescriptor done();
}
