/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl;

import java.io.IOException;
import java.io.Serializable;
import java.lang.constant.Constable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.bonitasoft.engine.api.NoSessionRequired;
import org.bonitasoft.engine.api.PlatformAPI;
import org.bonitasoft.engine.api.impl.AvailableOnStoppedNode;
import org.bonitasoft.engine.api.impl.transaction.CustomTransactions;
import org.bonitasoft.engine.api.internal.ServerAPI;
import org.bonitasoft.engine.api.internal.ServerWrappedException;
import org.bonitasoft.engine.classloader.ClassLoaderException;
import org.bonitasoft.engine.classloader.ClassLoaderService;
import org.bonitasoft.engine.commons.ClassReflector;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.core.login.LoginService;
import org.bonitasoft.engine.core.platform.login.PlatformLoginService;
import org.bonitasoft.engine.exception.BonitaException;
import org.bonitasoft.engine.exception.BonitaHomeConfigurationException;
import org.bonitasoft.engine.exception.BonitaHomeNotSetException;
import org.bonitasoft.engine.exception.BonitaRuntimeException;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.platform.NodeNotStartedException;
import org.bonitasoft.engine.platform.PlatformService;
import org.bonitasoft.engine.platform.session.PlatformSessionService;
import org.bonitasoft.engine.scheduler.SchedulerService;
import org.bonitasoft.engine.scheduler.exception.SSchedulerException;
import org.bonitasoft.engine.service.APIAccessResolver;
import org.bonitasoft.engine.service.PlatformServiceAccessor;
import org.bonitasoft.engine.service.TenantServiceAccessor;
import org.bonitasoft.engine.service.impl.ServiceAccessorFactory;
import org.bonitasoft.engine.session.APISession;
import org.bonitasoft.engine.session.InvalidSessionException;
import org.bonitasoft.engine.session.PlatformSession;
import org.bonitasoft.engine.session.Session;
import org.bonitasoft.engine.session.SessionService;
import org.bonitasoft.engine.sessionaccessor.SessionAccessor;
import org.bonitasoft.engine.transaction.TransactionService;

public class ServerAPIImpl
implements ServerAPI {
    private static final String IS_NODE_STARTED_METHOD_NAME = "isNodeStarted";
    private static final long serialVersionUID = -161775388604256321L;
    private final APIAccessResolver accessResolver;
    private final boolean cleanSession;
    private TechnicalLoggerService technicalLogger;

    public ServerAPIImpl() {
        this(true);
    }

    public ServerAPIImpl(boolean cleanSession) {
        this.cleanSession = cleanSession;
        try {
            this.accessResolver = ServiceAccessorFactory.getInstance().createAPIAccessResolver();
        }
        catch (Exception e) {
            throw new BonitaRuntimeException((Throwable)e);
        }
    }

    void setTechnicalLogger(TechnicalLoggerService technicalLoggerService) {
        this.technicalLogger = technicalLoggerService;
    }

    public Object invokeMethod(Map<String, Serializable> options, String apiInterfaceName, String methodName, List<String> classNameParameters, Object[] parametersValues) throws ServerWrappedException {
        ClassLoader baseClassLoader = Thread.currentThread().getContextClassLoader();
        SessionAccessor sessionAccessor = null;
        try {
            sessionAccessor = this.beforeInvokeMethod(options, apiInterfaceName);
            Session session = (Session)options.get("session");
            Object object = this.invokeAPI(apiInterfaceName, methodName, classNameParameters, parametersValues, session);
            return object;
        }
        catch (ServerAPIRuntimeException sapire) {
            try {
                throw sapire.getCause();
            }
            catch (BonitaRuntimeException bre) {
                throw new ServerWrappedException((Throwable)bre);
            }
            catch (BonitaException be) {
                throw new ServerWrappedException((Throwable)be);
            }
            catch (UndeclaredThrowableException ute) {
                if (this.technicalLogger != null && this.technicalLogger.isLoggable(this.getClass(), TechnicalLogSeverity.DEBUG)) {
                    this.technicalLogger.log(this.getClass(), TechnicalLogSeverity.DEBUG, ute);
                }
                throw new ServerWrappedException((Throwable)ute);
            }
            catch (Throwable cause) {
                if (this.technicalLogger != null && this.technicalLogger.isLoggable(this.getClass(), TechnicalLogSeverity.DEBUG)) {
                    this.technicalLogger.log(this.getClass(), TechnicalLogSeverity.DEBUG, cause);
                }
                throw new ServerWrappedException((Throwable)new BonitaRuntimeException(cause));
            }
        }
        finally {
            if (this.cleanSession && sessionAccessor != null) {
                sessionAccessor.deleteSessionId();
            }
            Thread.currentThread().setContextClassLoader(baseClassLoader);
        }
    }

    private SessionAccessor beforeInvokeMethod(Map<String, Serializable> options, String apiInterfaceName) throws BonitaHomeNotSetException, InstantiationException, IllegalAccessException, ClassNotFoundException, BonitaHomeConfigurationException, IOException, NoSuchMethodException, InvocationTargetException, SBonitaException {
        SessionAccessor sessionAccessor = null;
        ServiceAccessorFactory serviceAccessorFactory = ServiceAccessorFactory.getInstance();
        PlatformServiceAccessor platformServiceAccessor = serviceAccessorFactory.createPlatformServiceAccessor();
        ClassLoader serverClassLoader = null;
        Session session = (Session)options.get("session");
        if (session != null) {
            SessionType sessionType = this.getSessionType(session);
            sessionAccessor = serviceAccessorFactory.createSessionAccessor();
            switch (sessionType) {
                case PLATFORM: {
                    PlatformSessionService platformSessionService = platformServiceAccessor.getPlatformSessionService();
                    PlatformLoginService loginService = platformServiceAccessor.getPlatformLoginService();
                    if (!loginService.isValid(session.getId())) {
                        throw new InvalidSessionException("Invalid session");
                    }
                    platformSessionService.renewSession(session.getId());
                    sessionAccessor.setSessionInfo(session.getId(), -1L);
                    serverClassLoader = this.getPlatformClassLoader(platformServiceAccessor);
                    this.setTechnicalLogger(platformServiceAccessor.getTechnicalLoggerService());
                    break;
                }
                case API: {
                    SessionService sessionService = platformServiceAccessor.getSessionService();
                    this.checkTenantSession(platformServiceAccessor, session);
                    sessionService.renewSession(session.getId());
                    sessionAccessor.setSessionInfo(session.getId(), ((APISession)session).getTenantId());
                    serverClassLoader = this.getTenantClassLoader(platformServiceAccessor, session);
                    this.setTechnicalLogger(serviceAccessorFactory.createTenantServiceAccessor(((APISession)session).getTenantId()).getTechnicalLoggerService());
                    break;
                }
                default: {
                    throw new InvalidSessionException("Unknown session type: " + session.getClass().getName());
                }
            }
        } else if (this.accessResolver.needSession(apiInterfaceName)) {
            throw new InvalidSessionException("Session is null!");
        }
        if (serverClassLoader != null) {
            Thread.currentThread().setContextClassLoader(serverClassLoader);
        }
        return sessionAccessor;
    }

    private SessionType getSessionType(Session session) {
        SessionType sessionType = null;
        if (session instanceof PlatformSession) {
            sessionType = SessionType.PLATFORM;
        } else if (session instanceof APISession) {
            sessionType = SessionType.API;
        }
        return sessionType;
    }

    private Object invokeAPI(String apiInterfaceName, String methodName, List<String> classNameParameters, Object[] parametersValues, Session session) throws Throwable {
        Class<?>[] parameterTypes = this.getParameterTypes(classNameParameters);
        Object apiImpl = this.accessResolver.getAPIImplementation(apiInterfaceName);
        Method method = ClassReflector.getMethod(apiImpl.getClass(), methodName, parameterTypes);
        if (!this.isNodeInAValidStateFor(method)) {
            this.logNodeNotStartedMessage(apiInterfaceName, methodName);
            throw new NodeNotStartedException();
        }
        if (method.isAnnotationPresent(CustomTransactions.class) || method.isAnnotationPresent(NoSessionRequired.class)) {
            return this.invokeAPI(parametersValues, apiImpl, method);
        }
        return this.invokeAPIInTransaction(parametersValues, apiImpl, method, session);
    }

    private void logNodeNotStartedMessage(String apiInterfaceName, String methodName) {
        String message = "Node not started. Method '" + apiInterfaceName + "." + methodName + "' cannot be called until node has been started (PlatformAPI.startNode())";
        if (this.technicalLogger != null) {
            this.technicalLogger.log(this.getClass(), TechnicalLogSeverity.ERROR, message);
        } else {
            System.err.println(message);
        }
    }

    private boolean isNodeInAValidStateFor(Method method) {
        return method.isAnnotationPresent(AvailableOnStoppedNode.class) || this.isNodeStarted();
    }

    private boolean isNodeStarted() {
        try {
            Object apiImpl = this.accessResolver.getAPIImplementation(PlatformAPI.class.getName());
            Method method = ClassReflector.getMethod(apiImpl.getClass(), IS_NODE_STARTED_METHOD_NAME, new Class[0]);
            return (Boolean)this.invokeAPI(new Object[0], apiImpl, method);
        }
        catch (Throwable e) {
            return false;
        }
    }

    private Object invokeAPIInTransaction(final Object[] parametersValues, final Object apiImpl, final Method method, Session session) throws Throwable {
        if (session == null) {
            throw new BonitaRuntimeException("session is null");
        }
        TransactionService transactionService = this.selectTransactionService(session, this.getSessionType(session));
        Callable<Object> callable = new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                try {
                    return ServerAPIImpl.this.invokeAPI(parametersValues, apiImpl, method);
                }
                catch (Throwable cause) {
                    throw new ServerAPIRuntimeException(cause);
                }
            }
        };
        return transactionService.executeInTransaction(callable);
    }

    protected TransactionService selectTransactionService(Session session, SessionType sessionType) throws BonitaHomeNotSetException, InstantiationException, IllegalAccessException, ClassNotFoundException, IOException, BonitaHomeConfigurationException {
        TransactionService transactionService = null;
        ServiceAccessorFactory serviceAccessorFactory = ServiceAccessorFactory.getInstance();
        PlatformServiceAccessor platformServiceAccessor = serviceAccessorFactory.createPlatformServiceAccessor();
        switch (sessionType) {
            case PLATFORM: {
                transactionService = platformServiceAccessor.getTransactionService();
                break;
            }
            case API: {
                TenantServiceAccessor tenantAccessor = platformServiceAccessor.getTenantServiceAccessor(((APISession)session).getTenantId());
                transactionService = tenantAccessor.getTransactionService();
                break;
            }
            default: {
                throw new InvalidSessionException("Unknown session type: " + session.getClass().getName());
            }
        }
        return transactionService;
    }

    private Object invokeAPI(Object[] parametersValues, Object apiImpl, Method method) throws Throwable {
        try {
            return method.invoke(apiImpl, parametersValues);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    private Class<?>[] getParameterTypes(List<String> classNameParameters) throws ClassNotFoundException {
        Class[] parameterTypes = null;
        if (classNameParameters != null && !classNameParameters.isEmpty()) {
            parameterTypes = new Class[classNameParameters.size()];
            for (int i = 0; i < parameterTypes.length; ++i) {
                String className = classNameParameters.get(i);
                Class<Constable> classType = null;
                classType = "int".equals(className) ? Integer.TYPE : ("long".equals(className) ? Long.TYPE : ("boolean".equals(className) ? Boolean.TYPE : Class.forName(className)));
                parameterTypes[i] = classType;
            }
        }
        return parameterTypes;
    }

    private void checkTenantSession(PlatformServiceAccessor platformAccessor, Session session) throws SSchedulerException {
        APISession apiSession;
        TenantServiceAccessor tenantAccessor;
        LoginService tenantLoginService;
        SchedulerService schedulerService = platformAccessor.getSchedulerService();
        TechnicalLoggerService logger = platformAccessor.getTechnicalLoggerService();
        if (!schedulerService.isStarted() && logger.isLoggable(this.getClass(), TechnicalLogSeverity.DEBUG)) {
            logger.log(this.getClass(), TechnicalLogSeverity.DEBUG, "The scheduler is not started!");
        }
        if (!(tenantLoginService = (tenantAccessor = platformAccessor.getTenantServiceAccessor((apiSession = (APISession)session).getTenantId())).getLoginService()).isValid(apiSession.getId())) {
            throw new InvalidSessionException("Invalid session");
        }
    }

    private ClassLoader getTenantClassLoader(PlatformServiceAccessor platformServiceAccessor, Session session) throws ClassLoaderException {
        APISession apiSession = (APISession)session;
        TenantServiceAccessor tenantAccessor = platformServiceAccessor.getTenantServiceAccessor(apiSession.getTenantId());
        ClassLoaderService classLoaderService = tenantAccessor.getClassLoaderService();
        return classLoaderService.getLocalClassLoader("tenant", apiSession.getTenantId());
    }

    private ClassLoader getPlatformClassLoader(PlatformServiceAccessor platformServiceAccessor) throws ClassLoaderException {
        ClassLoader classLoader = null;
        PlatformService platformService = platformServiceAccessor.getPlatformService();
        if (platformService.isPlatformCreated()) {
            ClassLoaderService classLoaderService = platformServiceAccessor.getClassLoaderService();
            classLoader = classLoaderService.getGlobalClassLoader();
        }
        return classLoader;
    }

    private static final class ServerAPIRuntimeException
    extends RuntimeException {
        private static final long serialVersionUID = -5675131531953146131L;

        ServerAPIRuntimeException(Throwable cause) {
            super(cause);
        }
    }

    private static enum SessionType {
        PLATFORM,
        API;

    }
}

