/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl.transaction.identity;

import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.commons.transaction.TransactionContentWithResult;
import org.bonitasoft.engine.identity.IdentityService;
import org.bonitasoft.engine.identity.model.SGroup;
import org.bonitasoft.engine.identity.model.SRole;
import org.bonitasoft.engine.identity.model.SUser;
import org.bonitasoft.engine.identity.model.SUserMembership;
import org.bonitasoft.engine.identity.model.builder.UserMembershipBuilder;

public class AddUserMembership
implements TransactionContentWithResult<SUserMembership> {
    private final IdentityService identityService;
    private final UserMembershipBuilder userMembershipBuilder;
    private final long userId;
    private final long groupId;
    private final long roleId;
    private final long assignedBy;
    private SUserMembership userMembership;

    public AddUserMembership(long userId, long groupId, long roleId, long assignedBy, IdentityService identityService, UserMembershipBuilder userMembershipBuilder) {
        this.assignedBy = assignedBy;
        this.identityService = identityService;
        this.userMembershipBuilder = userMembershipBuilder;
        this.userId = userId;
        this.groupId = groupId;
        this.roleId = roleId;
    }

    @Override
    public void execute() throws SBonitaException {
        SUser user = this.identityService.getUser(this.userId);
        SRole role = this.identityService.getRole(this.roleId);
        SGroup group = this.identityService.getGroup(this.groupId);
        this.userMembership = this.userMembershipBuilder.createNewInstance(user.getId(), group.getId(), role.getId()).setAssignedBy(this.assignedBy).setAssignedDate(System.currentTimeMillis()).done();
        this.identityService.createUserMembership(this.userMembership);
    }

    @Override
    public SUserMembership getResult() {
        return this.userMembership;
    }
}

