/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.core.operation.impl;

import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.bonitasoft.engine.core.expression.control.model.SExpressionContext;
import org.bonitasoft.engine.core.operation.exception.SOperationExecutionException;
import org.bonitasoft.engine.core.operation.impl.UpdateOperationExecutorStrategy;
import org.bonitasoft.engine.core.operation.model.SOperation;
import org.bonitasoft.engine.data.instance.api.DataInstanceService;
import org.bonitasoft.engine.data.instance.model.builder.SDataInstanceBuilders;
import org.bonitasoft.engine.xml.DocumentManager;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XpathUpdateQueryOperationExecutorStrategy
extends UpdateOperationExecutorStrategy {
    public static final String TYPE_XPATH_UPDATE_QUERY = "XPATH_UPDATE_QUERY";

    public XpathUpdateQueryOperationExecutorStrategy(DataInstanceService dataInstanceService, SDataInstanceBuilders sDataInstanceBuilders) {
        super(dataInstanceService, sDataInstanceBuilders);
    }

    @Override
    public String getOperationType() {
        return TYPE_XPATH_UPDATE_QUERY;
    }

    private String getStringValue(Object variableValue) {
        if (variableValue instanceof String) {
            return (String)variableValue;
        }
        return String.valueOf(variableValue);
    }

    private boolean isSetAttribute(String xpathExpression, Object variableValue) {
        if (variableValue instanceof Attr) {
            return true;
        }
        String[] segments = xpathExpression.split("/");
        return segments[segments.length - 1].startsWith("@");
    }

    @Override
    public Object getValue(SOperation operation, Object value, long containerId, String containerType, SExpressionContext expressionContext) throws SOperationExecutionException {
        try {
            String dataInstanceName = operation.getLeftOperand().getName();
            String dataValue = (String)expressionContext.getInputValues().get(dataInstanceName);
            SExpressionContext sExpressionContext = new SExpressionContext();
            sExpressionContext.setInputValues(expressionContext.getInputValues());
            Object variableValue = value;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(new InputSource(new StringReader(dataValue)));
            XPath xpath = XPathFactory.newInstance().newXPath();
            String xpathExpression = operation.getOperator();
            Node node = (Node)xpath.compile(xpathExpression).evaluate(document, XPathConstants.NODE);
            if (this.isSetAttribute(xpathExpression, variableValue)) {
                if (node == null) {
                    String parentPath = xpathExpression.substring(0, xpathExpression.lastIndexOf(47));
                    String attributeName = xpathExpression.substring(xpathExpression.lastIndexOf(47) + 2);
                    Node parentNode = (Node)xpath.compile(parentPath).evaluate(document, XPathConstants.NODE);
                    if (parentNode instanceof Element) {
                        Element element = (Element)parentNode;
                        if (variableValue instanceof String) {
                            element.setAttribute(attributeName, this.getStringValue(variableValue));
                        } else if (variableValue instanceof Attr) {
                            element.setAttribute(((Attr)variableValue).getName(), ((Attr)variableValue).getTextContent());
                        }
                    }
                } else if (node instanceof Attr) {
                    if (variableValue instanceof Attr) {
                        node.setTextContent(((Attr)variableValue).getTextContent());
                    } else {
                        node.setTextContent(this.getStringValue(variableValue));
                    }
                } else if (node instanceof Element) {
                    Attr attr = (Attr)variableValue;
                    ((Element)node).setAttribute(attr.getName(), attr.getValue());
                }
            } else if (node instanceof Text) {
                node.setTextContent(this.getStringValue(variableValue));
            } else if (node instanceof Element) {
                Node newNode = null;
                if (variableValue instanceof Node) {
                    newNode = document.importNode((Node)variableValue, true);
                } else if (variableValue instanceof String) {
                    newNode = document.importNode(DocumentManager.generateDocument((String)this.getStringValue(variableValue)).getDocumentElement(), true);
                }
                Node parentNode = node.getParentNode();
                parentNode.removeChild(node);
                parentNode.appendChild(newNode);
            } else if (node == null && xpathExpression.endsWith("/text()") && variableValue instanceof String) {
                String parentPath = xpathExpression.substring(0, xpathExpression.lastIndexOf(47));
                Node parentNode = (Node)xpath.compile(parentPath).evaluate(document, XPathConstants.NODE);
                parentNode.appendChild(document.createTextNode(this.getStringValue(variableValue)));
            }
            return DocumentManager.getDocumentContent((Document)document);
        }
        catch (ParserConfigurationException pce) {
            throw new SOperationExecutionException(pce);
        }
        catch (SAXException saxe) {
            throw new SOperationExecutionException(saxe);
        }
        catch (IOException ioe) {
            throw new SOperationExecutionException(ioe);
        }
        catch (XPathExpressionException xpee) {
            throw new SOperationExecutionException(xpee);
        }
        catch (TransformerConfigurationException tce) {
            throw new SOperationExecutionException(tce);
        }
        catch (TransformerFactoryConfigurationError tfce) {
            throw new SOperationExecutionException(tfce);
        }
        catch (TransformerException te) {
            throw new SOperationExecutionException(te);
        }
    }
}

