/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.core.process.definition.model.builder;

import java.util.ArrayList;
import java.util.List;
import org.bonitasoft.engine.bpm.data.DataDefinition;
import org.bonitasoft.engine.bpm.data.TextDataDefinition;
import org.bonitasoft.engine.bpm.data.XMLDataDefinition;
import org.bonitasoft.engine.core.operation.model.SOperation;
import org.bonitasoft.engine.core.operation.model.SOperatorType;
import org.bonitasoft.engine.core.operation.model.builder.SOperationBuilders;
import org.bonitasoft.engine.data.definition.model.SDataDefinition;
import org.bonitasoft.engine.data.definition.model.builder.SDataDefinitionBuilder;
import org.bonitasoft.engine.data.definition.model.builder.SDataDefinitionBuilders;
import org.bonitasoft.engine.data.definition.model.builder.SXMLDataDefinitionBuilder;
import org.bonitasoft.engine.expression.Expression;
import org.bonitasoft.engine.expression.exception.SInvalidExpressionException;
import org.bonitasoft.engine.expression.model.SExpression;
import org.bonitasoft.engine.expression.model.builder.SExpressionBuilder;
import org.bonitasoft.engine.expression.model.builder.SExpressionBuilders;
import org.bonitasoft.engine.operation.Operation;

public class ServerModelConvertor {
    public static SExpression convertExpression(SExpressionBuilders sExpressionBuilders, Expression value) {
        if (value == null) {
            return null;
        }
        ArrayList<SExpression> dependencies = new ArrayList<SExpression>();
        for (Expression expression : value.getDependencies()) {
            dependencies.add(ServerModelConvertor.convertExpression(sExpressionBuilders, expression));
        }
        SExpressionBuilder expressionBuilder = sExpressionBuilders.getExpressionBuilder();
        try {
            return expressionBuilder.createNewInstance().setName(value.getName()).setContent(value.getContent()).setExpressionType(value.getExpressionType()).setInterpreter(value.getInterpreter()).setReturnType(value.getReturnType()).setDependencies(dependencies).done();
        }
        catch (SInvalidExpressionException e) {
            throw new IllegalArgumentException("Error building SExpression", e);
        }
    }

    public static SOperation convertOperation(SOperationBuilders sOperationBuilders, SExpressionBuilders sExpressionBuilders, Operation operation) {
        return sOperationBuilders.getSOperationBuilder().createNewInstance().setOperator(operation.getOperator()).setType(SOperatorType.valueOf(operation.getType().name())).setRightOperand(ServerModelConvertor.convertExpression(sExpressionBuilders, operation.getRightOperand())).setLeftOperand(sOperationBuilders.getSLeftOperandBuilder().createNewInstance().setName(operation.getLeftOperand().getName()).done()).done();
    }

    public static List<SOperation> convertOperations(SOperationBuilders sOperationBuilders, SExpressionBuilders sExpressionBuilders, List<Operation> operations) {
        ArrayList<SOperation> sOperations = new ArrayList<SOperation>(operations.size());
        for (Operation operation : operations) {
            sOperations.add(ServerModelConvertor.convertOperation(sOperationBuilders, sExpressionBuilders, operation));
        }
        return sOperations;
    }

    public static SDataDefinition convertDataDefinition(DataDefinition dataDefinition, SDataDefinitionBuilders sDataDefinitionBuilders, SExpressionBuilders sExpressionBuilders) {
        if (dataDefinition instanceof XMLDataDefinition) {
            XMLDataDefinition xmlDataDef = (XMLDataDefinition)dataDefinition;
            SXMLDataDefinitionBuilder xmlDataDefinitionBuilder = sDataDefinitionBuilders.getXMLDataDefinitionBuilder();
            xmlDataDefinitionBuilder.createNewXMLData(dataDefinition.getName()).setElement(xmlDataDef.getElement()).setNamespace(xmlDataDef.getNamespace());
            xmlDataDefinitionBuilder.setDefaultValue(ServerModelConvertor.convertExpression(sExpressionBuilders, dataDefinition.getDefaultValueExpression()));
            xmlDataDefinitionBuilder.setDescription(dataDefinition.getDescription());
            xmlDataDefinitionBuilder.setTransient(dataDefinition.isTransientData());
            return xmlDataDefinitionBuilder.done();
        }
        SDataDefinitionBuilder dataDefinitionBuilder = sDataDefinitionBuilders.getDataDefinitionBuilder();
        if (dataDefinition instanceof TextDataDefinition) {
            TextDataDefinition textDataDefinition = (TextDataDefinition)dataDefinition;
            dataDefinitionBuilder.createNewTextData(dataDefinition.getName()).setAsLongText(textDataDefinition.isLongText());
        } else {
            dataDefinitionBuilder.createNewInstance(dataDefinition.getName(), dataDefinition.getClassName());
        }
        dataDefinitionBuilder.setDefaultValue(ServerModelConvertor.convertExpression(sExpressionBuilders, dataDefinition.getDefaultValueExpression()));
        dataDefinitionBuilder.setDescription(dataDefinition.getDescription());
        dataDefinitionBuilder.setTransient(dataDefinition.isTransientData());
        return dataDefinitionBuilder.done();
    }
}

