/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.core.process.definition.model.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.bpm.data.DataDefinition;
import org.bonitasoft.engine.bpm.flownode.ActivityDefinition;
import org.bonitasoft.engine.bpm.flownode.BoundaryEventDefinition;
import org.bonitasoft.engine.bpm.flownode.CatchEventDefinition;
import org.bonitasoft.engine.bpm.flownode.FlowNodeDefinition;
import org.bonitasoft.engine.bpm.flownode.LoopCharacteristics;
import org.bonitasoft.engine.bpm.flownode.impl.MultiInstanceLoopCharacteristics;
import org.bonitasoft.engine.bpm.flownode.impl.StandardLoopCharacteristics;
import org.bonitasoft.engine.core.operation.model.SOperation;
import org.bonitasoft.engine.core.operation.model.builder.SOperationBuilders;
import org.bonitasoft.engine.core.process.definition.model.SActivityDefinition;
import org.bonitasoft.engine.core.process.definition.model.SBoundaryEventNotFoundException;
import org.bonitasoft.engine.core.process.definition.model.SLoopCharacteristics;
import org.bonitasoft.engine.core.process.definition.model.STransitionDefinition;
import org.bonitasoft.engine.core.process.definition.model.builder.ServerModelConvertor;
import org.bonitasoft.engine.core.process.definition.model.event.SBoundaryEventDefinition;
import org.bonitasoft.engine.core.process.definition.model.event.impl.SBoundaryEventDefinitionImpl;
import org.bonitasoft.engine.core.process.definition.model.impl.SFlowNodeDefinitionImpl;
import org.bonitasoft.engine.core.process.definition.model.impl.SMultiInstanceLoopCharacteristicsImpl;
import org.bonitasoft.engine.core.process.definition.model.impl.SStandardLoopCharacteristicsImpl;
import org.bonitasoft.engine.data.definition.model.SDataDefinition;
import org.bonitasoft.engine.data.definition.model.builder.SDataDefinitionBuilders;
import org.bonitasoft.engine.expression.model.builder.SExpressionBuilders;
import org.bonitasoft.engine.operation.Operation;

public abstract class SActivityDefinitionImpl
extends SFlowNodeDefinitionImpl
implements SActivityDefinition {
    private static final long serialVersionUID = 8767258220640127769L;
    protected List<SDataDefinition> sDataDefinitions = new ArrayList<SDataDefinition>();
    protected List<SOperation> sOperations = new ArrayList<SOperation>();
    protected SLoopCharacteristics loopCharacteristics;
    private final List<SBoundaryEventDefinition> sBoundaryEventDefinitions = new ArrayList<SBoundaryEventDefinition>();

    public SActivityDefinitionImpl(long id, String name) {
        super(id, name);
    }

    public SActivityDefinitionImpl(ActivityDefinition activityDefinition, SExpressionBuilders sExpressionBuilders, Map<String, STransitionDefinition> transitionsMap, SDataDefinitionBuilders sDataDefinitionBuilders, SOperationBuilders sOperationBuilders) {
        super((FlowNodeDefinition)activityDefinition, sExpressionBuilders, transitionsMap, sOperationBuilders);
        List dataDefinitions = activityDefinition.getDataDefinitions();
        for (DataDefinition dataDefinition : dataDefinitions) {
            this.sDataDefinitions.add(ServerModelConvertor.convertDataDefinition(dataDefinition, sDataDefinitionBuilders, sExpressionBuilders));
        }
        List operations = activityDefinition.getOperations();
        for (Operation operation : operations) {
            this.sOperations.add(ServerModelConvertor.convertOperation(sOperationBuilders, sExpressionBuilders, operation));
        }
        LoopCharacteristics loop = activityDefinition.getLoopCharacteristics();
        if (loop != null) {
            this.loopCharacteristics = loop instanceof StandardLoopCharacteristics ? new SStandardLoopCharacteristicsImpl((StandardLoopCharacteristics)loop, sExpressionBuilders) : new SMultiInstanceLoopCharacteristicsImpl((MultiInstanceLoopCharacteristics)loop, sExpressionBuilders);
        }
        this.addBoundaryEvents(activityDefinition, sExpressionBuilders, transitionsMap, sDataDefinitionBuilders, sOperationBuilders);
    }

    private void addBoundaryEvents(ActivityDefinition activityDefinition, SExpressionBuilders sExpressionBuilders, Map<String, STransitionDefinition> transitionsMap, SDataDefinitionBuilders sDataDefinitionBuilders, SOperationBuilders sOperationBuilders) {
        List boundaryEventDefinitions = activityDefinition.getBoundaryEventDefinitions();
        for (BoundaryEventDefinition boundaryEventDefinition : boundaryEventDefinitions) {
            this.addBoundaryEventDefinition(new SBoundaryEventDefinitionImpl((CatchEventDefinition)boundaryEventDefinition, sExpressionBuilders, transitionsMap, sDataDefinitionBuilders, sOperationBuilders));
        }
    }

    @Override
    public List<SOperation> getSOperations() {
        return this.sOperations;
    }

    public void addSOperation(SOperation operation) {
        this.sOperations.add(operation);
    }

    @Override
    public List<SDataDefinition> getSDataDefinitions() {
        return this.sDataDefinitions;
    }

    public void addSDataDefinition(SDataDefinition sDataDefinition) {
        this.sDataDefinitions.add(sDataDefinition);
    }

    @Override
    public List<SBoundaryEventDefinition> getBoundaryEventDefinitions() {
        return Collections.unmodifiableList(this.sBoundaryEventDefinitions);
    }

    @Override
    public SBoundaryEventDefinition getBoundaryEventDefinition(String name) throws SBoundaryEventNotFoundException {
        boolean found = false;
        SBoundaryEventDefinition boundary = null;
        Iterator<SBoundaryEventDefinition> iterator = this.sBoundaryEventDefinitions.iterator();
        while (iterator.hasNext() && !found) {
            SBoundaryEventDefinition currentBoundary = iterator.next();
            if (!currentBoundary.getName().equals(name)) continue;
            boundary = currentBoundary;
            found = true;
        }
        if (boundary == null) {
            throw new SBoundaryEventNotFoundException(name, this.getName());
        }
        return boundary;
    }

    public void addBoundaryEventDefinition(SBoundaryEventDefinition boundaryEventDefinition) {
        this.sBoundaryEventDefinitions.add(boundaryEventDefinition);
    }

    @Override
    public SLoopCharacteristics getLoopCharacteristics() {
        return this.loopCharacteristics;
    }

    public void setLoopCharacteristics(SLoopCharacteristics loopCharacteristics) {
        this.loopCharacteristics = loopCharacteristics;
    }
}

