/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.core.process.definition.model.impl;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.bonitasoft.engine.bpm.actor.ActorDefinition;
import org.bonitasoft.engine.bpm.parameter.ParameterDefinition;
import org.bonitasoft.engine.bpm.process.DesignProcessDefinition;
import org.bonitasoft.engine.core.operation.model.builder.SOperationBuilders;
import org.bonitasoft.engine.core.process.definition.model.SActorDefinition;
import org.bonitasoft.engine.core.process.definition.model.SFlowElementContainerDefinition;
import org.bonitasoft.engine.core.process.definition.model.SParameterDefinition;
import org.bonitasoft.engine.core.process.definition.model.SProcessDefinition;
import org.bonitasoft.engine.core.process.definition.model.builder.ServerModelConvertor;
import org.bonitasoft.engine.core.process.definition.model.impl.SActorDefinitionImpl;
import org.bonitasoft.engine.core.process.definition.model.impl.SFlowElementContainerDefinitionImpl;
import org.bonitasoft.engine.core.process.definition.model.impl.SNamedElementImpl;
import org.bonitasoft.engine.core.process.definition.model.impl.SParameterDefinitionImpl;
import org.bonitasoft.engine.data.definition.model.builder.SDataDefinitionBuilders;
import org.bonitasoft.engine.expression.model.SExpression;
import org.bonitasoft.engine.expression.model.builder.SExpressionBuilders;

public class SProcessDefinitionImpl
extends SNamedElementImpl
implements SProcessDefinition {
    private static final long serialVersionUID = -8961400385282752731L;
    private final String version;
    private String description;
    private final Set<SParameterDefinition> parameters;
    private final Set<SActorDefinition> actors;
    private SActorDefinition sActorInitiator;
    private SFlowElementContainerDefinition container;
    private String stringIndexLabel1;
    private String stringIndexLabel2;
    private String stringIndexLabel3;
    private String stringIndexLabel4;
    private String stringIndexLabel5;
    private SExpression stringIndexValue1;
    private SExpression stringIndexValue2;
    private SExpression stringIndexValue3;
    private SExpression stringIndexValue4;
    private SExpression stringIndexValue5;

    public SProcessDefinitionImpl(DesignProcessDefinition processDefinition, SExpressionBuilders sExpressionBuilders, SDataDefinitionBuilders sDataDefinitionBuilders, SOperationBuilders sOperationBuilders) {
        super(processDefinition.getName());
        this.description = processDefinition.getDescription();
        this.version = processDefinition.getVersion();
        this.actors = new HashSet<SActorDefinition>();
        this.stringIndexLabel1 = processDefinition.getStringIndexLabel(1);
        this.stringIndexLabel2 = processDefinition.getStringIndexLabel(2);
        this.stringIndexLabel3 = processDefinition.getStringIndexLabel(3);
        this.stringIndexLabel4 = processDefinition.getStringIndexLabel(4);
        this.stringIndexLabel5 = processDefinition.getStringIndexLabel(5);
        this.stringIndexValue1 = ServerModelConvertor.convertExpression(sExpressionBuilders, processDefinition.getStringIndexValue(1));
        this.stringIndexValue2 = ServerModelConvertor.convertExpression(sExpressionBuilders, processDefinition.getStringIndexValue(2));
        this.stringIndexValue3 = ServerModelConvertor.convertExpression(sExpressionBuilders, processDefinition.getStringIndexValue(3));
        this.stringIndexValue4 = ServerModelConvertor.convertExpression(sExpressionBuilders, processDefinition.getStringIndexValue(4));
        this.stringIndexValue5 = ServerModelConvertor.convertExpression(sExpressionBuilders, processDefinition.getStringIndexValue(5));
        for (ActorDefinition actor : processDefinition.getActorsList()) {
            this.actors.add(new SActorDefinitionImpl(actor));
        }
        this.parameters = new HashSet<SParameterDefinition>();
        for (ParameterDefinition parameterDefinition : processDefinition.getParameters()) {
            this.parameters.add(new SParameterDefinitionImpl(parameterDefinition));
        }
        ActorDefinition actorInitiator = processDefinition.getActorInitiator();
        if (actorInitiator != null) {
            this.sActorInitiator = new SActorDefinitionImpl(actorInitiator);
        }
        this.container = new SFlowElementContainerDefinitionImpl(this, processDefinition.getProcessContainer(), sExpressionBuilders, sDataDefinitionBuilders, sOperationBuilders);
    }

    public SProcessDefinitionImpl(String name, String version) {
        super(name);
        this.version = version;
        this.actors = new HashSet<SActorDefinition>();
        this.parameters = new HashSet<SParameterDefinition>();
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public Set<SParameterDefinition> getParameters() {
        return this.parameters;
    }

    @Override
    public SParameterDefinition getParameter(String parameterName) {
        Iterator<SParameterDefinition> iterator = this.parameters.iterator();
        SParameterDefinition found = null;
        while (found == null && iterator.hasNext()) {
            SParameterDefinition next = iterator.next();
            if (!next.getName().equals(parameterName)) continue;
            found = next;
        }
        return found;
    }

    @Override
    public Set<SActorDefinition> getActors() {
        return this.actors;
    }

    public void addActor(SActorDefinition actor) {
        this.actors.add(actor);
    }

    public void addParameter(SParameterDefinition parameter) {
        this.parameters.add(parameter);
    }

    @Override
    public SActorDefinition getActorInitiator() {
        return this.sActorInitiator;
    }

    public void setActorInitiator(SActorDefinition sActorInitiator) {
        this.sActorInitiator = sActorInitiator;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public SFlowElementContainerDefinition getProcessContainer() {
        return this.container;
    }

    public void setProcessContainer(SFlowElementContainerDefinition processContainer) {
        this.container = processContainer;
    }

    @Override
    public String getStringIndexLabel(int index) {
        switch (index) {
            case 1: {
                return this.stringIndexLabel1;
            }
            case 2: {
                return this.stringIndexLabel2;
            }
            case 3: {
                return this.stringIndexLabel3;
            }
            case 4: {
                return this.stringIndexLabel4;
            }
            case 5: {
                return this.stringIndexLabel5;
            }
        }
        throw new IndexOutOfBoundsException("string index label must be between 1 and 5 (included)");
    }

    public void setStringIndex(int index, String label, SExpression initialValue) {
        switch (index) {
            case 1: {
                this.stringIndexLabel1 = label;
                this.stringIndexValue1 = initialValue;
                break;
            }
            case 2: {
                this.stringIndexLabel2 = label;
                this.stringIndexValue2 = initialValue;
                break;
            }
            case 3: {
                this.stringIndexLabel3 = label;
                this.stringIndexValue3 = initialValue;
                break;
            }
            case 4: {
                this.stringIndexLabel4 = label;
                this.stringIndexValue4 = initialValue;
                break;
            }
            case 5: {
                this.stringIndexLabel5 = label;
                this.stringIndexValue5 = initialValue;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("string index label must be between 1 and 5 (included)");
            }
        }
    }

    @Override
    public SExpression getStringIndexValue(int index) {
        switch (index) {
            case 1: {
                return this.stringIndexValue1;
            }
            case 2: {
                return this.stringIndexValue2;
            }
            case 3: {
                return this.stringIndexValue3;
            }
            case 4: {
                return this.stringIndexValue4;
            }
            case 5: {
                return this.stringIndexValue5;
            }
        }
        throw new IndexOutOfBoundsException("string index label must be between 1 and 5 (included)");
    }

    @Override
    public boolean hasConnectors() {
        return this.getProcessContainer().getConnectors().size() > 0;
    }
}

