/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.core.process.instance.model.builder.impl;

import org.bonitasoft.engine.core.process.definition.model.SFlowNodeType;
import org.bonitasoft.engine.core.process.instance.model.SStateCategory;
import org.bonitasoft.engine.core.process.instance.model.builder.SFlowNodeInstanceBuilder;
import org.bonitasoft.engine.core.process.instance.model.builder.impl.SFlowElementInstanceBuilderImpl;
import org.bonitasoft.engine.core.process.instance.model.impl.SFlowNodeInstanceImpl;

public abstract class SFlowNodeInstanceBuilderImpl
extends SFlowElementInstanceBuilderImpl
implements SFlowNodeInstanceBuilder {
    private static final String DISPLAY_DESCRIPTION = "displayDescription";
    private static final String DISPLAY_NAME = "displayName";
    private static final String STATE_ID_KEY = "stateId";
    private static final String STATE_NAME_KEY = "stateName";
    private static final String PREVIOUS_STATE_ID_KEY = "previousStateId";
    private static final String LAST_UPDATE_KEY = "lastUpdateDate";
    private static final String REACHED_STATE_DATE_KEY = "reachedStateDate";
    private static final String EXECUTE_BY_KEY = "executedBy";
    private static final String EXECUTE_BY_DELEGATE_KEY = "executedByDelegate";
    private static final String STATE_EXECUTING_KEY = "stateExecuting";

    protected abstract SFlowNodeInstanceImpl getEntity();

    @Override
    public SFlowNodeInstanceBuilder setState(int stateId, boolean stable, boolean terminal, String stateName) {
        this.getEntity().setStateId(stateId);
        this.getEntity().setStable(stable);
        this.getEntity().setTerminal(terminal);
        this.getEntity().setStateName(stateName);
        return this;
    }

    @Override
    public SFlowNodeInstanceBuilder setLastUpdateDate(long lastUpdateDate) {
        this.getEntity().setLastUpdateDate(lastUpdateDate);
        return this;
    }

    @Override
    public SFlowNodeInstanceBuilder setReachedStateDate(long reachedStateDate) {
        this.getEntity().setReachedStateDate(reachedStateDate);
        return this;
    }

    @Override
    public SFlowNodeInstanceBuilder setRootContainerId(long containerId) {
        this.getEntity().setRootContainerId(containerId);
        return this;
    }

    @Override
    public SFlowNodeInstanceBuilder setParentContainerId(long processInstanceId) {
        this.getEntity().setParentContainerId(processInstanceId);
        return this;
    }

    @Override
    public SFlowNodeInstanceBuilder setProcessDefinitionId(long processDefinitionId) {
        this.getEntity().setLogicalGroup(0, processDefinitionId);
        return this;
    }

    @Override
    public SFlowNodeInstanceBuilder setRootProcessInstanceId(long processInstanceId) {
        this.getEntity().setLogicalGroup(1, processInstanceId);
        return this;
    }

    @Override
    public SFlowNodeInstanceBuilder setParentProcessInstanceId(long parentProcessInstanceId) {
        this.getEntity().setLogicalGroup(3, parentProcessInstanceId);
        return this;
    }

    @Override
    public SFlowNodeInstanceBuilder setParentActivityInstanceId(long activityInstanceId) {
        this.getEntity().setLogicalGroup(2, activityInstanceId);
        return this;
    }

    @Override
    public SFlowNodeInstanceBuilder setTokenRefId(Long tokenRefId) {
        this.getEntity().setTokenRefId(tokenRefId);
        return this;
    }

    @Override
    public SFlowNodeInstanceBuilder setLoopCounter(int loopCounter) {
        this.getEntity().setLoopCounter(loopCounter);
        return this;
    }

    @Override
    public SFlowNodeInstanceBuilder setStateCategory(SStateCategory stateCategory) {
        this.getEntity().setStateCategory(stateCategory);
        return this;
    }

    @Override
    public SFlowNodeType getFlowNodeType() {
        return this.getEntity().getType();
    }

    @Override
    public String getDisplayDescriptionKey() {
        return DISPLAY_DESCRIPTION;
    }

    @Override
    public String getDisplayNameKey() {
        return DISPLAY_NAME;
    }

    @Override
    public String getStateExecutingKey() {
        return STATE_EXECUTING_KEY;
    }

    @Override
    public String getExecutedBy() {
        return EXECUTE_BY_KEY;
    }

    @Override
    public String getExecutedByDelegate() {
        return EXECUTE_BY_DELEGATE_KEY;
    }

    @Override
    public String getStateIdKey() {
        return STATE_ID_KEY;
    }

    @Override
    public String getStateNameKey() {
        return STATE_NAME_KEY;
    }

    @Override
    public String getPreviousStateIdKey() {
        return PREVIOUS_STATE_ID_KEY;
    }

    @Override
    public String getLastUpdateDateKey() {
        return LAST_UPDATE_KEY;
    }

    @Override
    public String getReachStateDateKey() {
        return REACHED_STATE_DATE_KEY;
    }
}

