/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.data;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.List;
import org.bonitasoft.engine.classloader.ClassLoaderException;
import org.bonitasoft.engine.classloader.ClassLoaderService;
import org.bonitasoft.engine.commons.LogUtil;
import org.bonitasoft.engine.data.DataService;
import org.bonitasoft.engine.data.DataSourceConfiguration;
import org.bonitasoft.engine.data.DataSourceImplementation;
import org.bonitasoft.engine.data.DataSourceImplementationProxy;
import org.bonitasoft.engine.data.SDataException;
import org.bonitasoft.engine.data.SDataSourceAlreadyExistException;
import org.bonitasoft.engine.data.SDataSourceInactiveException;
import org.bonitasoft.engine.data.SDataSourceInitializationException;
import org.bonitasoft.engine.data.SDataSourceNotFoundException;
import org.bonitasoft.engine.data.model.SDataSource;
import org.bonitasoft.engine.data.model.SDataSourceState;
import org.bonitasoft.engine.data.model.builder.SDataSourceLogBuilder;
import org.bonitasoft.engine.data.model.builder.SDataSourceModelBuilder;
import org.bonitasoft.engine.data.recorder.SelectDescriptorBuilder;
import org.bonitasoft.engine.events.EventService;
import org.bonitasoft.engine.events.model.SDeleteEvent;
import org.bonitasoft.engine.events.model.SInsertEvent;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.persistence.ReadPersistenceService;
import org.bonitasoft.engine.persistence.SBonitaReadException;
import org.bonitasoft.engine.queriablelogger.model.SQueriableLog;
import org.bonitasoft.engine.queriablelogger.model.SQueriableLogSeverity;
import org.bonitasoft.engine.queriablelogger.model.builder.HasCRUDEAction;
import org.bonitasoft.engine.queriablelogger.model.builder.SLogBuilder;
import org.bonitasoft.engine.queriablelogger.model.builder.SPersistenceLogBuilder;
import org.bonitasoft.engine.recorder.Recorder;
import org.bonitasoft.engine.recorder.SRecorderException;
import org.bonitasoft.engine.recorder.model.DeleteRecord;
import org.bonitasoft.engine.recorder.model.InsertRecord;
import org.bonitasoft.engine.services.QueriableLoggerService;

public class DataServiceImpl
implements DataService {
    private final SDataSourceModelBuilder logModelBuilder;
    private final Recorder recorder;
    private final ReadPersistenceService persistenceService;
    private final ClassLoaderService classLoaderService;
    private final EventService eventService;
    private final List<DataSourceConfiguration> dataSourceConfigurations;
    private final TechnicalLoggerService logger;
    private final QueriableLoggerService queriableLoggerService;
    protected static final String DATA_SOURCE_TYPE = "___datasource___";

    public DataServiceImpl(SDataSourceModelBuilder modelBuilder, Recorder recorder, ReadPersistenceService persistenceService, ClassLoaderService classLoaderService, EventService eventService, List<DataSourceConfiguration> dataSourceConfigurations, TechnicalLoggerService logger, QueriableLoggerService queriableLoggerService) {
        this.logModelBuilder = modelBuilder;
        this.recorder = recorder;
        this.persistenceService = persistenceService;
        this.classLoaderService = classLoaderService;
        this.eventService = eventService;
        this.dataSourceConfigurations = dataSourceConfigurations;
        this.logger = logger;
        this.queriableLoggerService = queriableLoggerService;
    }

    private SDataSourceLogBuilder getQueriableLog(HasCRUDEAction.ActionType actionType, String message) {
        SDataSourceLogBuilder logBuilder = this.logModelBuilder.getDataSourceLogBuilder();
        this.initializeLogBuilder(logBuilder, message);
        this.updateLog(actionType, logBuilder);
        return logBuilder;
    }

    private <T extends SLogBuilder> void initializeLogBuilder(T logBuilder, String message) {
        logBuilder.createNewInstance().actionStatus(0).severity(SQueriableLogSeverity.INTERNAL).rawMessage(message);
    }

    private <T extends HasCRUDEAction> void updateLog(HasCRUDEAction.ActionType actionType, T logBuilder) {
        logBuilder.setActionType(actionType);
    }

    @Override
    public <T extends DataSourceImplementation> T getDataSourceImplementation(Class<T> dataSourceType, long dataSourceId) throws SDataSourceNotFoundException, SDataSourceInitializationException, SDataSourceInactiveException, SDataException {
        SDataSource dataSource;
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "getDataSourceImplementation"));
        }
        if (!(dataSource = this.getDataSource(dataSourceId)).getState().equals((Object)SDataSourceState.ACTIVE)) {
            throw new SDataSourceInactiveException("Unable to retrieve datasource implementation for datasource: " + dataSource + " because it is not active: " + (Object)((Object)dataSource.getState()), dataSource.getState());
        }
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader dataSourceClassloader = this.classLoaderService.getLocalClassLoader(DATA_SOURCE_TYPE, dataSourceId);
            Thread.currentThread().setContextClassLoader(dataSourceClassloader);
            Class<?> clazz = Class.forName(dataSource.getImplementationClassName(), true, dataSourceClassloader);
            DataSourceImplementation dataSourceImplementation = (DataSourceImplementation)clazz.newInstance();
            this.configureDataSourceImplementation(dataSourceImplementation);
            DataSourceImplementationProxy dataSourceImplementationProxy = new DataSourceImplementationProxy(dataSourceImplementation);
            DataSourceImplementation dataSourceImplementation2 = (DataSourceImplementation)Proxy.newProxyInstance(dataSourceClassloader, new Class[]{dataSourceType}, (InvocationHandler)dataSourceImplementationProxy);
            return (T)dataSourceImplementation2;
        }
        catch (ClassLoaderException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "getDataSourceImplementation", e));
            }
            throw new SDataSourceNotFoundException("Unable to find the data source classloader", e);
        }
        catch (ClassNotFoundException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "getDataSourceImplementation", e));
            }
            throw new SDataSourceInitializationException("Unable to find data source implementation class: " + dataSource.getImplementationClassName(), e);
        }
        catch (InstantiationException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "getDataSourceImplementation", e));
            }
            throw new SDataSourceInitializationException("Unable to create data source implementation instance of class: " + dataSource.getImplementationClassName(), e);
        }
        catch (IllegalAccessException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "getDataSourceImplementation", e));
            }
            throw new SDataSourceInitializationException("Unable to create data source implementation instance of class: " + dataSource.getImplementationClassName(), e);
        }
        finally {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "getDataSourceImplementation"));
            }
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    private void configureDataSourceImplementation(DataSourceImplementation dataSourceImplementation) throws SDataSourceInitializationException {
        if (this.dataSourceConfigurations != null) {
            for (DataSourceConfiguration datasourceConfiguration : this.dataSourceConfigurations) {
                if (!dataSourceImplementation.configurationMatches(datasourceConfiguration)) continue;
                dataSourceImplementation.configure(datasourceConfiguration);
            }
        }
    }

    @Override
    public void createDataSource(SDataSource dataSource) throws SDataSourceAlreadyExistException, SDataException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "createDataSource"));
        }
        SDataSourceLogBuilder logBuilder = this.getQueriableLog(HasCRUDEAction.ActionType.CREATED, "Creating a new datasource");
        try {
            InsertRecord insertRecord = new InsertRecord(dataSource);
            SInsertEvent insertEvent = (SInsertEvent)this.eventService.getEventBuilder().createInsertEvent("DATASOURCE").setObject(dataSource).done();
            this.recorder.recordInsert(insertRecord, insertEvent);
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "createDataSource"));
            }
            this.initiateLogBuilder(dataSource.getId(), 1, logBuilder, "createDataSource");
        }
        catch (SRecorderException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "createDataSource", e));
            }
            this.initiateLogBuilder(dataSource.getId(), 0, logBuilder, "createDataSource");
            try {
                this.getDataSource(dataSource.getName(), dataSource.getVersion());
                throw new SDataSourceAlreadyExistException(dataSource.getName(), dataSource.getVersion());
            }
            catch (SDataSourceNotFoundException e1) {
                throw new SDataException("can't add datasource " + dataSource, e);
            }
        }
    }

    @Override
    public SDataSource getDataSource(long dataSourceId) throws SDataSourceNotFoundException {
        try {
            SDataSource dataSource;
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "getDataSource"));
            }
            if ((dataSource = this.persistenceService.selectById(SelectDescriptorBuilder.getElementById(SDataSource.class, "DataSource", dataSourceId))) == null) {
                throw new SDataSourceNotFoundException("can't get the datasource with id " + dataSourceId, null);
            }
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "getDataSource"));
            }
            return dataSource;
        }
        catch (SBonitaReadException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "getDataSource", e));
            }
            throw new SDataSourceNotFoundException("can't get the datasource with id " + dataSourceId, e);
        }
    }

    @Override
    public SDataSource getDataSource(String name, String version) throws SDataSourceNotFoundException {
        try {
            SDataSource dataSource;
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "getDataSource"));
            }
            if ((dataSource = this.persistenceService.selectOne(SelectDescriptorBuilder.getDataSource(name, version))) == null) {
                throw new SDataSourceNotFoundException("can't get the datasource with name: " + name + " and version: " + version, null);
            }
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "getDataSource"));
            }
            return dataSource;
        }
        catch (SBonitaReadException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "getDataSource", e));
            }
            throw new SDataSourceNotFoundException("can't get the datasource with name: " + name + " and version: " + version, e);
        }
    }

    @Override
    public void removeDataSource(SDataSource dataSource) throws SDataSourceNotFoundException {
        SDataSourceLogBuilder logBuilder = this.getQueriableLog(HasCRUDEAction.ActionType.DELETED, "Deleting a DataSource");
        try {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "removeDataSource"));
            }
            DeleteRecord deleteRecord = new DeleteRecord(dataSource);
            SDeleteEvent deleteEvent = (SDeleteEvent)this.eventService.getEventBuilder().createDeleteEvent("DATASOURCE").setObject(dataSource).done();
            this.recorder.recordDelete(deleteRecord, deleteEvent);
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "removeDataSource"));
            }
            this.initiateLogBuilder(dataSource.getId(), 1, logBuilder, "removeDataSource");
        }
        catch (SRecorderException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "removeDataSource", e));
            }
            this.initiateLogBuilder(dataSource.getId(), 0, logBuilder, "removeDataSource");
            throw new SDataSourceNotFoundException("can't delete datasource " + dataSource, e);
        }
    }

    @Override
    public void removeDataSource(long dataSourceId) throws SDataSourceNotFoundException {
        this.removeDataSource(this.getDataSource(dataSourceId));
    }

    private void initiateLogBuilder(long objectId, int sQueriableLogStatus, SPersistenceLogBuilder logBuilder, String callerMethodName) {
        logBuilder.actionScope(String.valueOf(objectId));
        logBuilder.actionStatus(sQueriableLogStatus);
        logBuilder.objectId(objectId);
        SQueriableLog log = logBuilder.done();
        if (this.queriableLoggerService.isLoggable(log.getActionType(), log.getSeverity())) {
            this.queriableLoggerService.log(this.getClass().getName(), callerMethodName, log);
        }
    }
}

