/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.data.recorder;

import java.util.HashMap;
import org.bonitasoft.engine.data.model.SDataSource;
import org.bonitasoft.engine.data.model.SDataSourceParameter;
import org.bonitasoft.engine.persistence.PersistentObject;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.persistence.SelectByIdDescriptor;
import org.bonitasoft.engine.persistence.SelectListDescriptor;
import org.bonitasoft.engine.persistence.SelectOneDescriptor;

public class SelectDescriptorBuilder {
    public static <T extends PersistentObject> SelectByIdDescriptor<T> getElementById(Class<T> clazz, String elementName, long id) {
        return new SelectByIdDescriptor<T>("get" + elementName + "ById", clazz, id);
    }

    public static SelectOneDescriptor<SDataSource> getDataSource(String name, String version) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("name", name);
        parameters.put("version", version);
        return new SelectOneDescriptor<SDataSource>("getDataSourceByNameAndVersion", parameters, SDataSource.class);
    }

    public static SelectOneDescriptor<SDataSourceParameter> getDataSourceParameter(String name, long dataSourceId) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("name", name);
        parameters.put("dataSourceId", dataSourceId);
        return new SelectOneDescriptor<SDataSourceParameter>("getDataSourceParameterByNameAndDataSourceId", parameters, SDataSourceParameter.class);
    }

    public static SelectListDescriptor<SDataSourceParameter> getDataSourceParameters(long dataSourceId, QueryOptions queryOptions) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("dataSourceId", dataSourceId);
        return new SelectListDescriptor<SDataSourceParameter>("getDataSourceParametersByDataSourceId", parameters, SDataSourceParameter.class, queryOptions);
    }

    public static SelectListDescriptor<SDataSource> getDataSources(QueryOptions queryOptions) {
        return new SelectListDescriptor<SDataSource>("getDataSources", null, SDataSource.class, queryOptions);
    }
}

