/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.document.impl;

import java.util.HashMap;
import java.util.UUID;
import org.bonitasoft.engine.commons.ClassReflector;
import org.bonitasoft.engine.commons.NullCheckingUtil;
import org.bonitasoft.engine.document.DocumentService;
import org.bonitasoft.engine.document.SDocumentContentNotFoundException;
import org.bonitasoft.engine.document.SDocumentDeletionException;
import org.bonitasoft.engine.document.SDocumentStorageException;
import org.bonitasoft.engine.document.model.SDocument;
import org.bonitasoft.engine.document.model.SDocumentBuilders;
import org.bonitasoft.engine.document.model.SDocumentContent;
import org.bonitasoft.engine.document.model.SDocumentContentBuilder;
import org.bonitasoft.engine.events.model.SDeleteEvent;
import org.bonitasoft.engine.events.model.SInsertEvent;
import org.bonitasoft.engine.events.model.builders.SEventBuilders;
import org.bonitasoft.engine.persistence.ReadPersistenceService;
import org.bonitasoft.engine.persistence.SBonitaReadException;
import org.bonitasoft.engine.persistence.SelectOneDescriptor;
import org.bonitasoft.engine.recorder.Recorder;
import org.bonitasoft.engine.recorder.SRecorderException;
import org.bonitasoft.engine.recorder.model.DeleteRecord;
import org.bonitasoft.engine.recorder.model.InsertRecord;

public class DocumentServiceImpl
implements DocumentService {
    private final Recorder recorder;
    private final SEventBuilders eventBuilders;
    private final ReadPersistenceService persistenceService;
    private final SDocumentBuilders documentBuilders;

    public DocumentServiceImpl(Recorder recorder, SEventBuilders eventBuilders, ReadPersistenceService persistenceService, SDocumentBuilders documentBuilders) {
        this.recorder = recorder;
        this.eventBuilders = eventBuilders;
        this.persistenceService = persistenceService;
        this.documentBuilders = documentBuilders;
    }

    @Override
    public byte[] getContent(String documentId) throws SDocumentContentNotFoundException {
        return this.getDocumentContent(documentId).getContent();
    }

    @Override
    public SDocument storeDocumentContent(SDocument sDocument, byte[] documentContent) throws SDocumentStorageException {
        String documentId = String.valueOf(UUID.randomUUID().getLeastSignificantBits());
        SDocumentContent sdocumentContent = this.createDocumentContent(documentId, documentContent);
        InsertRecord insertRecord = new InsertRecord(sdocumentContent);
        SInsertEvent insertEvent = (SInsertEvent)this.eventBuilders.getEventBuilder().createInsertEvent("SDocumentContent").setObject(sdocumentContent).done();
        try {
            this.recorder.recordInsert(insertRecord, insertEvent);
        }
        catch (SRecorderException re) {
            throw new SDocumentStorageException(re);
        }
        try {
            ClassReflector.invokeSetter(sDocument, "setId", String.class, documentId);
        }
        catch (Throwable e) {
            throw new SDocumentStorageException(e);
        }
        return sDocument;
    }

    @Override
    public void deleteDocumentContent(String documentId) throws SDocumentDeletionException, SDocumentContentNotFoundException {
        SDocumentContent sdocumentContent = null;
        try {
            sdocumentContent = this.getDocumentContent(documentId);
            DeleteRecord deleteRecord = new DeleteRecord(sdocumentContent);
            SDeleteEvent deleteEvent = (SDeleteEvent)this.eventBuilders.getEventBuilder().createDeleteEvent("SDocumentContent").setObject(sdocumentContent).done();
            this.recorder.recordDelete(deleteRecord, deleteEvent);
        }
        catch (SRecorderException e) {
            throw new SDocumentDeletionException("can't delete Document content " + sdocumentContent, e);
        }
    }

    private SDocumentContent createDocumentContent(String storageId, byte[] content) {
        SDocumentContentBuilder dcontentBuilder = this.documentBuilders.getSDocumentContentBuilder();
        dcontentBuilder.createNewInstance();
        dcontentBuilder.setStorageId(storageId).setContent(content);
        return dcontentBuilder.done();
    }

    private SDocumentContent getDocumentContent(String documentId) throws SDocumentContentNotFoundException {
        NullCheckingUtil.checkArgsNotNull(documentId);
        HashMap<String, Object> inputParameters = new HashMap<String, Object>();
        inputParameters.put("documentId", documentId);
        try {
            SelectOneDescriptor selectDescriptor = new SelectOneDescriptor("getDocContentByDocumentId", inputParameters, SDocumentContent.class);
            SDocumentContent docContent = (SDocumentContent)this.persistenceService.selectOne(selectDescriptor);
            if (docContent == null) {
                throw new SDocumentContentNotFoundException("Cannot get the DocumentContent with documentID:" + documentId);
            }
            return docContent;
        }
        catch (SBonitaReadException e) {
            throw new SDocumentContentNotFoundException("Cannot get the DocumentContent with documentID:" + documentId, e);
        }
    }
}

